/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Devices;
import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.androidtools.P7ZipCommand;
import com.android.tools.build.bundletool.commands.AutoValue_BuildApksCommand;
import com.android.tools.build.bundletool.commands.BuildApksManager;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.CommandUtils;
import com.android.tools.build.bundletool.commands.DaggerBuildApksManagerComponent;
import com.android.tools.build.bundletool.commands.DebugKeystoreUtils;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.DeviceSpecParser;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.ApkListener;
import com.android.tools.build.bundletool.model.ApkModifier;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.KeystoreProperties;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.Password;
import com.android.tools.build.bundletool.model.SdkAsar;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.SigningConfigurationProvider;
import com.android.tools.build.bundletool.model.SourceStamp;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.BundleParser;
import com.android.tools.build.bundletool.model.utils.DefaultSystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.android.tools.build.bundletool.preprocessors.AppBundlePreprocessorManager;
import com.android.tools.build.bundletool.preprocessors.DaggerAppBundlePreprocessorComponent;
import com.android.tools.build.bundletool.validation.AppBundleValidator;
import com.android.tools.build.bundletool.validation.SdkAsarValidator;
import com.android.tools.build.bundletool.validation.SdkBundleValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.google.common.io.MoreFiles;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import shadow.bundletool.com.android.apksig.SigningCertificateLineage;
import shadow.bundletool.com.android.apksig.apk.ApkFormatException;
import shadow.bundletool.com.android.apksig.util.DataSource;
import shadow.bundletool.com.android.apksig.util.DataSources;

@AutoValue
public abstract class BuildApksCommand {
    private static final int DEFAULT_THREAD_POOL_SIZE = 4;
    public static final String COMMAND_NAME = "build-apks";
    private static final Logger logger = Logger.getLogger(BuildApksCommand.class.getName());
    private static final Flag<Path> BUNDLE_LOCATION_FLAG = Flag.path("bundle");
    private static final Flag<Path> OUTPUT_FILE_FLAG = Flag.path("output");
    private static final Flag<OutputFormat> OUTPUT_FORMAT_FLAG = Flag.enumFlag("output-format", OutputFormat.class);
    private static final Flag<Boolean> OVERWRITE_OUTPUT_FLAG = Flag.booleanFlag("overwrite");
    private static final Flag<ImmutableSet<OptimizationDimension>> OPTIMIZE_FOR_FLAG = Flag.enumSet("optimize-for", OptimizationDimension.class);
    private static final Flag<Path> AAPT2_PATH_FLAG = Flag.path("aapt2");
    private static final Flag<Integer> MAX_THREADS_FLAG = Flag.positiveInteger("max-threads");
    private static final Flag<ApkBuildMode> BUILD_MODE_FLAG = Flag.enumFlag("mode", ApkBuildMode.class);
    private static final Flag<Boolean> LOCAL_TESTING_MODE_FLAG = Flag.booleanFlag("local-testing");
    private static final Flag<Path> ADB_PATH_FLAG = Flag.path("adb");
    private static final Flag<Boolean> CONNECTED_DEVICE_FLAG = Flag.booleanFlag("connected-device");
    private static final Flag<String> DEVICE_ID_FLAG = Flag.string("device-id");
    private static final Flag<ImmutableSet<String>> MODULES_FLAG = Flag.stringSet("modules");
    private static final Flag<Path> DEVICE_SPEC_FLAG = Flag.path("device-spec");
    private static final Flag<Boolean> FUSE_ONLY_DEVICE_MATCHING_MODULES_FLAG = Flag.booleanFlag("fuse-only-device-matching-modules");
    private static final Flag<ImmutableSet<SystemApkOption>> SYSTEM_APK_OPTIONS = Flag.enumSet("system-apk-options", SystemApkOption.class);
    private static final Flag<Integer> DEVICE_TIER_FLAG = Flag.nonNegativeInteger("device-tier");
    private static final Flag<Boolean> VERBOSE_FLAG = Flag.booleanFlag("verbose");
    private static final Flag<Path> P7ZIP_PATH_FLAG = Flag.path("7zip");
    private static final Flag<Path> KEYSTORE_FLAG = Flag.path("ks");
    private static final Flag<String> KEY_ALIAS_FLAG = Flag.string("ks-key-alias");
    private static final Flag<Password> KEYSTORE_PASSWORD_FLAG = Flag.password("ks-pass");
    private static final Flag<Password> KEY_PASSWORD_FLAG = Flag.password("key-pass");
    private static final Flag<Boolean> CREATE_STAMP_FLAG = Flag.booleanFlag("create-stamp");
    private static final Flag<Path> STAMP_KEYSTORE_FLAG = Flag.path("stamp-ks");
    private static final Flag<Password> STAMP_KEYSTORE_PASSWORD_FLAG = Flag.password("stamp-ks-pass");
    private static final Flag<String> STAMP_KEY_ALIAS_FLAG = Flag.string("stamp-key-alias");
    private static final Flag<Password> STAMP_KEY_PASSWORD_FLAG = Flag.password("stamp-key-pass");
    private static final Flag<String> STAMP_SOURCE_FLAG = Flag.string("stamp-source");
    private static final Flag<Boolean> STAMP_EXCLUDE_TIMESTAMP = Flag.booleanFlag("stamp-exclude-timestamp");
    private static final Flag<Integer> MINIMUM_V3_ROTATION_API_VERSION_FLAG = Flag.positiveInteger("min-v3-rotation-api-version");
    private static final Flag<Integer> ROTATION_MINIMUM_SDK_VERSION_FLAG = Flag.positiveInteger("rotation-min-sdk-version");
    private static final Flag<Path> LINEAGE_FLAG = Flag.path("lineage");
    private static final Flag<Path> OLDEST_SIGNER_FLAG = Flag.path("oldest-signer");
    private static final Flag<ImmutableSet<Path>> RUNTIME_ENABLED_SDK_BUNDLE_LOCATIONS_FLAG = Flag.pathSet("sdk-bundles");
    private static final Flag<ImmutableSet<Path>> RUNTIME_ENABLED_SDK_ARCHIVE_LOCATIONS_FLAG = Flag.pathSet("sdk-archives");
    private static final Flag<String> APP_STORE_PACKAGE_NAME_FLAG = Flag.string("store-package");
    private static final String APK_SET_ARCHIVE_EXTENSION = "apks";
    private static final SystemEnvironmentProvider DEFAULT_PROVIDER = new DefaultSystemEnvironmentProvider();
    private static final int ZIP_MAGIC = 67324752;

    public abstract Path getBundlePath();

    public abstract Path getOutputFile();

    public abstract boolean getOverwriteOutput();

    public abstract ImmutableSet<OptimizationDimension> getOptimizationDimensions();

    public abstract ImmutableSet<String> getModules();

    public abstract Optional<Devices.DeviceSpec> getDeviceSpec();

    public abstract boolean getFuseOnlyDeviceMatchingModules();

    public abstract Optional<Integer> getDeviceTier();

    public abstract ImmutableSet<SystemApkOption> getSystemApkOptions();

    public abstract boolean getGenerateOnlyForConnectedDevice();

    public abstract Optional<String> getDeviceId();

    abstract Optional<AdbServer> getAdbServer();

    public abstract Optional<Path> getAdbPath();

    public abstract ApkBuildMode getApkBuildMode();

    public abstract boolean getLocalTestingMode();

    public abstract boolean getVerbose();

    public abstract Optional<Aapt2Command> getAapt2Command();

    public abstract Optional<SigningConfiguration> getSigningConfiguration();

    public abstract Optional<SigningConfigurationProvider> getSigningConfigurationProvider();

    public abstract Optional<Integer> getMinSdkForAdditionalVariantWithV3Rotation();

    ListeningExecutorService getExecutorService() {
        return this.getExecutorServiceInternal();
    }

    abstract ListeningExecutorService getExecutorServiceInternal();

    abstract boolean isExecutorServiceCreatedByBundleTool();

    public abstract OutputFormat getOutputFormat();

    public abstract Optional<ApkListener> getApkListener();

    public abstract Optional<ApkModifier> getApkModifier();

    public abstract ImmutableList<SubValidator> getExtraValidators();

    public abstract Optional<Integer> getFirstVariantNumber();

    public abstract Optional<PrintStream> getOutputPrintStream();

    public abstract Optional<SourceStamp> getSourceStamp();

    public abstract Optional<Long> getAssetModulesVersionOverride();

    public abstract boolean getEnableApkSerializerWithoutBundleRecompression();

    public abstract Optional<P7ZipCommand> getP7ZipCommand();

    public abstract ImmutableSet<Path> getRuntimeEnabledSdkBundlePaths();

    public abstract ImmutableSet<Path> getRuntimeEnabledSdkArchivePaths();

    public abstract Optional<String> getAppStorePackageName();

    public static Builder builder() {
        return new AutoValue_BuildApksCommand.Builder().setOverwriteOutput(false).setApkBuildMode(ApkBuildMode.DEFAULT).setLocalTestingMode(false).setGenerateOnlyForConnectedDevice(false).setOutputFormat(OutputFormat.APK_SET).setVerbose(false).setOptimizationDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of()).setModules((ImmutableSet<String>)ImmutableSet.of()).setFuseOnlyDeviceMatchingModules(false).setExtraValidators((ImmutableList<SubValidator>)ImmutableList.of()).setSystemApkOptions((ImmutableSet<SystemApkOption>)ImmutableSet.of()).setEnableApkSerializerWithoutBundleRecompression(true).setRuntimeEnabledSdkBundlePaths((ImmutableSet<Path>)ImmutableSet.of()).setRuntimeEnabledSdkArchivePaths((ImmutableSet<Path>)ImmutableSet.of());
    }

    public static BuildApksCommand fromFlags(ParsedFlags flags, AdbServer adbServer) {
        return BuildApksCommand.fromFlags(flags, System.out, DEFAULT_PROVIDER, adbServer);
    }

    static BuildApksCommand fromFlags(ParsedFlags flags, PrintStream out, SystemEnvironmentProvider systemEnvironmentProvider, AdbServer adbServer) {
        ApkBuildMode apkBuildMode;
        boolean supportsPartialDeviceSpecs;
        Builder buildApksCommand = BuildApksCommand.builder().setBundlePath(BUNDLE_LOCATION_FLAG.getRequiredValue(flags)).setOutputFile(OUTPUT_FILE_FLAG.getRequiredValue(flags)).setOutputPrintStream(out);
        OUTPUT_FORMAT_FLAG.getValue(flags).ifPresent(buildApksCommand::setOutputFormat);
        OVERWRITE_OUTPUT_FLAG.getValue(flags).ifPresent(buildApksCommand::setOverwriteOutput);
        AAPT2_PATH_FLAG.getValue(flags).ifPresent(aapt2Path -> buildApksCommand.setAapt2Command(Aapt2Command.createFromExecutablePath(aapt2Path)));
        BUILD_MODE_FLAG.getValue(flags).ifPresent(buildApksCommand::setApkBuildMode);
        LOCAL_TESTING_MODE_FLAG.getValue(flags).ifPresent(buildApksCommand::setLocalTestingMode);
        MAX_THREADS_FLAG.getValue(flags).ifPresent(maxThreads -> buildApksCommand.setExecutorService(BuildApksCommand.createInternalExecutorService(maxThreads)).setExecutorServiceCreatedByBundleTool(true));
        OPTIMIZE_FOR_FLAG.getValue(flags).ifPresent(buildApksCommand::setOptimizationDimensions);
        BuildApksCommand.populateSigningConfigurationFromFlags(buildApksCommand, flags, out, systemEnvironmentProvider);
        BuildApksCommand.populateSourceStampFromFlags(buildApksCommand, flags, out, systemEnvironmentProvider);
        boolean connectedDeviceMode = CONNECTED_DEVICE_FLAG.getValue(flags).orElse(false);
        CONNECTED_DEVICE_FLAG.getValue(flags).ifPresent(buildApksCommand::setGenerateOnlyForConnectedDevice);
        Optional<String> deviceSerialName = DEVICE_ID_FLAG.getValue(flags);
        if (connectedDeviceMode && !deviceSerialName.isPresent()) {
            deviceSerialName = systemEnvironmentProvider.getVariable("ANDROID_SERIAL");
        }
        deviceSerialName.ifPresent(buildApksCommand::setDeviceId);
        if (connectedDeviceMode) {
            Path adbPath = CommandUtils.getAdbPath(flags, ADB_PATH_FLAG, systemEnvironmentProvider);
            buildApksCommand.setAdbPath(adbPath).setAdbServer(adbServer);
        }
        Function deviceSpecParser = (supportsPartialDeviceSpecs = (apkBuildMode = BUILD_MODE_FLAG.getValue(flags).orElse(ApkBuildMode.DEFAULT)).equals((Object)ApkBuildMode.SYSTEM)) ? DeviceSpecParser::parsePartialDeviceSpec : DeviceSpecParser::parseDeviceSpec;
        FUSE_ONLY_DEVICE_MATCHING_MODULES_FLAG.getValue(flags).ifPresent(buildApksCommand::setFuseOnlyDeviceMatchingModules);
        Optional<ImmutableSet<SystemApkOption>> systemApkOptions = SYSTEM_APK_OPTIONS.getValue(flags);
        if (systemApkOptions.isPresent() && !apkBuildMode.equals((Object)ApkBuildMode.SYSTEM)) {
            throw InvalidCommandException.builder().withInternalMessage("'%s' flag is available in system mode only.", SYSTEM_APK_OPTIONS.getName()).build();
        }
        systemApkOptions.ifPresent(buildApksCommand::setSystemApkOptions);
        DEVICE_SPEC_FLAG.getValue(flags).map(deviceSpecParser).ifPresent(buildApksCommand::setDeviceSpec);
        DEVICE_TIER_FLAG.getValue(flags).ifPresent(buildApksCommand::setDeviceTier);
        MODULES_FLAG.getValue(flags).ifPresent(buildApksCommand::setModules);
        VERBOSE_FLAG.getValue(flags).ifPresent(buildApksCommand::setVerbose);
        P7ZIP_PATH_FLAG.getValue(flags).ifPresent(p7zipPath -> {
            int numThreads = MAX_THREADS_FLAG.getValue(flags).orElse(4);
            buildApksCommand.setP7ZipCommand(P7ZipCommand.defaultP7ZipCommand(p7zipPath, numThreads));
        });
        if (RUNTIME_ENABLED_SDK_BUNDLE_LOCATIONS_FLAG.getValue(flags).isPresent() && RUNTIME_ENABLED_SDK_ARCHIVE_LOCATIONS_FLAG.getValue(flags).isPresent()) {
            throw InvalidCommandException.builder().withInternalMessage("Only one of '%s' and '%s' flags can be set.", RUNTIME_ENABLED_SDK_BUNDLE_LOCATIONS_FLAG.getName(), RUNTIME_ENABLED_SDK_ARCHIVE_LOCATIONS_FLAG.getName()).build();
        }
        RUNTIME_ENABLED_SDK_BUNDLE_LOCATIONS_FLAG.getValue(flags).ifPresent(buildApksCommand::setRuntimeEnabledSdkBundlePaths);
        RUNTIME_ENABLED_SDK_ARCHIVE_LOCATIONS_FLAG.getValue(flags).ifPresent(buildApksCommand::setRuntimeEnabledSdkArchivePaths);
        APP_STORE_PACKAGE_NAME_FLAG.getValue(flags).ifPresent(buildApksCommand::setAppStorePackageName);
        flags.checkNoUnknownFlags();
        return buildApksCommand.build();
    }

    public Path execute() {
        Path outputDirectory;
        this.validateInput();
        Path path = outputDirectory = this.getOutputFormat().equals((Object)OutputFormat.APK_SET) ? this.getOutputFile().getParent() : this.getOutputFile();
        if (outputDirectory != null && Files.notExists(outputDirectory, new LinkOption[0])) {
            logger.info("Output directory '" + outputDirectory + "' does not exist, creating it.");
            FileUtils.createDirectories(outputDirectory);
        }
        try (TempDirectory tempDir = new TempDirectory(this.getClass().getSimpleName());
             ZipFile bundleZip = new ZipFile(this.getBundlePath().toFile());
             Closer closer = Closer.create();){
            AppBundleValidator bundleValidator = AppBundleValidator.create(this.getExtraValidators());
            bundleValidator.validateFile(bundleZip);
            AppBundle appBundle = AppBundle.buildFromZip(bundleZip);
            bundleValidator.validate(appBundle);
            this.validateRuntimeEnabledSdkDependencies(closer, tempDir, appBundle);
            AppBundlePreprocessorManager appBundlePreprocessorManager = DaggerAppBundlePreprocessorComponent.builder().setBuildApksCommand(this).build().create();
            AppBundle preprocessedAppBundle = appBundlePreprocessorManager.processAppBundle(appBundle);
            BuildApksManager buildApksManager = DaggerBuildApksManagerComponent.builder().setBuildApksCommand(this).setTempDirectory(tempDir).setAppBundle(preprocessedAppBundle).build().create();
            buildApksManager.execute();
        }
        catch (ZipException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("The App Bundle is not a valid zip file.").build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException("An error occurred when processing the App Bundle.", e12);
        }
        finally {
            if (this.isExecutorServiceCreatedByBundleTool()) {
                this.getExecutorService().shutdown();
            }
        }
        return this.getOutputFile();
    }

    private void validateInput() {
        FilePreconditions.checkFileExistsAndReadable(this.getBundlePath());
        switch (this.getOutputFormat()) {
            case APK_SET: {
                if (this.getOverwriteOutput()) break;
                FilePreconditions.checkFileDoesNotExist(this.getOutputFile());
                break;
            }
            case DIRECTORY: {
                if (!this.getOverwriteOutput()) break;
                throw InvalidCommandException.builder().withInternalMessage("'%s' flag is not supported for '%s' output format.", new Object[]{OVERWRITE_OUTPUT_FLAG.getName(), OutputFormat.DIRECTORY}).build();
            }
        }
        if (this.getGenerateOnlyForConnectedDevice()) {
            Preconditions.checkArgument((boolean)this.getAdbServer().isPresent(), (Object)"Property 'adbServer' is required when 'generateOnlyForConnectedDevice' is true.");
            Preconditions.checkArgument((boolean)this.getAdbPath().isPresent(), (Object)"Property 'adbPath' is required when 'generateOnlyForConnectedDevice' is true.");
            FilePreconditions.checkFileExistsAndExecutable(this.getAdbPath().get());
        }
        this.getRuntimeEnabledSdkBundlePaths().forEach(path -> {
            FilePreconditions.checkFileExistsAndReadable(path);
            FilePreconditions.checkFileHasExtension("ASB file", path, ".asb");
        });
        this.getRuntimeEnabledSdkArchivePaths().forEach(path -> {
            FilePreconditions.checkFileExistsAndReadable(path);
            FilePreconditions.checkFileHasExtension("ASAR file", path, ".asar");
        });
    }

    private void validateRuntimeEnabledSdkDependencies(Closer closer, TempDirectory tempDir, AppBundle appBundle) throws IOException {
        if (!this.getRuntimeEnabledSdkArchivePaths().isEmpty()) {
            BuildApksCommand.validateSdkAsarsMatchAppBundleDependencies(appBundle, this.getValidatedSdkAsarsByPackageName(closer, tempDir));
        } else {
            BuildApksCommand.validateSdkBundlesMatchAppBundleDependencies(appBundle, this.getValidatedSdkBundlesByPackageName(closer, tempDir));
        }
    }

    private ImmutableMap<String, SdkAsar> getValidatedSdkAsarsByPackageName(Closer closer, TempDirectory tempDir) throws IOException {
        ImmutableListMultimap.Builder sdkArchivesPerPackageNameBuilder = ImmutableListMultimap.builder();
        ImmutableList sdkArchivePaths = this.getRuntimeEnabledSdkArchivePaths().asList();
        for (int index = 0; index < sdkArchivePaths.size(); ++index) {
            ZipFile sdkArchiveZip = (ZipFile)closer.register((Closeable)new ZipFile(((Path)sdkArchivePaths.get(index)).toFile()));
            Path sdkModulesZipPath = tempDir.getPath().resolve("tmp" + index);
            ZipFile sdkModulesZip = (ZipFile)closer.register((Closeable)BundleParser.getModulesZip(sdkArchiveZip, sdkModulesZipPath));
            SdkAsarValidator.validateModulesFile(sdkModulesZip);
            SdkAsar sdkArchive = SdkAsar.buildFromZip(sdkArchiveZip, sdkModulesZip, sdkModulesZipPath);
            sdkArchivesPerPackageNameBuilder.put((Object)sdkArchive.getPackageName(), (Object)sdkArchive);
        }
        ImmutableMap sdkArchivesPerPackageName = sdkArchivesPerPackageNameBuilder.build().asMap();
        sdkArchivesPerPackageName.entrySet().forEach(entry -> {
            if (((Collection)entry.getValue()).size() > 1) {
                throw InvalidCommandException.builder().withInternalMessage("Received multiple SDK archives with the same package name: %s.", entry.getKey()).build();
            }
        });
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)sdkArchivesPerPackageName, Iterables::getOnlyElement));
    }

    private static void validateSdkAsarsMatchAppBundleDependencies(AppBundle appBundle, ImmutableMap<String, SdkAsar> sdkArchives) {
        appBundle.getRuntimeEnabledSdkDependencies().keySet().forEach(sdkPackageName -> {
            if (!sdkArchives.containsKey(sdkPackageName)) {
                throw InvalidCommandException.builder().withInternalMessage("App bundle depends on SDK '%s', but no ASAR was provided.", sdkPackageName).build();
            }
            RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk sdkDependencyFromAppBundle = (RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk)appBundle.getRuntimeEnabledSdkDependencies().get(sdkPackageName);
            SdkAsar sdkArchive = (SdkAsar)sdkArchives.get(sdkPackageName);
            if (sdkDependencyFromAppBundle.getVersionMajor() != sdkArchive.getMajorVersion()) {
                throw InvalidCommandException.builder().withInternalMessage("App bundle depends on SDK '%s' with major version '%d', but provided SDK archive has major version '%d'.", sdkPackageName, sdkDependencyFromAppBundle.getVersionMajor(), sdkArchive.getMajorVersion()).build();
            }
            if (sdkDependencyFromAppBundle.getVersionMinor() != sdkArchive.getMinorVersion()) {
                throw InvalidCommandException.builder().withInternalMessage("App bundle depends on SDK '%s' with minor version '%d', but provided SDK archive has minor version '%d'.", sdkPackageName, sdkDependencyFromAppBundle.getVersionMinor(), sdkArchive.getMinorVersion()).build();
            }
            if (!sdkDependencyFromAppBundle.getCertificateDigest().equals(sdkArchive.getCertificateDigest())) {
                throw InvalidCommandException.builder().withInternalMessage("App bundle depends on SDK '%s' with signing certificate '%s', but provided ASAR is for SDK with signing certificate '%s'.", sdkPackageName, sdkDependencyFromAppBundle.getCertificateDigest(), sdkArchive.getCertificateDigest()).build();
            }
        });
        sdkArchives.keySet().forEach(sdkPackageName -> {
            if (!appBundle.getRuntimeEnabledSdkDependencies().containsKey(sdkPackageName)) {
                throw InvalidCommandException.builder().withInternalMessage("App bundle does not depend on SDK '%s', but SDK archive was provided.", sdkPackageName).build();
            }
        });
    }

    private ImmutableMap<String, SdkBundle> getValidatedSdkBundlesByPackageName(Closer closer, TempDirectory tempDir) throws IOException {
        SdkBundleValidator sdkBundleValidator = SdkBundleValidator.create();
        ImmutableListMultimap.Builder sdkBundlesPerPackageNameBuilder = ImmutableListMultimap.builder();
        ImmutableList sdkBundlePaths = this.getRuntimeEnabledSdkBundlePaths().asList();
        for (int index = 0; index < sdkBundlePaths.size(); ++index) {
            Path sdkBundlePath = (Path)sdkBundlePaths.get(index);
            ZipFile sdkBundleZip = (ZipFile)closer.register((Closeable)new ZipFile(sdkBundlePath.toFile()));
            sdkBundleValidator.validateFile(sdkBundleZip);
            ZipFile sdkModulesZip = (ZipFile)closer.register((Closeable)BundleParser.getModulesZip(sdkBundleZip, tempDir.getPath().resolve("tmp" + index)));
            sdkBundleValidator.validateModulesFile(sdkModulesZip);
            SdkBundle sdkBundle = SdkBundle.buildFromZip(sdkBundleZip, sdkModulesZip, 0);
            sdkBundlesPerPackageNameBuilder.put((Object)sdkBundle.getPackageName(), (Object)sdkBundle);
        }
        ImmutableMap sdkBundlesPerPackageName = sdkBundlesPerPackageNameBuilder.build().asMap();
        sdkBundlesPerPackageName.entrySet().forEach(entry -> {
            if (((Collection)entry.getValue()).size() > 1) {
                throw InvalidCommandException.builder().withInternalMessage("Received multiple SDK bundles with the same package name: %s.", entry.getKey()).build();
            }
            sdkBundleValidator.validate((SdkBundle)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue())));
        });
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)sdkBundlesPerPackageName, Iterables::getOnlyElement));
    }

    private static void validateSdkBundlesMatchAppBundleDependencies(AppBundle appBundle, ImmutableMap<String, SdkBundle> sdkBundles) {
        appBundle.getRuntimeEnabledSdkDependencies().keySet().forEach(sdkPackageName -> {
            if (!sdkBundles.containsKey(sdkPackageName)) {
                throw InvalidCommandException.builder().withInternalMessage("App bundle depends on SDK '%s', but no SDK bundle was provided.", sdkPackageName).build();
            }
            RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk sdkDependencyFromAppBundle = (RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk)appBundle.getRuntimeEnabledSdkDependencies().get(sdkPackageName);
            SdkBundle sdkBundle = (SdkBundle)sdkBundles.get(sdkPackageName);
            if (sdkDependencyFromAppBundle.getVersionMajor() != sdkBundle.getMajorVersion()) {
                throw InvalidCommandException.builder().withInternalMessage("App bundle depends on SDK '%s' with major version '%d', but provided SDK bundle has major version '%d'.", sdkPackageName, sdkDependencyFromAppBundle.getVersionMajor(), sdkBundle.getMajorVersion()).build();
            }
            if (sdkDependencyFromAppBundle.getVersionMinor() != sdkBundle.getMinorVersion()) {
                throw InvalidCommandException.builder().withInternalMessage("App bundle depends on SDK '%s' with minor version '%d', but provided SDK bundle has minor version '%d'.", sdkPackageName, sdkDependencyFromAppBundle.getVersionMinor(), sdkBundle.getMinorVersion()).build();
            }
        });
        sdkBundles.keySet().forEach(sdkPackageName -> {
            if (!appBundle.getRuntimeEnabledSdkDependencies().containsKey(sdkPackageName)) {
                throw InvalidCommandException.builder().withInternalMessage("App bundle does not depend on SDK '%s', but SDK bundle was provided.", sdkPackageName).build();
            }
        });
    }

    private static ListeningExecutorService createInternalExecutorService(int maxThreads) {
        Preconditions.checkArgument((maxThreads >= 0 ? 1 : 0) != 0, (String)"The maxThreads must be positive, got %s.", (int)maxThreads);
        return MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(maxThreads));
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Generates an APK Set archive containing either all possible split APKs and standalone APKs or APKs optimized for the connected device (see %s flag).", CONNECTED_DEVICE_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(BUNDLE_LOCATION_FLAG.getName()).setExampleValue("bundle.aab").setDescription("Path to the Android App Bundle to generate APKs from.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FILE_FLAG.getName()).setExampleValue("output.apks").setDescription("Path to where the APK Set archive should be created (default) or path to the directory where generated APKs should be stored when flag --%s is set to '%s'.", new Object[]{OUTPUT_FORMAT_FLAG.getName(), OutputFormat.DIRECTORY}).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FORMAT_FLAG.getName()).setExampleValue(BuildApksCommand.joinFlagOptions(OutputFormat.values())).setOptional(true).setDescription("Specifies output format for generated APKs. If set to '%s' outputs APKs into the created APK Set archive (default). If set to '%s' outputs APKs into the specified directory.", new Object[]{OutputFormat.APK_SET, OutputFormat.DIRECTORY}).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OVERWRITE_OUTPUT_FLAG.getName()).setOptional(true).setDescription("If set, any previous existing output will be overwritten.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(AAPT2_PATH_FLAG.getName()).setExampleValue("path/to/aapt2").setOptional(true).setDescription("Path to the aapt2 binary to use.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(BUILD_MODE_FLAG.getName()).setExampleValue(BuildApksCommand.joinFlagOptions(ApkBuildMode.values())).setOptional(true).setDescription("Specifies which mode to run '%s' command against. Acceptable values are '%s'. If not set or set to '%s' we generate split, standalone and instant APKs. If set to '%s' we generate universal APK. If set to '%s' we generate APKs for system image. If set to %s we generate the archived APK.", COMMAND_NAME, BuildApksCommand.joinFlagOptions(ApkBuildMode.values()), ApkBuildMode.DEFAULT.getLowerCaseName(), ApkBuildMode.UNIVERSAL.getLowerCaseName(), ApkBuildMode.SYSTEM.getLowerCaseName(), ApkBuildMode.ARCHIVE.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MAX_THREADS_FLAG.getName()).setExampleValue("num-threads").setOptional(true).setDescription("Sets the maximum number of threads to use (default: %d).", 4).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OPTIMIZE_FOR_FLAG.getName()).setExampleValue(BuildApksCommand.joinFlagOptions(OptimizationDimension.values())).setOptional(true).setDescription("If set, will generate APKs with optimizations for the given dimensions. Acceptable values are '%s'. This flag should be only be set with --%s=%s flag.", BuildApksCommand.joinFlagOptions(OptimizationDimension.values()), BUILD_MODE_FLAG.getName(), ApkBuildMode.DEFAULT.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_FLAG.getName()).setExampleValue("path/to/keystore").setOptional(true).setDescription("Path to the keystore that should be used to sign the generated APKs. If not set, the default debug keystore will be used if it exists. If not found the APKs will not be signed. If set, the flag '%s' must also be set.", KEY_ALIAS_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_ALIAS_FLAG.getName()).setExampleValue("key-alias").setOptional(true).setDescription("Alias of the key to use in the keystore to sign the generated APKs.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_PASSWORD_FLAG.getName()).setExampleValue("[pass|file]:value").setOptional(true).setDescription("Password of the keystore to use to sign the generated APKs. If provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the password will be requested on the prompt.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_PASSWORD_FLAG.getName()).setExampleValue("key-password").setOptional(true).setDescription("Password of the key in the keystore to use to sign the generated APKs. If provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the keystore password will be tried. If that fails, the password will be requested on the prompt.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MINIMUM_V3_ROTATION_API_VERSION_FLAG.getName()).setExampleValue("30").setOptional(true).setDescription("The minimum API version for signing the generated APKs with rotation using V3 signature scheme.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ROTATION_MINIMUM_SDK_VERSION_FLAG.getName()).setExampleValue("30").setOptional(true).setDescription("The minimum Android version for signing the generated APKs with rotation. The original signing key for the APK will be used for all previous platform versions.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(LINEAGE_FLAG.getName()).setExampleValue("path/to/existing/lineage").setOptional(true).setDescription("Input SigningCertificateLineage. This file contains a binary representation of a SigningCertificateLineage object, which contains the proof-of-rotation for different signing certificates. This can be used with APK Signature Scheme v3 to rotate the signing certificate for an APK. An APK previously signed with a SigningCertificateLineage can also be specified; the lineage will then be read from the signed data in the APK. If set, the flag '%s' must also be set.", OLDEST_SIGNER_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OLDEST_SIGNER_FLAG.getName()).setExampleValue("path/to/keystore.properties").setOptional(true).setDescription("Path to a properties file containing the properties of the oldest keystore that has previously been used for signing. This is used to sign the generated APKs with signature scheme v1 and v2 for backward compatibility when the key has been rotated using signature scheme v3. If set, the flag '%s' must also be set.\n\nThe file is required to include values for the following properties:\n  * ks - Path to the keystore.\n  * ks-key-alias - Alias of the key to use in the keystore.\n\nThe file may also optionally include values for the following properties:\n  * ks-pass - Password of the keystore. If provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this property is not set, the password will be requested on the prompt.\n  * key-pass - Password of the key in the keystore. If provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this property is not set, the keystore password will be tried. If that fails, the password will be requested on the prompt.\n\nExample keystore.properties file:\nks=/path/to/keystore.jks\nks-key-alias=keyAlias\nks-pass=pass:myPassword\nkey-pass=file:/path/to/myPassword.txt", LINEAGE_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(CONNECTED_DEVICE_FLAG.getName()).setOptional(true).setDescription("If set, will generate APK Set optimized for the connected device. The generated APK Set will only be installable on that specific class of devices. This flag should be only be set with --%s=%s flag.", BUILD_MODE_FLAG.getName(), ApkBuildMode.DEFAULT.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ADB_PATH_FLAG.getName()).setExampleValue("path/to/adb").setOptional(true).setDescription("Path to the adb utility. If absent, an attempt will be made to locate it if the %s or %s environment variable is set. Used only if %s flag is set.", "ANDROID_HOME", "PATH", CONNECTED_DEVICE_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_ID_FLAG.getName()).setExampleValue("device-serial-name").setOptional(true).setDescription("Device serial name. If absent, this uses the %s environment variable. Either this flag or the environment variable is required when more than one device or emulator is connected. Used only if %s flag is set.", "ANDROID_SERIAL", CONNECTED_DEVICE_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_SPEC_FLAG.getName()).setExampleValue("device-spec.json").setOptional(true).setDescription("Path to the device spec file generated by the '%s' command. If present, it will generate an APK Set optimized for the specified device spec. This flag should be only be set with --%s=%s flag.", "get-device-spec", BUILD_MODE_FLAG.getName(), ApkBuildMode.DEFAULT.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_TIER_FLAG.getName()).setExampleValue("low").setOptional(true).setDescription("Device tier to use for APK matching. This flag should be only be set with --%s or --%s flags. If a device spec with a device tier is provided, the value specified here will override the value set in the device spec.", DEVICE_SPEC_FLAG.getName(), CONNECTED_DEVICE_FLAG.getName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(FUSE_ONLY_DEVICE_MATCHING_MODULES_FLAG.getName()).setOptional(true).setDescription("When set, conditional modules with fused attribute will be fused into the base module if they match the the device given by %s", DEVICE_SPEC_FLAG.getName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MODULES_FLAG.getName()).setExampleValue("base,module1,module2").setOptional(true).setDescription("List of module names to include in the generated APK Set in modes %s and %s.", ApkBuildMode.UNIVERSAL.getLowerCaseName(), ApkBuildMode.SYSTEM.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(LOCAL_TESTING_MODE_FLAG.getName()).setOptional(true).setDescription("If enabled, the APK set will be built in local testing mode, which includes additional metadata in the output. When `bundletool %s` is later used to install APKs from this set on a device, it will additionally push all dynamic module splits and asset packs to a location that can be accessed by the Play Core API.", "install-apks").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(VERBOSE_FLAG.getName()).setOptional(true).setDescription("If set, prints extra information about the command execution in the standard output.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(P7ZIP_PATH_FLAG.getName()).setOptional(true).setDescription("Path to the 7zip binary to use. Mandatory if Android App Bundle requires 7zip compression.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(CREATE_STAMP_FLAG.getName()).setOptional(true).setDescription("If set, a stamp will be generated and embedded in the generated APKs.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(STAMP_KEYSTORE_FLAG.getName()).setExampleValue("path/to/keystore").setOptional(true).setDescription("Path to the stamp keystore that should be used to sign the APK contents hash. If not set, the '%s' keystore will be tried if present. Otherwise, the default debug keystore will be used if it exists. If a default debug keystore is not found, the stamp will fail to get generated. If set, the flag '%s' must also be set.", KEYSTORE_FLAG, STAMP_KEY_ALIAS_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(STAMP_KEYSTORE_PASSWORD_FLAG.getName()).setExampleValue("[pass|file]:value").setOptional(true).setDescription("Password of the stamp keystore to use to sign the APK contents hash. If provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the password will be requested on the prompt.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(STAMP_KEY_ALIAS_FLAG.getName()).setExampleValue("stamp-key-alias").setOptional(true).setDescription("Alias of the stamp key to use in the keystore to sign the APK contents hash. If not set, the '%s' key alias will be tried if present.", KEY_ALIAS_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(STAMP_KEY_PASSWORD_FLAG.getName()).setExampleValue("stamp-key-password").setOptional(true).setDescription("Password of the stamp key in the keystore to use to sign the APK contents hash. if provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the keystore password will be tried. If that fails, the password will be requested on the prompt.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(STAMP_SOURCE_FLAG.getName()).setExampleValue("stamp-source").setOptional(true).setDescription("Name of source generating the stamp. For stores, it is their package names. For locally generated stamp, it is 'local'.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(STAMP_EXCLUDE_TIMESTAMP.getName()).setExampleValue("true").setOptional(true).setDescription("If set, a timestamp indicating the time of signing will be excluded from the generated stamp embedded in the generated APKs.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(RUNTIME_ENABLED_SDK_BUNDLE_LOCATIONS_FLAG.getName()).setExampleValue("path/to/bundle1.asb,path/to/bundle2.asb").setOptional(true).setDescription("Paths to SDK bundles for the runtime-enabled SDKs that the App Bundle depends on, separated by commas. Each SDK bundle must have an extension .asb. Can not be used together with the '%s' flag.", RUNTIME_ENABLED_SDK_ARCHIVE_LOCATIONS_FLAG.getName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(RUNTIME_ENABLED_SDK_ARCHIVE_LOCATIONS_FLAG.getName()).setExampleValue("path/to/asar1.asar,path/to/asar2.asar").setOptional(true).setDescription("Paths to SDK archives for the runtime-enabled SDKs that the App Bundle depends on, separated by commas. Each SDK archive must have an extension .asar. Can not be used together with the '%s' flag.", RUNTIME_ENABLED_SDK_BUNDLE_LOCATIONS_FLAG.getName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APP_STORE_PACKAGE_NAME_FLAG.getName()).setExampleValue("shadow.bundletool.com.android.vending").setOptional(true).setDescription("Package name of an app store that will be called by archived app to redownload the application. Play Store is called by default. Can only be provided for ARCHIVE mode.").build()).build();
    }

    private static String joinFlagOptions(Enum<?> ... flagOptions) {
        return Arrays.stream(flagOptions).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining("|"));
    }

    private static void populateSigningConfigurationFromFlags(Builder buildApksCommand, ParsedFlags flags, PrintStream out, SystemEnvironmentProvider systemEnvironmentProvider) {
        Optional<Path> keystorePath = KEYSTORE_FLAG.getValue(flags);
        Optional<String> keyAlias = KEY_ALIAS_FLAG.getValue(flags);
        Optional<Password> keystorePassword = KEYSTORE_PASSWORD_FLAG.getValue(flags);
        Optional<Password> keyPassword = KEY_PASSWORD_FLAG.getValue(flags);
        Optional<Integer> minV3RotationApi = MINIMUM_V3_ROTATION_API_VERSION_FLAG.getValue(flags);
        Optional<Integer> rotationMinSdkVersion = ROTATION_MINIMUM_SDK_VERSION_FLAG.getValue(flags);
        if (keystorePath.isPresent() && keyAlias.isPresent()) {
            SignerConfig signerConfig = SignerConfig.extractFromKeystore(keystorePath.get(), keyAlias.get(), keystorePassword, keyPassword);
            SigningConfiguration.Builder builder = SigningConfiguration.builder().setSignerConfig(signerConfig).setMinimumV3RotationApiVersion(minV3RotationApi).setRotationMinSdkVersion(rotationMinSdkVersion);
            BuildApksCommand.populateLineageFromFlags(builder, flags);
            buildApksCommand.setSigningConfiguration(builder.build());
        } else {
            if (keystorePath.isPresent() && !keyAlias.isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Flag --ks-key-alias is required when --ks is set.").build();
            }
            if (!keystorePath.isPresent() && keyAlias.isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Flag --ks is required when --ks-key-alias is set.").build();
            }
            Optional<SigningConfiguration> debugConfig = DebugKeystoreUtils.getDebugSigningConfiguration(systemEnvironmentProvider);
            if (debugConfig.isPresent()) {
                out.printf("INFO: The APKs will be signed with the debug keystore found at '%s'.%n", ((Optional)DebugKeystoreUtils.DEBUG_KEYSTORE_CACHE.getUnchecked((Object)systemEnvironmentProvider)).get());
                buildApksCommand.setSigningConfiguration(debugConfig.get());
            } else {
                out.println("WARNING: The APKs won't be signed and thus not installable unless you also pass a keystore via the flag --ks. See the command help for more information.");
            }
        }
    }

    private static void populateLineageFromFlags(SigningConfiguration.Builder signingConfiguration, ParsedFlags flags) {
        Optional<Path> lineagePath = LINEAGE_FLAG.getValue(flags);
        Optional<Path> oldestSignerPropertiesPath = OLDEST_SIGNER_FLAG.getValue(flags);
        if (lineagePath.isPresent() && oldestSignerPropertiesPath.isPresent()) {
            signingConfiguration.setSigningCertificateLineage(BuildApksCommand.getLineageFromInputFile(lineagePath.get().toFile()));
            KeystoreProperties oldestSignerProperties = KeystoreProperties.readFromFile(oldestSignerPropertiesPath.get());
            signingConfiguration.setOldestSigner(SignerConfig.extractFromKeystore(oldestSignerProperties.getKeystorePath(), oldestSignerProperties.getKeyAlias(), oldestSignerProperties.getKeystorePassword(), oldestSignerProperties.getKeyPassword()));
        } else {
            if (lineagePath.isPresent() && !oldestSignerPropertiesPath.isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Flag '%s' is required when '%s' is set.", OLDEST_SIGNER_FLAG, LINEAGE_FLAG).build();
            }
            if (!lineagePath.isPresent() && oldestSignerPropertiesPath.isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Flag '%s' is required when '%s' is set.", LINEAGE_FLAG, OLDEST_SIGNER_FLAG).build();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SigningCertificateLineage getLineageFromInputFile(File inputLineageFile) {
        try (RandomAccessFile f11 = new RandomAccessFile(inputLineageFile, "r");){
            if (f11.length() < 4L) {
                throw CommandExecutionException.builder().withInternalMessage("The input file is not a valid lineage file.").build();
            }
            DataSource apk = DataSources.asDataSource(f11);
            int magicValue = apk.getByteBuffer(0L, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
            if (magicValue == 1056913873) {
                SigningCertificateLineage signingCertificateLineage = SigningCertificateLineage.readFromFile(inputLineageFile);
                return signingCertificateLineage;
            }
            if (magicValue == 67324752) {
                SigningCertificateLineage signingCertificateLineage = SigningCertificateLineage.readFromApkFile(inputLineageFile);
                return signingCertificateLineage;
            }
            throw CommandExecutionException.builder().withInternalMessage("The input file is not a valid lineage file.").build();
        }
        catch (IOException | IllegalArgumentException | ApkFormatException e11) {
            throw CommandExecutionException.builder().withCause(e11).build();
        }
    }

    private static void populateSourceStampFromFlags(Builder buildApksCommand, ParsedFlags flags, PrintStream out, SystemEnvironmentProvider systemEnvironmentProvider) {
        boolean createStamp = CREATE_STAMP_FLAG.getValue(flags).orElse(false);
        Optional<String> stampSource = STAMP_SOURCE_FLAG.getValue(flags);
        Optional<Boolean> stampExcludeTimestamp = STAMP_EXCLUDE_TIMESTAMP.getValue(flags);
        if (!createStamp) {
            return;
        }
        SourceStamp.Builder sourceStamp = SourceStamp.builder();
        sourceStamp.setSigningConfiguration(BuildApksCommand.getStampSigningConfiguration(flags, out, systemEnvironmentProvider));
        stampSource.ifPresent(sourceStamp::setSource);
        stampExcludeTimestamp.ifPresent(excludeTimestamp -> sourceStamp.setIncludeTimestamp(excludeTimestamp == false));
        buildApksCommand.setSourceStamp(sourceStamp.build());
    }

    private static SigningConfiguration getStampSigningConfiguration(ParsedFlags flags, PrintStream out, SystemEnvironmentProvider systemEnvironmentProvider) {
        Optional<Path> signingKeystorePath = KEYSTORE_FLAG.getValue(flags);
        Optional<Password> signingKeystorePassword = KEYSTORE_PASSWORD_FLAG.getValue(flags);
        Optional<String> signingKeyAlias = KEY_ALIAS_FLAG.getValue(flags);
        Optional<Password> signingKeyPassword = KEY_PASSWORD_FLAG.getValue(flags);
        Optional<Path> stampKeystorePath = STAMP_KEYSTORE_FLAG.getValue(flags);
        Optional<Password> stampKeystorePassword = STAMP_KEYSTORE_PASSWORD_FLAG.getValue(flags);
        Optional<String> stampKeyAlias = STAMP_KEY_ALIAS_FLAG.getValue(flags);
        Optional<Password> stampKeyPassword = STAMP_KEY_PASSWORD_FLAG.getValue(flags);
        Path keystorePath = null;
        Optional<Password> keystorePassword = Optional.empty();
        if (stampKeystorePath.isPresent()) {
            keystorePath = stampKeystorePath.get();
            keystorePassword = stampKeystorePassword;
        } else if (signingKeystorePath.isPresent()) {
            keystorePath = signingKeystorePath.get();
            keystorePassword = signingKeystorePassword;
        }
        if (keystorePath == null) {
            Optional<SigningConfiguration> debugConfig = DebugKeystoreUtils.getDebugSigningConfiguration(systemEnvironmentProvider);
            if (debugConfig.isPresent()) {
                out.printf("INFO: The stamp will be signed with the debug keystore found at '%s'.%n", ((Optional)DebugKeystoreUtils.DEBUG_KEYSTORE_CACHE.getUnchecked((Object)systemEnvironmentProvider)).get());
                return debugConfig.get();
            }
            throw InvalidCommandException.builder().withInternalMessage("No key was found to sign the stamp.").build();
        }
        String keyAlias = null;
        Optional<Password> keyPassword = Optional.empty();
        if (stampKeyAlias.isPresent()) {
            keyAlias = stampKeyAlias.get();
            keyPassword = stampKeyPassword;
        } else if (signingKeyAlias.isPresent()) {
            keyAlias = signingKeyAlias.get();
            keyPassword = signingKeyPassword;
        }
        if (keyAlias == null) {
            throw InvalidCommandException.builder().withInternalMessage("Flag --stamp-key-alias or --ks-key-alias are required when --stamp-ks or --ks are set.").build();
        }
        return SigningConfiguration.extractFromKeystore(keystorePath, keyAlias, keystorePassword, keyPassword);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBundlePath(Path var1);

        public abstract Builder setOutputFormat(OutputFormat var1);

        public abstract Builder setOutputFile(Path var1);

        public abstract Builder setOverwriteOutput(boolean var1);

        @Deprecated
        public abstract Builder setOptimizationDimensions(ImmutableSet<OptimizationDimension> var1);

        public abstract Builder setApkBuildMode(ApkBuildMode var1);

        public abstract Builder setLocalTestingMode(boolean var1);

        public abstract Builder setGenerateOnlyForConnectedDevice(boolean var1);

        public abstract Builder setModules(ImmutableSet<String> var1);

        public abstract Builder setDeviceSpec(Devices.DeviceSpec var1);

        public Builder setDeviceSpec(Path deviceSpecFile) {
            return this.setDeviceSpec(DeviceSpecParser.parsePartialDeviceSpec(deviceSpecFile));
        }

        public abstract Builder setFuseOnlyDeviceMatchingModules(boolean var1);

        public abstract Builder setDeviceTier(Integer var1);

        public abstract Builder setSystemApkOptions(ImmutableSet<SystemApkOption> var1);

        public abstract Builder setVerbose(boolean var1);

        public abstract Builder setDeviceId(String var1);

        public abstract Builder setAdbPath(Path var1);

        public abstract Builder setAdbServer(AdbServer var1);

        public abstract Builder setAapt2Command(Aapt2Command var1);

        public abstract Builder setSigningConfiguration(SigningConfiguration var1);

        abstract Optional<SigningConfiguration> getSigningConfiguration();

        public abstract Builder setSigningConfigurationProvider(SigningConfigurationProvider var1);

        abstract Optional<SigningConfigurationProvider> getSigningConfigurationProvider();

        public abstract Builder setMinSdkForAdditionalVariantWithV3Rotation(int var1);

        @CanIgnoreReturnValue
        public Builder setExecutorService(ListeningExecutorService executorService) {
            this.setExecutorServiceInternal(executorService);
            this.setExecutorServiceCreatedByBundleTool(false);
            return this;
        }

        abstract Builder setExecutorServiceInternal(ListeningExecutorService var1);

        abstract Optional<ListeningExecutorService> getExecutorServiceInternal();

        abstract Builder setExecutorServiceCreatedByBundleTool(boolean var1);

        @Deprecated
        public Builder setCreateApkSetArchive(boolean createApkSetArchive) {
            return this.setOutputFormat(createApkSetArchive ? OutputFormat.APK_SET : OutputFormat.DIRECTORY);
        }

        public abstract Builder setApkListener(ApkListener var1);

        public abstract Builder setApkModifier(ApkModifier var1);

        public abstract Builder setExtraValidators(ImmutableList<SubValidator> var1);

        public abstract Builder setFirstVariantNumber(int var1);

        public abstract Builder setOutputPrintStream(PrintStream var1);

        public abstract Builder setSourceStamp(SourceStamp var1);

        public abstract Builder setAssetModulesVersionOverride(long var1);

        public abstract Builder setEnableApkSerializerWithoutBundleRecompression(boolean var1);

        public abstract Builder setP7ZipCommand(P7ZipCommand var1);

        public abstract Builder setRuntimeEnabledSdkBundlePaths(ImmutableSet<Path> var1);

        public abstract Builder setRuntimeEnabledSdkArchivePaths(ImmutableSet<Path> var1);

        public abstract Builder setAppStorePackageName(String var1);

        abstract BuildApksCommand autoBuild();

        public BuildApksCommand build() {
            if (!this.getExecutorServiceInternal().isPresent()) {
                this.setExecutorServiceInternal(BuildApksCommand.createInternalExecutorService(4));
                this.setExecutorServiceCreatedByBundleTool(true);
            }
            Preconditions.checkState((!this.getSigningConfiguration().isPresent() || !this.getSigningConfigurationProvider().isPresent() ? 1 : 0) != 0, (Object)"Only one of SigningConfiguration or SigningConfigurationProvider should be set.");
            this.getSigningConfiguration().flatMap(SigningConfiguration::getMinimumV3RotationApiVersion).ifPresent(this::setMinSdkForAdditionalVariantWithV3Rotation);
            BuildApksCommand command = this.autoBuild();
            if (!command.getOptimizationDimensions().isEmpty() && !command.getApkBuildMode().equals((Object)ApkBuildMode.DEFAULT)) {
                throw InvalidCommandException.builder().withInternalMessage("Optimization dimension can be only set when running with '%s' mode flag.", ApkBuildMode.DEFAULT.getLowerCaseName()).build();
            }
            if (command.getGenerateOnlyForConnectedDevice() && !command.getApkBuildMode().equals((Object)ApkBuildMode.DEFAULT)) {
                throw InvalidCommandException.builder().withInternalMessage("Optimizing for connected device only possible when running with '%s' mode flag.", ApkBuildMode.DEFAULT.getLowerCaseName()).build();
            }
            if (command.getDeviceSpec().isPresent()) {
                boolean supportsPartialDeviceSpecs = command.getApkBuildMode().equals((Object)ApkBuildMode.SYSTEM);
                DeviceSpecParser.validateDeviceSpec(command.getDeviceSpec().get(), supportsPartialDeviceSpecs);
                switch (command.getApkBuildMode()) {
                    case UNIVERSAL: {
                        throw InvalidCommandException.builder().withInternalMessage("Optimizing for device spec is not possible when running with '%s' mode flag.", ApkBuildMode.UNIVERSAL.getLowerCaseName()).build();
                    }
                    case SYSTEM: {
                        Devices.DeviceSpec deviceSpec = command.getDeviceSpec().get();
                        if (deviceSpec.getScreenDensity() != 0 && !deviceSpec.getSupportedAbisList().isEmpty()) break;
                        throw InvalidCommandException.builder().withInternalMessage("Device spec must have screen density and ABIs set when running with '%s' mode flag. ", ApkBuildMode.SYSTEM.getLowerCaseName()).build();
                    }
                }
            } else if (command.getApkBuildMode().equals((Object)ApkBuildMode.SYSTEM)) {
                throw InvalidCommandException.builder().withInternalMessage("Device spec must always be set when running with '%s' mode flag.", ApkBuildMode.SYSTEM.getLowerCaseName()).build();
            }
            if (command.getFuseOnlyDeviceMatchingModules() && !command.getDeviceSpec().isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Device spec must be provided when using '%s' flag.", FUSE_ONLY_DEVICE_MATCHING_MODULES_FLAG.getName()).build();
            }
            if (command.getGenerateOnlyForConnectedDevice() && command.getDeviceSpec().isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Cannot optimize for the device spec and connected device at the same time.").build();
            }
            if (command.getDeviceId().isPresent() && !command.getGenerateOnlyForConnectedDevice()) {
                throw InvalidCommandException.builder().withInternalMessage("Setting --device-id requires using the --connected-device flag.").build();
            }
            if (command.getDeviceTier().isPresent() && !command.getGenerateOnlyForConnectedDevice() && !command.getDeviceSpec().isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Setting --device-tier requires using either the --connected-device or the --device-spec flag.").build();
            }
            if (command.getOutputFormat().equals((Object)OutputFormat.APK_SET) && !BuildApksCommand.APK_SET_ARCHIVE_EXTENSION.equals(MoreFiles.getFileExtension((Path)command.getOutputFile()))) {
                throw InvalidCommandException.builder().withInternalMessage("Flag --output should be the path where to generate the APK Set. Its extension must be '.apks'.").build();
            }
            if (!(command.getModules().isEmpty() || command.getApkBuildMode().equals((Object)ApkBuildMode.SYSTEM) || command.getApkBuildMode().equals((Object)ApkBuildMode.UNIVERSAL))) {
                throw InvalidCommandException.builder().withInternalMessage("Modules can be only set when running with '%s' or '%s' mode flag.", ApkBuildMode.UNIVERSAL.getLowerCaseName(), ApkBuildMode.SYSTEM.getLowerCaseName()).build();
            }
            if (command.getAppStorePackageName().isPresent() && !command.getApkBuildMode().equals((Object)ApkBuildMode.ARCHIVE)) {
                throw InvalidCommandException.builder().withInternalMessage("Providing custom store package is only possible when running with '%s' mode flag.", ApkBuildMode.ARCHIVE.getLowerCaseName()).build();
            }
            if (!command.getRuntimeEnabledSdkBundlePaths().isEmpty() && !command.getRuntimeEnabledSdkArchivePaths().isEmpty()) {
                throw InvalidCommandException.builder().withInternalMessage("Command can only set either runtime-enabled SDK bundles or runtime-enabled SDK archives, but both were set.").build();
            }
            return command;
        }
    }

    public static enum OutputFormat {
        APK_SET,
        DIRECTORY;

    }

    public static enum SystemApkOption {
        UNCOMPRESSED_NATIVE_LIBRARIES,
        UNCOMPRESSED_DEX_FILES;

    }

    public static enum ApkBuildMode {
        DEFAULT,
        UNIVERSAL,
        SYSTEM,
        PERSISTENT,
        INSTANT,
        ARCHIVE;


        public final String getLowerCaseName() {
            return Ascii.toLowerCase((String)this.name());
        }
    }
}

