/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.sdkmodule;

import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntriesMutator;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import java.util.function.Predicate;

public class DexRepackager
extends ModuleEntriesMutator {
    private static final String ASSETS_SUBDIRECTORY_PREFIX = "assets/RuntimeEnabledSdk-";
    private final SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig;

    DexRepackager(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        this.sdkModulesConfig = sdkModulesConfig;
    }

    @Override
    public Predicate<ModuleEntry> getFilter() {
        return entry -> entry.getPath().startsWith("dex/");
    }

    @Override
    public Function<ImmutableList<ModuleEntry>, ImmutableList<ModuleEntry>> getMutator() {
        return dexEntries -> (ImmutableList)dexEntries.stream().map(this::updateDexEntryPath).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean shouldApplyMutation(BundleModule module) {
        return true;
    }

    private ModuleEntry updateDexEntryPath(ModuleEntry dexEntry) {
        String dexFileName = dexEntry.getPath().getFileName().toString();
        return dexEntry.toBuilder().setPath(ZipPath.create(this.getNewDexDirectoryPath() + dexFileName)).build();
    }

    String getNewDexDirectoryPath() {
        return ASSETS_SUBDIRECTORY_PREFIX + this.sdkModulesConfig.getSdkPackageName() + "/dex/";
    }
}

