/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.archive;

import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.ManifestEditor;
import com.android.tools.build.bundletool.model.manifestelements.Activity;
import com.android.tools.build.bundletool.model.manifestelements.IntentFilter;
import com.android.tools.build.bundletool.model.manifestelements.Receiver;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;

public final class ArchivedAndroidManifestUtils {
    public static final String META_DATA_KEY_ARCHIVED = "shadow.bundletool.com.android.vending.archive";
    public static final String REACTIVATE_ACTIVITY_NAME = "com.google.android.archive.ReactivateActivity";
    public static final int HOLO_LIGHT_NO_ACTION_BAR_FULSCREEN_THEME_RES_ID = 16974065;
    public static final String UPDATE_BROADCAST_RECEIVER_NAME = "com.google.android.archive.UpdateBroadcastReceiver";
    public static final String MY_PACKAGE_REPLACED_ACTION_NAME = "android.intent.action.MY_PACKAGE_REPLACED";
    public static final ImmutableList<Integer> MANIFEST_ATTRIBUTES_TO_KEEP = ImmutableList.of((Object)16843291, (Object)16843292, (Object)0x101000B, (Object)16843361, (Object)16844108);
    public static final ImmutableList<Integer> APPLICATION_ATTRIBUTES_TO_KEEP = ImmutableList.of((Object)0x1010020, (Object)16844186, (Object)16843764, (Object)0x1010002, (Object)16844076, (Object)16843762, (Object)0x1010001, (Object)16843891, (Object)16844011, (Object)16844350, (Object)16843733, (Object)16843734, (Object[])new Integer[]{16843610});
    public static final ImmutableList<String> CHILDREN_ELEMENTS_TO_KEEP = ImmutableList.of((Object)"uses-sdk", (Object)"permission", (Object)"permission-group", (Object)"permission-tree");

    public static AndroidManifest createArchivedManifest(AndroidManifest manifest) {
        Preconditions.checkNotNull((Object)manifest);
        ManifestEditor editor = new ManifestEditor(ArchivedAndroidManifestUtils.createMinimalManifestTag(), BundleToolVersion.getCurrentVersion()).setPackage(manifest.getPackageName()).addMetaDataBoolean(META_DATA_KEY_ARCHIVED, true);
        MANIFEST_ATTRIBUTES_TO_KEEP.forEach(attrResourceId -> editor.copyManifestElementAndroidAttribute(manifest, (int)attrResourceId));
        if (manifest.hasApplicationElement()) {
            APPLICATION_ATTRIBUTES_TO_KEEP.forEach(attrResourceId -> editor.copyApplicationElementAndroidAttribute(manifest, (int)attrResourceId));
            if (!manifest.hasApplicationAttribute(16843391)) {
                editor.copyApplicationElementAndroidAttribute(manifest, 16843392);
            } else {
                editor.setAllowBackup(false);
            }
        }
        manifest.getMetadataElement("com.google.android.gms.version").ifPresent(editor::addApplicationChildElement);
        CHILDREN_ELEMENTS_TO_KEEP.forEach(elementName -> editor.copyChildrenElements(manifest, (String)elementName));
        editor.addActivity(ArchivedAndroidManifestUtils.createReactivateActivity(manifest));
        editor.addReceiver(ArchivedAndroidManifestUtils.createUpdateBroadcastReceiver());
        ArchivedAndroidManifestUtils.addTvSupportIfRequired(editor, manifest);
        return editor.save();
    }

    private static XmlProtoNode createMinimalManifestTag() {
        return XmlProtoNode.createElementNode(XmlProtoElementBuilder.create("manifest").addNamespaceDeclaration("android", "http://schemas.android.com/apk/res/android").build());
    }

    public static AndroidManifest updateArchivedIcons(AndroidManifest manifest, ImmutableMap<String, Integer> resourceNameToIdMap) {
        ManifestEditor archivedManifestEditor = manifest.toEditor();
        if (manifest.getIconAttribute().isPresent() && resourceNameToIdMap.containsKey((Object)"com_android_vending_archive_application_icon")) {
            archivedManifestEditor.setIcon((Integer)resourceNameToIdMap.get((Object)"com_android_vending_archive_application_icon"));
        }
        if (manifest.getRoundIconAttribute().isPresent() && resourceNameToIdMap.containsKey((Object)"com_android_vending_archive_application_round_icon")) {
            archivedManifestEditor.setRoundIcon((Integer)resourceNameToIdMap.get((Object)"com_android_vending_archive_application_round_icon"));
        }
        return archivedManifestEditor.save();
    }

    private static Activity createReactivateActivity(AndroidManifest manifest) {
        IntentFilter.Builder intentFilterBuilder = IntentFilter.builder().addActionName("android.intent.action.MAIN");
        if (manifest.hasMainActivity()) {
            intentFilterBuilder.addCategoryName("android.intent.category.LAUNCHER");
        }
        if (manifest.hasMainTvActivity()) {
            intentFilterBuilder.addCategoryName("android.intent.category.LEANBACK_LAUNCHER");
        }
        return Activity.builder().setName(REACTIVATE_ACTIVITY_NAME).setTheme(16974065).setExported(true).setExcludeFromRecents(true).setStateNotNeeded(true).setIntentFilter(intentFilterBuilder.build()).build();
    }

    private static Receiver createUpdateBroadcastReceiver() {
        return Receiver.builder().setName(UPDATE_BROADCAST_RECEIVER_NAME).setExported(true).setIntentFilter(IntentFilter.builder().addActionName(MY_PACKAGE_REPLACED_ACTION_NAME).build()).build();
    }

    private static void addTvSupportIfRequired(ManifestEditor editor, AndroidManifest originalManifest) {
        if (!originalManifest.hasMainTvActivity()) {
            return;
        }
        editor.addUsesFeatureElement("android.software.leanback", false);
        editor.addUsesFeatureElement("android.hardware.touchscreen", false);
    }

    private ArchivedAndroidManifestUtils() {
    }
}

