/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SourceStamp;
import com.android.tools.build.bundletool.model.SourceStampConstants;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.ModuleSplitter;
import com.android.tools.build.bundletool.splitters.VariantTargetingGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import javax.inject.Inject;

public final class SplitApksGenerator {
    private final Version bundletoolVersion;
    private final Optional<SourceStamp> stampSource;
    private final VariantTargetingGenerator variantTargetingGenerator;
    private final AppBundle appBundle;

    @Inject
    public SplitApksGenerator(Version bundletoolVersion, Optional<SourceStamp> stampSource, VariantTargetingGenerator variantTargetingGenerator, AppBundle appBundle) {
        this.bundletoolVersion = bundletoolVersion;
        this.stampSource = stampSource;
        this.variantTargetingGenerator = variantTargetingGenerator;
        this.appBundle = appBundle;
    }

    public ImmutableList<ModuleSplit> generateSplits(ImmutableList<BundleModule> modules, ApkGenerationConfiguration apkGenerationConfiguration) {
        return (ImmutableList)this.variantTargetingGenerator.generateVariantTargetings(modules, apkGenerationConfiguration).stream().flatMap(variantTargeting -> this.generateSplitApks(modules, apkGenerationConfiguration, (Targeting.VariantTargeting)variantTargeting).stream()).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<ModuleSplit> generateSplitApks(ImmutableList<BundleModule> modules, ApkGenerationConfiguration commonApkGenerationConfiguration, Targeting.VariantTargeting variantTargeting) {
        ImmutableList<BundleModule> modulesForVariant = this.getModulesForVariant(modules, variantTargeting);
        ImmutableSet allModuleNames = (ImmutableSet)modulesForVariant.stream().map(module -> module.getName().getName()).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder splits = ImmutableList.builder();
        for (BundleModule module2 : modulesForVariant) {
            ModuleSplitter moduleSplitter = ModuleSplitter.create(module2, this.bundletoolVersion, this.appBundle, this.getApkGenerationConfigurationForModule(module2, commonApkGenerationConfiguration), variantTargeting, (ImmutableSet<String>)allModuleNames, this.stampSource.map(SourceStamp::getSource), SourceStampConstants.StampType.STAMP_TYPE_DISTRIBUTION_APK);
            splits.addAll(moduleSplitter.splitModule());
        }
        return splits.build();
    }

    private ImmutableList<BundleModule> getModulesForVariant(ImmutableList<BundleModule> modules, Targeting.VariantTargeting variantTargeting) {
        if (variantTargeting.getSdkRuntimeTargeting().getRequiresSdkRuntime()) {
            return (ImmutableList)modules.stream().filter(module -> !module.getModuleType().equals((Object)BundleModule.ModuleType.SDK_DEPENDENCY_MODULE)).collect(ImmutableList.toImmutableList());
        }
        return modules;
    }

    private ApkGenerationConfiguration getApkGenerationConfigurationForModule(BundleModule module, ApkGenerationConfiguration commonGenerationConfig) {
        if (module.getModuleType().equals((Object)BundleModule.ModuleType.SDK_DEPENDENCY_MODULE)) {
            return ApkGenerationConfiguration.getDefaultInstance();
        }
        return commonGenerationConfig;
    }
}

