/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipFile;

class SerializationFilesManager
implements AutoCloseable {
    private static final String RESOURCES_ENTRIES_ZIPPED_PACK = "resources-pack.zip";
    private static final String COMPRESSED_ENTRIES_PACK = "compressed.zip";
    private static final String COMPRESSED_RESOURCE_ENTRIES_PACK = "compressed-res.zip";
    private static final String UNCOMPRESSED_ENTRIES_PACK = "uncompressed.zip";
    private final TempDirectory tempDirectory = new TempDirectory();
    private final AtomicInteger counter = new AtomicInteger();
    private final ConcurrentHashMap<Path, ZipFile> openedBinaryApks = new ConcurrentHashMap();

    SerializationFilesManager() {
    }

    @Override
    public void close() throws IOException {
        for (ZipFile zipFile : this.openedBinaryApks.values()) {
            Closeables.close((Closeable)zipFile, (boolean)true);
        }
        this.tempDirectory.close();
    }

    Path getRootDirectory() {
        return this.tempDirectory.getPath();
    }

    Path getResourcesEntriesPackPath() {
        return this.tempDirectory.getPath().resolve(RESOURCES_ENTRIES_ZIPPED_PACK);
    }

    Path getCompressedResourceEntriesPackPath() {
        return this.tempDirectory.getPath().resolve(COMPRESSED_RESOURCE_ENTRIES_PACK);
    }

    Path getCompressedEntriesPackPath() {
        return this.tempDirectory.getPath().resolve(COMPRESSED_ENTRIES_PACK);
    }

    Path getUncompressedEntriesPackPath() {
        return this.tempDirectory.getPath().resolve(UNCOMPRESSED_ENTRIES_PACK);
    }

    Path getNextAapt2ProtoApkPath() {
        return this.tempDirectory.getPath().resolve("proto" + this.counter.incrementAndGet() + ".apk");
    }

    Path getNextAapt2BinaryApkPath() {
        return this.tempDirectory.getPath().resolve("binary" + this.counter.incrementAndGet() + ".apk");
    }

    ZipFile openBinaryApk(Path zipPath) {
        return this.openedBinaryApks.computeIfAbsent(zipPath, ZipUtils::openZipFile);
    }

    void closeAndRemoveBinaryApks() throws IOException {
        for (Map.Entry<Path, ZipFile> opened : this.openedBinaryApks.entrySet()) {
            Closeables.close((Closeable)opened.getValue(), (boolean)true);
            Files.delete(opened.getKey());
        }
        this.openedBinaryApks.clear();
    }
}

