/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.zipflinger;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import shadow.bundletool.com.android.zipflinger.Ints;
import shadow.bundletool.com.android.zipflinger.Location;
import shadow.bundletool.com.android.zipflinger.Source;

class CentralDirectoryRecord {
    public static final int SIGNATURE = 33639248;
    public static final int SIZE = 46;
    public static final int DATA_DESCRIPTOR_FLAG = 8;
    public static final int DATA_DESCRIPTOR_SIGNATURE = 134695760;
    public static final short DEFAULT_TIME = 2081;
    public static final short DEFAULT_DATE = 545;
    private static final int ZIP64_PAYLOAD_SIZE = 24;
    private static final int ZIP64_EXTRA_SIZE = 28;
    private final byte[] nameBytes;
    private final int crc;
    private final long compressedSize;
    private final long uncompressedSize;
    private final Location location;
    private final short compressionFlag;
    private final short versionMadeBy;
    private final int externalAttribute;
    private final Location payloadLocation;
    private final boolean isZip64;

    CentralDirectoryRecord(Source source, Location location, Location payloadLocation) {
        this.nameBytes = source.getNameBytes();
        this.crc = source.getCrc();
        this.compressedSize = source.getCompressedSize();
        this.uncompressedSize = source.getUncompressedSize();
        this.location = location;
        this.compressionFlag = source.getCompressionFlag();
        this.payloadLocation = payloadLocation;
        this.isZip64 = this.compressedSize > 0xFFFFFFFFL || this.uncompressedSize > 0xFFFFFFFFL || location.first > 0xFFFFFFFFL;
        this.versionMadeBy = source.getVersionMadeBy();
        this.externalAttribute = source.getExternalAttributes();
    }

    void write(ByteBuffer buf) {
        short versionNeeded = this.isZip64 ? (short)45 : 0;
        int size = this.isZip64 ? -1 : Ints.longToUint(this.uncompressedSize);
        int csize = this.isZip64 ? -1 : Ints.longToUint(this.compressedSize);
        int offset = this.isZip64 ? -1 : Ints.longToUint(this.location.first);
        ByteBuffer extra = this.buildExtraField();
        buf.putInt(33639248);
        buf.putShort(this.versionMadeBy);
        buf.putShort(versionNeeded);
        buf.putShort((short)0);
        buf.putShort(this.compressionFlag);
        buf.putShort((short)2081);
        buf.putShort((short)545);
        buf.putInt(this.crc);
        buf.putInt(csize);
        buf.putInt(size);
        buf.putShort(Ints.intToUshort(this.nameBytes.length));
        buf.putShort(Ints.intToUshort(extra.capacity()));
        buf.putShort((short)0);
        buf.putShort((short)0);
        buf.putShort((short)0);
        buf.putInt(this.externalAttribute);
        buf.putInt(offset);
        buf.put(this.nameBytes);
        buf.put(extra);
    }

    short getCompressionFlag() {
        return this.compressionFlag;
    }

    long getSize() {
        long extraSize = this.isZip64 ? 28L : 0L;
        return (long)(46 + this.nameBytes.length) + extraSize;
    }

    Location getPayloadLocation() {
        return this.payloadLocation;
    }

    Location getLocation() {
        return this.location;
    }

    private ByteBuffer buildExtraField() {
        if (!this.isZip64) {
            return ByteBuffer.allocate(0);
        }
        ByteBuffer buf = ByteBuffer.allocate(28).order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort((short)1);
        buf.putShort(Ints.intToUshort(24));
        buf.putLong(this.uncompressedSize);
        buf.putLong(this.compressedSize);
        buf.putLong(this.location.first);
        buf.rewind();
        return buf;
    }
}

