/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.apksig.internal.pkcs7;

import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;
import shadow.bundletool.com.android.apksig.internal.apk.v1.DigestAlgorithm;
import shadow.bundletool.com.android.apksig.internal.asn1.Asn1Class;
import shadow.bundletool.com.android.apksig.internal.asn1.Asn1DerEncoder;
import shadow.bundletool.com.android.apksig.internal.asn1.Asn1Field;
import shadow.bundletool.com.android.apksig.internal.asn1.Asn1OpaqueObject;
import shadow.bundletool.com.android.apksig.internal.asn1.Asn1Type;
import shadow.bundletool.com.android.apksig.internal.oid.OidConstants;
import shadow.bundletool.com.android.apksig.internal.util.Pair;

@Asn1Class(type=Asn1Type.SEQUENCE)
public class AlgorithmIdentifier {
    @Asn1Field(index=0, type=Asn1Type.OBJECT_IDENTIFIER)
    public String algorithm;
    @Asn1Field(index=1, type=Asn1Type.ANY, optional=true)
    public Asn1OpaqueObject parameters;

    public AlgorithmIdentifier() {
    }

    public AlgorithmIdentifier(String algorithmOid, Asn1OpaqueObject parameters) {
        this.algorithm = algorithmOid;
        this.parameters = parameters;
    }

    public static AlgorithmIdentifier getSignerInfoDigestAlgorithmOid(DigestAlgorithm digestAlgorithm) {
        switch (digestAlgorithm) {
            case SHA1: {
                return new AlgorithmIdentifier("1.3.14.3.2.26", Asn1DerEncoder.ASN1_DER_NULL);
            }
            case SHA256: {
                return new AlgorithmIdentifier("2.16.840.1.101.3.4.2.1", Asn1DerEncoder.ASN1_DER_NULL);
            }
        }
        throw new IllegalArgumentException("Unsupported digest algorithm: " + (Object)((Object)digestAlgorithm));
    }

    public static Pair<String, AlgorithmIdentifier> getSignerInfoSignatureAlgorithm(PublicKey publicKey, DigestAlgorithm digestAlgorithm) throws InvalidKeyException {
        String jcaDigestPrefixForSigAlg;
        String keyAlgorithm = publicKey.getAlgorithm();
        switch (digestAlgorithm) {
            case SHA1: {
                jcaDigestPrefixForSigAlg = "SHA1";
                break;
            }
            case SHA256: {
                jcaDigestPrefixForSigAlg = "SHA256";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected digest algorithm: " + (Object)((Object)digestAlgorithm));
            }
        }
        if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            return Pair.of(jcaDigestPrefixForSigAlg + "withRSA", new AlgorithmIdentifier("1.2.840.113549.1.1.1", Asn1DerEncoder.ASN1_DER_NULL));
        }
        if ("DSA".equalsIgnoreCase(keyAlgorithm)) {
            AlgorithmIdentifier sigAlgId;
            switch (digestAlgorithm) {
                case SHA1: {
                    sigAlgId = new AlgorithmIdentifier("1.2.840.10040.4.1", Asn1DerEncoder.ASN1_DER_NULL);
                    break;
                }
                case SHA256: {
                    sigAlgId = new AlgorithmIdentifier("2.16.840.1.101.3.4.3.2", Asn1DerEncoder.ASN1_DER_NULL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected digest algorithm: " + (Object)((Object)digestAlgorithm));
                }
            }
            return Pair.of(jcaDigestPrefixForSigAlg + "withDSA", sigAlgId);
        }
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            return Pair.of(jcaDigestPrefixForSigAlg + "withECDSA", new AlgorithmIdentifier("1.2.840.10045.2.1", Asn1DerEncoder.ASN1_DER_NULL));
        }
        throw new InvalidKeyException("Unsupported key algorithm: " + keyAlgorithm);
    }

    public static String getJcaSignatureAlgorithm(String digestAlgorithmOid, String signatureAlgorithmOid) throws SignatureException {
        String suffix;
        String result = OidConstants.OID_TO_JCA_SIGNATURE_ALG.get(signatureAlgorithmOid);
        if (result != null) {
            return result;
        }
        if ("1.2.840.113549.1.1.1".equals(signatureAlgorithmOid)) {
            suffix = "RSA";
        } else if ("1.2.840.10040.4.1".equals(signatureAlgorithmOid)) {
            suffix = "DSA";
        } else if ("1.2.840.10045.2.1".equals(signatureAlgorithmOid)) {
            suffix = "ECDSA";
        } else {
            throw new SignatureException("Unsupported JCA Signature algorithm . Digest algorithm: " + digestAlgorithmOid + ", signature algorithm: " + signatureAlgorithmOid);
        }
        String jcaDigestAlg = AlgorithmIdentifier.getJcaDigestAlgorithm(digestAlgorithmOid);
        if (jcaDigestAlg.startsWith("SHA-")) {
            jcaDigestAlg = "SHA" + jcaDigestAlg.substring("SHA-".length());
        }
        return jcaDigestAlg + "with" + suffix;
    }

    public static String getJcaDigestAlgorithm(String oid) throws SignatureException {
        String result = OidConstants.OID_TO_JCA_DIGEST_ALG.get(oid);
        if (result == null) {
            throw new SignatureException("Unsupported digest algorithm: " + oid);
        }
        return result;
    }
}

