/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.testing.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004\u001a\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u001a\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012\u001a\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u001a\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004\u001a\u0015\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001c\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"ABI_OFFSET", "", "API_OFFSET", "API_PREFIX", "", "NUM_SYSTEM_IMAGE_HASH_DIVIDERS", "SYSTEM_IMAGE_PREFIX", "VENDOR_OFFSET", "computeOffset", "systemImageHash1", "systemImageHash2", "computeSystemImageHashFromDsl", "version", "imageSource", "abi", "computeVendorString", "computeVersionString", "findClosestHashes", "", "targetHash", "allHashes", "getAbiFromHash", "systemImageHash", "getVendorFromHash", "isValidSystemImageHash", "", "hash", "parseApiFromHash", "(Ljava/lang/String;)Ljava/lang/Integer;", "common"})
public final class ManagedDeviceUtilsKt {
    @NotNull
    private static final String SYSTEM_IMAGE_PREFIX = "system-images;";
    private static final int NUM_SYSTEM_IMAGE_HASH_DIVIDERS = 3;
    @NotNull
    private static final String API_PREFIX = "android-";
    private static final int API_OFFSET = 1;
    private static final int VENDOR_OFFSET = 2;
    private static final int ABI_OFFSET = 3;

    @NotNull
    public static final String computeSystemImageHashFromDsl(int version, @NotNull String imageSource, @NotNull String abi) {
        Intrinsics.checkParameterIsNotNull((Object)imageSource, (String)"imageSource");
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        return SYSTEM_IMAGE_PREFIX + ManagedDeviceUtilsKt.computeVersionString(version) + ';' + ManagedDeviceUtilsKt.computeVendorString(imageSource) + ';' + abi;
    }

    private static final String computeVersionString(int version) {
        return Intrinsics.stringPlus((String)API_PREFIX, (Object)version);
    }

    private static final String computeVendorString(String imageSource) {
        String string;
        String string2 = imageSource;
        if (Intrinsics.areEqual((Object)string2, (Object)"google")) {
            string = "google_apis_playstore";
        } else if (Intrinsics.areEqual((Object)string2, (Object)"aosp")) {
            string = "default";
        } else {
            String string3 = StringsKt.trimIndent((String)("\n            Unrecognized systemImagevendor: " + imageSource + ". \"google\" or \"aosp\" expected.\n        "));
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> findClosestHashes(@NotNull String targetHash, @NotNull List<String> allHashes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv22;
        String it;
        Iterable $this$filterTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)targetHash, (String)"targetHash");
        Intrinsics.checkParameterIsNotNull(allHashes, (String)"allHashes");
        Iterable $this$filter$iv = allHashes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (String)element$iv$iv;
            boolean bl2 = false;
            if (!ManagedDeviceUtilsKt.isValidSystemImageHash(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv22) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            object = TuplesKt.to((Object)ManagedDeviceUtilsKt.computeOffset(targetHash, it), (Object)it);
            collection.add(object);
        }
        Iterable $this$sortedBy$iv2 = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean $this$mapTo$iv$iv22 = false;
        List hashesByOffset = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator<T>(){

            public final int compare(T a11, T b11) {
                boolean bl2 = false;
                Pair it = (Pair)a11;
                boolean bl3 = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b11;
                Comparable comparable2 = comparable;
                bl3 = false;
                Integer n11 = (Integer)it.getFirst();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n11);
            }
        });
        if (hashesByOffset.isEmpty()) {
            boolean $this$sortedBy$iv2 = false;
            return CollectionsKt.emptyList();
        }
        int smallestOffset = ((Number)((Pair)CollectionsKt.first((List)hashesByOffset)).getFirst()).intValue();
        Iterable $this$filter$iv2 = hashesByOffset;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it2 = (Pair)element$iv$iv;
            boolean bl4 = false;
            if (!(((Number)it2.getFirst()).intValue() == smallestOffset)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair it2 = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            object = (String)it2.getSecond();
            collection.add(object);
        }
        return (List)destination$iv$iv2;
    }

    public static final int computeOffset(@NotNull String systemImageHash1, @NotNull String systemImageHash2) {
        Intrinsics.checkParameterIsNotNull((Object)systemImageHash1, (String)"systemImageHash1");
        Intrinsics.checkParameterIsNotNull((Object)systemImageHash2, (String)"systemImageHash2");
        if (!ManagedDeviceUtilsKt.isValidSystemImageHash(systemImageHash1) || !ManagedDeviceUtilsKt.isValidSystemImageHash(systemImageHash2)) {
            return Integer.MAX_VALUE;
        }
        Integer api1 = ManagedDeviceUtilsKt.parseApiFromHash(systemImageHash1);
        Integer api2 = ManagedDeviceUtilsKt.parseApiFromHash(systemImageHash2);
        if (api1 == null || api2 == null) {
            return Integer.MAX_VALUE;
        }
        int offset = Math.abs(api1 - api2);
        if (!Intrinsics.areEqual((Object)ManagedDeviceUtilsKt.getVendorFromHash(systemImageHash1), (Object)ManagedDeviceUtilsKt.getVendorFromHash(systemImageHash2))) {
            ++offset;
        }
        if (!Intrinsics.areEqual((Object)ManagedDeviceUtilsKt.getAbiFromHash(systemImageHash1), (Object)ManagedDeviceUtilsKt.getAbiFromHash(systemImageHash2))) {
            ++offset;
        }
        return offset;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValidSystemImageHash(@NotNull String hash) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        if (!StringsKt.startsWith$default((String)hash, (String)SYSTEM_IMAGE_PREFIX, (boolean)false, (int)2, null)) return false;
        String $this$filter$iv = hash;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n11 = 0;
        int n12 = $this$filterTo$iv$iv.length();
        while (n11 < n12) {
            void index$iv$iv;
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt((int)index$iv$iv);
            boolean bl2 = false;
            if (it == ';') {
                destination$iv$iv.append(element$iv$iv);
            }
            ++index$iv$iv;
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
        CharSequence charSequence2 = string;
        boolean bl3 = false;
        if (charSequence2.length() != 3) return false;
        return true;
    }

    @Nullable
    public static final Integer parseApiFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkParameterIsNotNull((Object)systemImageHash, (String)"systemImageHash");
        Object object = new String[]{";"};
        String apiComponent = (String)StringsKt.split$default((CharSequence)systemImageHash, (String[])object, (boolean)false, (int)0, (int)6, null).get(1);
        if (!StringsKt.startsWith$default((String)apiComponent, (String)API_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            object = StringsKt.substringAfter$default((String)apiComponent, (String)API_PREFIX, null, (int)2, null);
            boolean bl2 = false;
            object = Integer.parseInt((String)object);
        }
        catch (NumberFormatException e11) {
            object = null;
        }
        return object;
    }

    @NotNull
    public static final String getVendorFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkParameterIsNotNull((Object)systemImageHash, (String)"systemImageHash");
        String[] stringArray = new String[]{";"};
        return (String)StringsKt.split$default((CharSequence)systemImageHash, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(2);
    }

    @NotNull
    public static final String getAbiFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkParameterIsNotNull((Object)systemImageHash, (String)"systemImageHash");
        String[] stringArray = new String[]{";"};
        return (String)StringsKt.split$default((CharSequence)systemImageHash, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(3);
    }
}

