/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.commands.AutoValue_BuildSdkApksCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.DaggerBuildSdkApksManagerComponent;
import com.android.tools.build.bundletool.commands.DebugKeystoreUtils;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.ApkListener;
import com.android.tools.build.bundletool.model.ApkModifier;
import com.android.tools.build.bundletool.model.Password;
import com.android.tools.build.bundletool.model.SdkAsar;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.BundleParser;
import com.android.tools.build.bundletool.model.utils.DefaultSystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.validation.SdkAsarValidator;
import com.android.tools.build.bundletool.validation.SdkBundleValidator;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@AutoValue
public abstract class BuildSdkApksCommand {
    private static final int DEFAULT_THREAD_POOL_SIZE = 4;
    public static final String COMMAND_NAME = "build-sdk-apks";
    private static final Integer DEFAULT_SDK_VERSION_CODE = 1;
    private static final Flag<Path> SDK_BUNDLE_LOCATION_FLAG = Flag.path("sdk-bundle");
    private static final Flag<Path> SDK_ARCHIVE_LOCATION_FLAG = Flag.path("sdk-archive");
    private static final Flag<Integer> VERSION_CODE_FLAG = Flag.positiveInteger("version-code");
    private static final Flag<Path> OUTPUT_FILE_FLAG = Flag.path("output");
    private static final Flag<OutputFormat> OUTPUT_FORMAT_FLAG = Flag.enumFlag("output-format", OutputFormat.class);
    private static final Flag<Boolean> OVERWRITE_OUTPUT_FLAG = Flag.booleanFlag("overwrite");
    private static final Flag<Path> AAPT2_PATH_FLAG = Flag.path("aapt2");
    private static final Flag<Integer> MAX_THREADS_FLAG = Flag.positiveInteger("max-threads");
    private static final Flag<Boolean> VERBOSE_FLAG = Flag.booleanFlag("verbose");
    private static final Flag<Path> KEYSTORE_FLAG = Flag.path("ks");
    private static final Flag<String> KEY_ALIAS_FLAG = Flag.string("ks-key-alias");
    private static final Flag<Password> KEYSTORE_PASSWORD_FLAG = Flag.password("ks-pass");
    private static final Flag<Password> KEY_PASSWORD_FLAG = Flag.password("key-pass");
    private static final SystemEnvironmentProvider DEFAULT_PROVIDER = new DefaultSystemEnvironmentProvider();

    abstract Optional<Path> getSdkBundlePath();

    abstract Optional<Path> getSdkArchivePath();

    abstract Integer getVersionCode();

    abstract Path getOutputFile();

    abstract boolean getOverwriteOutput();

    ListeningExecutorService getExecutorService() {
        return this.getExecutorServiceInternal();
    }

    abstract ListeningExecutorService getExecutorServiceInternal();

    public abstract boolean getVerbose();

    abstract boolean isExecutorServiceCreatedByBundleTool();

    abstract OutputFormat getOutputFormat();

    abstract Optional<Aapt2Command> getAapt2Command();

    abstract Optional<SigningConfiguration> getSigningConfiguration();

    public abstract Optional<ApkListener> getApkListener();

    public abstract Optional<ApkModifier> getApkModifier();

    public abstract Optional<Integer> getFirstVariantNumber();

    public abstract Optional<Integer> getMinSdkVersion();

    public static Builder builder() {
        return new AutoValue_BuildSdkApksCommand.Builder().setOverwriteOutput(false).setOutputFormat(OutputFormat.APK_SET).setVersionCode(DEFAULT_SDK_VERSION_CODE).setVerbose(false);
    }

    public abstract Builder toBuilder();

    public static BuildSdkApksCommand fromFlags(ParsedFlags flags) {
        return BuildSdkApksCommand.fromFlags(flags, System.out, DEFAULT_PROVIDER);
    }

    static BuildSdkApksCommand fromFlags(ParsedFlags flags, PrintStream out, SystemEnvironmentProvider provider) {
        Builder sdkApksCommandBuilder = BuildSdkApksCommand.builder().setOutputFile(OUTPUT_FILE_FLAG.getRequiredValue(flags));
        SDK_BUNDLE_LOCATION_FLAG.getValue(flags).ifPresent(sdkApksCommandBuilder::setSdkBundlePath);
        SDK_ARCHIVE_LOCATION_FLAG.getValue(flags).ifPresent(sdkApksCommandBuilder::setSdkArchivePath);
        OUTPUT_FORMAT_FLAG.getValue(flags).ifPresent(sdkApksCommandBuilder::setOutputFormat);
        OVERWRITE_OUTPUT_FLAG.getValue(flags).ifPresent(sdkApksCommandBuilder::setOverwriteOutput);
        VERSION_CODE_FLAG.getValue(flags).ifPresent(sdkApksCommandBuilder::setVersionCode);
        AAPT2_PATH_FLAG.getValue(flags).ifPresent(aapt2Path -> sdkApksCommandBuilder.setAapt2Command(Aapt2Command.createFromExecutablePath(aapt2Path)));
        MAX_THREADS_FLAG.getValue(flags).ifPresent(maxThreads -> sdkApksCommandBuilder.setExecutorService(BuildSdkApksCommand.createInternalExecutorService(maxThreads)).setExecutorServiceCreatedByBundleTool(true));
        VERBOSE_FLAG.getValue(flags).ifPresent(sdkApksCommandBuilder::setVerbose);
        BuildSdkApksCommand.populateSigningConfigurationFromFlags(sdkApksCommandBuilder, flags, out, provider);
        flags.checkNoUnknownFlags();
        return sdkApksCommandBuilder.build();
    }

    public Path execute() {
        this.validateInput();
        if (this.getSdkBundlePath().isPresent()) {
            this.executeForSdkBundle();
        } else if (this.getSdkArchivePath().isPresent()) {
            this.executeForSdkArchive();
        } else {
            throw new IllegalStateException("One and only one of SdkBundlePath and SdkArchivePath should be set.");
        }
        return this.getOutputFile();
    }

    private void executeForSdkBundle() {
        try (ZipFile bundleZip = new ZipFile(this.getSdkBundlePath().get().toFile());
             TempDirectory tempDir = new TempDirectory(this.getClass().getSimpleName());){
            SdkBundleValidator bundleValidator = SdkBundleValidator.create();
            bundleValidator.validateFile(bundleZip);
            Path modulesPath = tempDir.getPath().resolve("extracted-modules.resm");
            try (ZipFile modulesZip = BundleParser.getModulesZip(bundleZip, modulesPath);){
                bundleValidator.validateModulesFile(modulesZip);
                SdkBundle sdkBundle = SdkBundle.buildFromZip(bundleZip, modulesZip, this.getVersionCode());
                bundleValidator.validate(sdkBundle);
                this.executeBuildSdkApksManager(sdkBundle, tempDir);
            }
        }
        catch (ZipException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("The SDK Bundle is not a valid zip file.").build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException("An error occurred when processing the Sdk Bundle.", e12);
        }
        finally {
            if (this.isExecutorServiceCreatedByBundleTool()) {
                this.getExecutorService().shutdown();
            }
        }
    }

    private void executeForSdkArchive() {
        try (ZipFile sdkAsarZip = new ZipFile(this.getSdkArchivePath().get().toFile());
             TempDirectory tempDir = new TempDirectory(this.getClass().getSimpleName());){
            SdkAsarValidator.validateFile(sdkAsarZip);
            Path modulesPath = tempDir.getPath().resolve("extracted-modules.resm");
            try (ZipFile modulesZip = BundleParser.getModulesZip(sdkAsarZip, modulesPath);){
                SdkAsarValidator.validateModulesFile(modulesZip);
                SdkAsar sdkAsar = SdkAsar.buildFromZip(sdkAsarZip, modulesZip, modulesPath);
                SdkBundle sdkBundle = SdkBundle.buildFromAsar(sdkAsar, this.getVersionCode());
                SdkBundleValidator.create().validate(sdkBundle);
                this.executeBuildSdkApksManager(sdkBundle, tempDir);
            }
        }
        catch (ZipException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("The SDK archive is not a valid zip file.").build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException("An error occurred when processing the Sdk archive.", e12);
        }
        finally {
            if (this.isExecutorServiceCreatedByBundleTool()) {
                this.getExecutorService().shutdown();
            }
        }
    }

    private void executeBuildSdkApksManager(SdkBundle sdkBundle, TempDirectory tempDir) throws IOException {
        DaggerBuildSdkApksManagerComponent.builder().setBuildSdkApksCommand(this).setTempDirectory(tempDir).setSdkBundle(sdkBundle).build().create().execute();
    }

    private void validateInput() {
        this.getSdkBundlePath().ifPresent(BuildSdkApksCommand::validateSdkBundlePath);
        this.getSdkArchivePath().ifPresent(BuildSdkApksCommand::validateSdkArchivePath);
        switch (this.getOutputFormat().ordinal()) {
            case 0: {
                if (this.getOverwriteOutput()) break;
                FilePreconditions.checkFileDoesNotExist(this.getOutputFile());
                break;
            }
            case 1: {
                if (!this.getOverwriteOutput()) break;
                throw InvalidCommandException.builder().withInternalMessage("'%s' flag is not supported for '%s' output format.", new Object[]{OVERWRITE_OUTPUT_FLAG.getName(), OutputFormat.DIRECTORY}).build();
            }
        }
    }

    private static ListeningExecutorService createInternalExecutorService(int maxThreads) {
        Preconditions.checkArgument((maxThreads >= 0 ? 1 : 0) != 0, (String)"The maxThreads must be positive, got %s.", (int)maxThreads);
        return MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(maxThreads));
    }

    private static void validateSdkBundlePath(Path sdkBundlePath) {
        FilePreconditions.checkFileExistsAndReadable(sdkBundlePath);
        FilePreconditions.checkFileHasExtension("ASB file", sdkBundlePath, ".asb");
    }

    private static void validateSdkArchivePath(Path sdkArchivePath) {
        FilePreconditions.checkFileExistsAndReadable(sdkArchivePath);
        FilePreconditions.checkFileHasExtension("ASAR file", sdkArchivePath, ".asar");
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Generates APKs from an Android SDK Bundle.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(SDK_BUNDLE_LOCATION_FLAG.getName()).setExampleValue("path/to/SDKbundle.asb").setDescription("Path to SDK bundle. Must have the extension '.asb'. Cannot be used together with the `sdk-archive` flag.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(SDK_ARCHIVE_LOCATION_FLAG.getName()).setExampleValue("path/to/sdk.asar").setDescription("Path to SDK archive. Must have the extension '.asar'. Cannot be used together with the `sdk-bundle` flag.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(VERSION_CODE_FLAG.getName()).setExampleValue("1").setOptional(true).setDescription("SDK version code").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FILE_FLAG.getName()).setExampleValue("output.apks").setDescription("Path to where the APK Set archive should be created (default) or path to the directory where generated APKs should be stored when flag --%s is set to '%s'.", new Object[]{OUTPUT_FORMAT_FLAG.getName(), OutputFormat.DIRECTORY}).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FORMAT_FLAG.getName()).setExampleValue("apk_set|directory").setOptional(true).setDescription("Specifies output format for generated APKs. If set to '%s' outputs APKs into the created APK Set archive (default). If set to '%s' outputs APKs into the specified directory.", new Object[]{OutputFormat.APK_SET, OutputFormat.DIRECTORY}).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OVERWRITE_OUTPUT_FLAG.getName()).setOptional(true).setDescription("If set, any previous existing output will be overwritten.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(AAPT2_PATH_FLAG.getName()).setExampleValue("path/to/aapt2").setOptional(true).setDescription("Path to the aapt2 binary to use.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(VERBOSE_FLAG.getName()).setOptional(true).setDescription("If set, prints extra information about the command execution in the standard output.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_FLAG.getName()).setExampleValue("path/to/keystore").setDescription("Path to the keystore that should be used to sign the generated APKs.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_ALIAS_FLAG.getName()).setExampleValue("key-alias").setDescription("Alias of the key to use in the keystore to sign the generated APKs.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_PASSWORD_FLAG.getName()).setExampleValue("[pass|file]:value").setOptional(true).setDescription("Password of the keystore to use to sign the generated APKs. If provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the password will be requested on the prompt.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_PASSWORD_FLAG.getName()).setExampleValue("key-password").setOptional(true).setDescription("Password of the key in the keystore to use to sign the generated APKs. If provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the keystore password will be tried. If that fails, the password will be requested on the prompt.").build()).build();
    }

    private static void populateSigningConfigurationFromFlags(Builder buildSdkApksCommand, ParsedFlags flags, PrintStream out, SystemEnvironmentProvider provider) {
        Optional<Path> keystorePath = KEYSTORE_FLAG.getValue(flags);
        Optional<String> keyAlias = KEY_ALIAS_FLAG.getValue(flags);
        Optional<Password> keystorePassword = KEYSTORE_PASSWORD_FLAG.getValue(flags);
        Optional<Password> keyPassword = KEY_PASSWORD_FLAG.getValue(flags);
        if (keystorePath.isPresent() && keyAlias.isPresent()) {
            SignerConfig signerConfig = SignerConfig.extractFromKeystore(keystorePath.get(), keyAlias.get(), keystorePassword, keyPassword);
            SigningConfiguration.Builder builder = SigningConfiguration.builder().setSignerConfig(signerConfig);
            buildSdkApksCommand.setSigningConfiguration(builder.build());
        } else {
            if (keystorePath.isPresent() && !keyAlias.isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Flag --ks-key-alias is required when --ks is set.").build();
            }
            if (!keystorePath.isPresent() && keyAlias.isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Flag --ks is required when --ks-key-alias is set.").build();
            }
            Optional<SigningConfiguration> debugConfig = DebugKeystoreUtils.getDebugSigningConfiguration(provider);
            if (debugConfig.isPresent()) {
                out.printf("INFO: The APKs will be signed with the debug keystore found at '%s'.%n", ((Optional)DebugKeystoreUtils.DEBUG_KEYSTORE_CACHE.getUnchecked((Object)provider)).get());
                buildSdkApksCommand.setSigningConfiguration(debugConfig.get());
            } else {
                out.println("WARNING: The APKs won't be signed and thus not installable unless you also pass a keystore via the flag --ks. See the command help for more information.");
            }
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSdkBundlePath(Path var1);

        public abstract Builder setSdkArchivePath(Path var1);

        public abstract Builder setVersionCode(Integer var1);

        public abstract Builder setOutputFile(Path var1);

        public abstract Builder setOverwriteOutput(boolean var1);

        public abstract Builder setOutputFormat(OutputFormat var1);

        public abstract Builder setAapt2Command(Aapt2Command var1);

        public abstract Builder setSigningConfiguration(SigningConfiguration var1);

        public Builder setExecutorService(ListeningExecutorService executorService) {
            this.setExecutorServiceInternal(executorService);
            this.setExecutorServiceCreatedByBundleTool(false);
            return this;
        }

        abstract Builder setExecutorServiceInternal(ListeningExecutorService var1);

        abstract Optional<ListeningExecutorService> getExecutorServiceInternal();

        abstract Builder setExecutorServiceCreatedByBundleTool(boolean var1);

        public abstract Builder setVerbose(boolean var1);

        public abstract Builder setApkListener(ApkListener var1);

        public abstract Builder setApkModifier(ApkModifier var1);

        public abstract Builder setFirstVariantNumber(int var1);

        public abstract Builder setMinSdkVersion(int var1);

        abstract BuildSdkApksCommand autoBuild();

        public BuildSdkApksCommand build() {
            if (!this.getExecutorServiceInternal().isPresent()) {
                this.setExecutorServiceInternal(BuildSdkApksCommand.createInternalExecutorService(4));
                this.setExecutorServiceCreatedByBundleTool(true);
            }
            BuildSdkApksCommand command = this.autoBuild();
            Preconditions.checkState((boolean)(command.getSdkBundlePath().isPresent() ^ command.getSdkArchivePath().isPresent()), (Object)"One and only one of SdkBundlePath and SdkArchivePath should be set.");
            return command;
        }
    }

    public static enum OutputFormat {
        APK_SET,
        DIRECTORY;

    }
}

