/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Commands;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.AbstractSizeAggregator;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.model.ConfigurationSizes;
import com.android.tools.build.bundletool.model.GetSizeRequest;
import com.android.tools.build.bundletool.model.SizeConfiguration;
import com.android.tools.build.bundletool.model.utils.ResultUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;

public class VariantTotalSizeAggregator
extends AbstractSizeAggregator {
    private final Version bundleVersion;
    private final Commands.Variant variant;

    public VariantTotalSizeAggregator(ImmutableMap<String, Long> sizeByApkPaths, Version bundleVersion, Commands.Variant variant, GetSizeRequest getSizeRequest) {
        super(sizeByApkPaths, getSizeRequest);
        this.bundleVersion = bundleVersion;
        this.variant = variant;
    }

    @Override
    public ConfigurationSizes getSize() {
        if (ResultUtils.isStandaloneApkVariant(this.variant)) {
            return this.getSizeStandaloneVariant();
        }
        return this.getSizeNonStandaloneVariant();
    }

    @Override
    protected ImmutableList<ApkMatcher.GeneratedApk> getMatchingApks(Targeting.SdkVersionTargeting sdkVersionTargeting, Targeting.AbiTargeting abiTargeting, Targeting.ScreenDensityTargeting screenDensityTargeting, Targeting.LanguageTargeting languageTargeting, Targeting.TextureCompressionFormatTargeting textureTargeting, Targeting.DeviceGroupTargeting deviceGroupTargeting, Targeting.DeviceTierTargeting deviceTierTargeting, Targeting.CountrySetTargeting countrySetTargeting, Targeting.SdkRuntimeTargeting sdkRuntimeTargeting) {
        return new ApkMatcher(this.getDeviceSpec(this.getSizeRequest.getDeviceSpec(), sdkVersionTargeting, abiTargeting, screenDensityTargeting, languageTargeting, textureTargeting, deviceGroupTargeting, deviceTierTargeting, countrySetTargeting, sdkRuntimeTargeting), this.getSizeRequest.getModules(), false, this.getSizeRequest.getInstant(), false).getMatchingApksFromVariant(this.variant, this.bundleVersion);
    }

    private ConfigurationSizes getSizeNonStandaloneVariant() {
        ImmutableList apkDescriptions = (ImmutableList)this.variant.getApkSetList().stream().flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).collect(ImmutableList.toImmutableList());
        ImmutableSet sdkVersionTargetingOptions = ImmutableSet.of((Object)this.variant.getTargeting().getSdkVersionTargeting());
        ImmutableSet<Targeting.AbiTargeting> abiTargetingOptions = this.getAllAbiTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        ImmutableSet<Targeting.LanguageTargeting> languageTargetingOptions = this.getAllLanguageTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        ImmutableSet<Targeting.ScreenDensityTargeting> screenDensityTargetingOptions = this.getAllScreenDensityTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        ImmutableSet<Targeting.TextureCompressionFormatTargeting> textureCompressionFormatTargetingOptions = this.getAllTextureCompressionFormatTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        ImmutableSet<Targeting.DeviceGroupTargeting> deviceGroupTargetingOptions = this.getAllDeviceGroupTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        ImmutableSet<Targeting.DeviceTierTargeting> deviceTierTargetingOptions = this.getAllDeviceTierTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        ImmutableSet<Targeting.CountrySetTargeting> countrySetTargetingOptions = this.getAllCountrySetTargetings((ImmutableList<Commands.ApkDescription>)apkDescriptions);
        return this.getSizesPerConfiguration((ImmutableSet<Targeting.SdkVersionTargeting>)sdkVersionTargetingOptions, abiTargetingOptions, languageTargetingOptions, screenDensityTargetingOptions, textureCompressionFormatTargetingOptions, deviceGroupTargetingOptions, deviceTierTargetingOptions, countrySetTargetingOptions, this.variant.getTargeting().getSdkRuntimeTargeting());
    }

    private ConfigurationSizes getSizeStandaloneVariant() {
        Preconditions.checkState((!this.getSizeRequest.getInstant() ? 1 : 0) != 0, (Object)"Standalone Variants can't be selected when instant flag is set");
        if (this.getSizeRequest.getModules().isPresent()) {
            return ConfigurationSizes.create((ImmutableMap<SizeConfiguration, Long>)ImmutableMap.of(), (ImmutableMap<SizeConfiguration, Long>)ImmutableMap.of());
        }
        Targeting.VariantTargeting variantTargeting = this.variant.getTargeting();
        SizeConfiguration sizeConfiguration = this.mergeWithDeviceSpec(this.getSizeConfiguration(variantTargeting.getSdkVersionTargeting(), variantTargeting.getAbiTargeting(), variantTargeting.getScreenDensityTargeting(), Targeting.LanguageTargeting.getDefaultInstance(), variantTargeting.getTextureCompressionFormatTargeting(), Targeting.DeviceGroupTargeting.getDefaultInstance(), Targeting.DeviceTierTargeting.getDefaultInstance(), Targeting.CountrySetTargeting.getDefaultInstance(), variantTargeting.getSdkRuntimeTargeting()), this.getSizeRequest.getDeviceSpec());
        long compressedSize = (Long)this.sizeByApkPaths.get((Object)((Commands.ApkDescription)Iterables.getOnlyElement(((Commands.ApkSet)Iterables.getOnlyElement(this.variant.getApkSetList())).getApkDescriptionList())).getPath());
        ImmutableMap sizeConfigurationMap = ImmutableMap.of((Object)sizeConfiguration, (Object)compressedSize);
        return ConfigurationSizes.create((ImmutableMap<SizeConfiguration, Long>)sizeConfigurationMap, (ImmutableMap<SizeConfiguration, Long>)sizeConfigurationMap);
    }
}

