/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.tools.build.bundletool.model.ConfigurationSizes;
import com.android.tools.build.bundletool.model.GetSizeRequest;
import com.android.tools.build.bundletool.model.SizeConfiguration;
import com.android.tools.build.bundletool.model.utils.CsvFormatter;
import com.android.tools.build.bundletool.model.utils.SizeFormatter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class GetSizeCsvUtils {
    private static final Ordering<GetSizeRequest.Dimension> DIMENSIONS_COMPARATOR = Ordering.explicit((Object)((Object)GetSizeRequest.Dimension.SDK), (Object[])new GetSizeRequest.Dimension[]{GetSizeRequest.Dimension.ABI, GetSizeRequest.Dimension.SCREEN_DENSITY, GetSizeRequest.Dimension.LANGUAGE, GetSizeRequest.Dimension.TEXTURE_COMPRESSION_FORMAT, GetSizeRequest.Dimension.DEVICE_GROUP, GetSizeRequest.Dimension.DEVICE_TIER, GetSizeRequest.Dimension.COUNTRY_SET, GetSizeRequest.Dimension.SDK_RUNTIME});

    public static String getSizeTotalOutputInCsv(ConfigurationSizes configurationSizes, ImmutableSet<GetSizeRequest.Dimension> dimensions, SizeFormatter sizeFormatter) {
        Preconditions.checkState((boolean)configurationSizes.getMinSizeConfigurationMap().keySet().equals((Object)configurationSizes.getMaxSizeConfigurationMap().keySet()), (Object)"Min and Max maps should contains same keys.");
        CsvFormatter.Builder csvFormatter = CsvFormatter.builder();
        csvFormatter.setHeader(GetSizeCsvUtils.getSizeTotalCsvHeader(dimensions));
        for (SizeConfiguration sizeConfiguration : configurationSizes.getMinSizeConfigurationMap().keySet()) {
            csvFormatter.addRow(GetSizeCsvUtils.getSizeTotalCsvRow(sizeFormatter, dimensions, sizeConfiguration, (Long)configurationSizes.getMinSizeConfigurationMap().get((Object)sizeConfiguration), (Long)configurationSizes.getMaxSizeConfigurationMap().get((Object)sizeConfiguration)));
        }
        return csvFormatter.build().format();
    }

    private static ImmutableList<String> getSizeTotalCsvHeader(ImmutableSet<GetSizeRequest.Dimension> dimensions) {
        return (ImmutableList)Stream.concat(dimensions.stream().sorted(DIMENSIONS_COMPARATOR).map(Enum::name), Stream.of("MIN", "MAX")).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<String> getSizeTotalCsvRow(SizeFormatter sizeFormatter, ImmutableSet<GetSizeRequest.Dimension> dimensions, SizeConfiguration sizeConfiguration, long minSize, long maxSize) {
        ImmutableMap dimensionToTextMap = ImmutableMap.builder().put((Object)GetSizeRequest.Dimension.ABI, sizeConfiguration::getAbi).put((Object)GetSizeRequest.Dimension.SDK, sizeConfiguration::getSdkVersion).put((Object)GetSizeRequest.Dimension.LANGUAGE, sizeConfiguration::getLocale).put((Object)GetSizeRequest.Dimension.SCREEN_DENSITY, sizeConfiguration::getScreenDensity).put((Object)GetSizeRequest.Dimension.TEXTURE_COMPRESSION_FORMAT, sizeConfiguration::getTextureCompressionFormat).put((Object)GetSizeRequest.Dimension.DEVICE_GROUP, sizeConfiguration::getDeviceGroup).put((Object)GetSizeRequest.Dimension.DEVICE_TIER, () -> sizeConfiguration.getDeviceTier().map(i11 -> i11.toString())).put((Object)GetSizeRequest.Dimension.COUNTRY_SET, sizeConfiguration::getCountrySet).put((Object)GetSizeRequest.Dimension.SDK_RUNTIME, sizeConfiguration::getSdkRuntime).buildOrThrow();
        return (ImmutableList)Stream.concat(dimensions.stream().sorted(DIMENSIONS_COMPARATOR).map(dimension -> ((Optional)((Supplier)dimensionToTextMap.get((Object)dimension)).get()).orElse("")), Stream.of(sizeFormatter.format(minSize), sizeFormatter.format(maxSize))).collect(ImmutableList.toImmutableList());
    }

    private GetSizeCsvUtils() {
    }
}

