/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.SdkBundleConfigProto;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.FingerprintDigestValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.function.Predicate;

public class SdkBundleConfigValidator
extends SubValidator {
    @Override
    public void validateSdkBundle(SdkBundle sdkBundle) {
        this.validateSdkBundleConfig(sdkBundle.getSdkBundleConfig());
    }

    @VisibleForTesting
    void validateSdkBundleConfig(SdkBundleConfigProto.SdkBundleConfig sdkBundleConfig) {
        this.validateNonEmptyPackageNames(sdkBundleConfig);
        this.validateUniqueDependencies(sdkBundleConfig);
        this.validateDependencyVersionsAreValid(sdkBundleConfig);
        this.validateDependencyCertificatesAreValid(sdkBundleConfig);
    }

    private void validateNonEmptyPackageNames(SdkBundleConfigProto.SdkBundleConfig sdkBundleConfig) {
        if (sdkBundleConfig.getSdkDependenciesList().stream().map(SdkBundleConfigProto.SdkBundle::getPackageName).anyMatch(String::isEmpty)) {
            throw InvalidBundleException.builder().withUserMessage("Package names of SDK dependencies in the SdkBundleConfig file cannot be empty.").build();
        }
    }

    private void validateUniqueDependencies(SdkBundleConfigProto.SdkBundleConfig sdkBundleConfig) {
        HashSet existingPackageNames = new HashSet();
        ImmutableSet duplicatePackageNames = (ImmutableSet)sdkBundleConfig.getSdkDependenciesList().stream().map(SdkBundleConfigProto.SdkBundle::getPackageName).filter((Predicate<String>)Predicates.not(existingPackageNames::add)).collect(ImmutableSet.toImmutableSet());
        if (!duplicatePackageNames.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("SDK dependencies in the SdkBundleConfig file have repeated package names: %s.", duplicatePackageNames).build();
        }
    }

    private void validateDependencyVersionsAreValid(SdkBundleConfigProto.SdkBundleConfig sdkBundleConfig) {
        for (SdkBundleConfigProto.SdkBundle dependency : sdkBundleConfig.getSdkDependenciesList()) {
            if (dependency.getVersionMajor() < 0 || dependency.getVersionMajor() > 199999) {
                throw InvalidBundleException.builder().withUserMessage("SDK major version for dependency '%s' must be an integer between 0 and %d.", dependency.getPackageName(), 199999).build();
            }
            if (dependency.getVersionMinor() < 0 || dependency.getVersionMinor() > 9999) {
                throw InvalidBundleException.builder().withUserMessage("SDK minor version for dependency '%s' must be an integer between 0 and %d.", dependency.getPackageName(), 9999).build();
            }
            if (dependency.getBuildTimeVersionPatch() >= 0) continue;
            throw InvalidBundleException.builder().withUserMessage("SDK patch version must be a non-negative integer.").build();
        }
    }

    private void validateDependencyCertificatesAreValid(SdkBundleConfigProto.SdkBundleConfig sdkBundleConfig) {
        for (SdkBundleConfigProto.SdkBundle dependency : sdkBundleConfig.getSdkDependenciesList()) {
            if (FingerprintDigestValidator.isValidFingerprintDigest(dependency.getCertificateDigest())) continue;
            throw InvalidBundleException.builder().withUserMessage("Certificate digest for dependency '%s' has an invalid format.", dependency.getPackageName()).build();
        }
    }
}

