/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.tools.build.bundletool.io.SplitApkSerializer;
import com.android.tools.build.bundletool.io.StandaloneApkSerializer;
import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ApkSetBuilderFactory {
    public static ApkSetBuilder createApkSetBuilder(SplitApkSerializer splitApkSerializer, StandaloneApkSerializer standaloneApkSerializer, Path tempDir) {
        return new ApkSetArchiveBuilder(splitApkSerializer, standaloneApkSerializer, tempDir);
    }

    public static ApkSetBuilder createApkSetWithoutArchiveBuilder(SplitApkSerializer splitApkSerializer, StandaloneApkSerializer standaloneApkSerializer, Path outputDir) {
        return new ApkSetWithoutArchiveBuilder(splitApkSerializer, standaloneApkSerializer, outputDir);
    }

    public static class ApkSetWithoutArchiveBuilder
    implements ApkSetBuilder {
        private final SplitApkSerializer splitApkSerializer;
        private final StandaloneApkSerializer standaloneApkSerializer;
        private final Path outputDirectory;

        public ApkSetWithoutArchiveBuilder(SplitApkSerializer splitApkSerializer, StandaloneApkSerializer standaloneApkSerializer, Path outputDirectory) {
            this.outputDirectory = outputDirectory;
            this.splitApkSerializer = splitApkSerializer;
            this.standaloneApkSerializer = standaloneApkSerializer;
        }

        @Override
        public Commands.ApkDescription addInstantApk(ModuleSplit split, ZipPath apkPath) {
            return this.splitApkSerializer.writeInstantSplitToDisk(split, this.outputDirectory, apkPath);
        }

        @Override
        public Commands.ApkDescription addSplitApk(ModuleSplit split, ZipPath apkPath) {
            return this.splitApkSerializer.writeSplitToDisk(split, this.outputDirectory, apkPath);
        }

        @Override
        public Commands.ApkDescription addAssetSliceApk(ModuleSplit split, ZipPath apkPath) {
            return this.splitApkSerializer.writeAssetSliceToDisk(split, this.outputDirectory, apkPath);
        }

        @Override
        public Commands.ApkDescription addStandaloneApk(ModuleSplit split, ZipPath apkPath) {
            return this.standaloneApkSerializer.writeToDisk(split, this.outputDirectory, apkPath);
        }

        @Override
        public Commands.ApkDescription addStandaloneUniversalApk(ModuleSplit split) {
            return this.standaloneApkSerializer.writeToDiskAsUniversal(split, this.outputDirectory);
        }

        @Override
        public Commands.ApkDescription addSystemApk(ModuleSplit split, ZipPath apkPath) {
            return this.standaloneApkSerializer.writeSystemApkToDisk(split, this.outputDirectory, apkPath);
        }

        @Override
        public void setTableOfContentsFile(Commands.BuildApksResult tableOfContentsProto) {
            this.writeProtoFile((Message)tableOfContentsProto, this.outputDirectory.resolve("toc.pb"));
        }

        @Override
        public void writeTo(Path destinationPath) {
        }

        private void writeProtoFile(Message proto, Path outputFile) {
            try (OutputStream outputStream = Files.newOutputStream(outputFile, new OpenOption[0]);){
                proto.writeTo(outputStream);
            }
            catch (FileNotFoundException e4) {
                throw new UncheckedIOException("Can't create the output file: " + outputFile, e4);
            }
            catch (IOException e5) {
                throw new UncheckedIOException("Error while writing the output file: " + outputFile, e5);
            }
        }
    }

    public static class ApkSetArchiveBuilder
    implements ApkSetBuilder {
        private final SplitApkSerializer splitApkSerializer;
        private final StandaloneApkSerializer standaloneApkSerializer;
        private final List<String> relativeApkPaths;
        private final Path tempDirectory;
        private Commands.BuildApksResult tableOfContents;

        public ApkSetArchiveBuilder(SplitApkSerializer splitApkSerializer, StandaloneApkSerializer standaloneApkSerializer, Path tempDirectory) {
            this.splitApkSerializer = splitApkSerializer;
            this.standaloneApkSerializer = standaloneApkSerializer;
            this.tempDirectory = tempDirectory;
            this.relativeApkPaths = Collections.synchronizedList(new ArrayList());
        }

        @Override
        public Commands.ApkDescription addSplitApk(ModuleSplit split, ZipPath apkPath) {
            Commands.ApkDescription apkDescription = this.splitApkSerializer.writeSplitToDisk(split, this.tempDirectory, apkPath);
            this.relativeApkPaths.add(apkDescription.getPath());
            return apkDescription;
        }

        @Override
        public Commands.ApkDescription addInstantApk(ModuleSplit split, ZipPath apkPath) {
            Commands.ApkDescription apkDescription = this.splitApkSerializer.writeInstantSplitToDisk(split, this.tempDirectory, apkPath);
            this.relativeApkPaths.add(apkDescription.getPath());
            return apkDescription;
        }

        @Override
        public Commands.ApkDescription addAssetSliceApk(ModuleSplit split, ZipPath apkPath) {
            Commands.ApkDescription apkDescription = this.splitApkSerializer.writeAssetSliceToDisk(split, this.tempDirectory, apkPath);
            this.relativeApkPaths.add(apkDescription.getPath());
            return apkDescription;
        }

        @Override
        public Commands.ApkDescription addStandaloneApk(ModuleSplit split, ZipPath apkPath) {
            Commands.ApkDescription apkDescription = this.standaloneApkSerializer.writeToDisk(split, this.tempDirectory, apkPath);
            this.relativeApkPaths.add(apkDescription.getPath());
            return apkDescription;
        }

        @Override
        public Commands.ApkDescription addStandaloneUniversalApk(ModuleSplit split) {
            Commands.ApkDescription apkDescription = this.standaloneApkSerializer.writeToDiskAsUniversal(split, this.tempDirectory);
            this.relativeApkPaths.add(apkDescription.getPath());
            return apkDescription;
        }

        @Override
        public Commands.ApkDescription addSystemApk(ModuleSplit split, ZipPath apkPath) {
            Commands.ApkDescription apkDescription = this.standaloneApkSerializer.writeSystemApkToDisk(split, this.tempDirectory, apkPath);
            this.relativeApkPaths.add(apkDescription.getPath());
            return apkDescription;
        }

        @Override
        public void setTableOfContentsFile(Commands.BuildApksResult tableOfContentsProto) {
            this.tableOfContents = tableOfContentsProto;
        }

        @Override
        public void writeTo(Path destinationPath) {
            ZipBuilder apkSetZipBuilder = new ZipBuilder();
            if (this.tableOfContents != null) {
                apkSetZipBuilder.addFileWithProtoContent(ZipPath.create("toc.pb"), (MessageLite)this.tableOfContents, new ZipBuilder.EntryOption[0]);
            }
            for (String relativeApkPath : ImmutableList.sortedCopyOf(this.relativeApkPaths)) {
                Path fullApkPath = this.tempDirectory.resolve(relativeApkPath);
                FilePreconditions.checkFileExistsAndReadable(fullApkPath);
                apkSetZipBuilder.addFileFromDisk(ZipPath.create(relativeApkPath), fullApkPath.toFile(), ZipBuilder.EntryOption.UNCOMPRESSED);
            }
            try {
                apkSetZipBuilder.writeTo(destinationPath);
            }
            catch (IOException e4) {
                throw new UncheckedIOException(String.format("Error while writing the APK Set archive to '%s'.", destinationPath), e4);
            }
        }
    }

    public static interface ApkSetBuilder {
        public Commands.ApkDescription addSplitApk(ModuleSplit var1, ZipPath var2);

        public Commands.ApkDescription addStandaloneApk(ModuleSplit var1, ZipPath var2);

        public Commands.ApkDescription addStandaloneUniversalApk(ModuleSplit var1);

        public Commands.ApkDescription addInstantApk(ModuleSplit var1, ZipPath var2);

        public Commands.ApkDescription addSystemApk(ModuleSplit var1, ZipPath var2);

        public Commands.ApkDescription addAssetSliceApk(ModuleSplit var1, ZipPath var2);

        public void setTableOfContentsFile(Commands.BuildApksResult var1);

        public void writeTo(Path var1);
    }
}

