/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import shadow.bundletool.com.android.tools.r8.graph.Z;
import shadow.bundletool.com.android.tools.r8.graph.j0;
import shadow.bundletool.com.android.tools.r8.q.a.a.b.N2;
import shadow.bundletool.com.android.tools.r8.q.a.a.b.X;
import shadow.bundletool.com.android.tools.r8.q.a.a.b.w;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardTypeMatcher;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardWildcard;
import shadow.bundletool.com.android.tools.r8.t.a.a.a.h.G;
import shadow.bundletool.com.android.tools.r8.t.a.a.a.h.H;
import shadow.bundletool.com.android.tools.r8.t.a.a.a.h.a;
import shadow.bundletool.com.android.tools.r8.t.a.a.a.h.z0;

public abstract class ProguardClassNameList {
    public static Builder builder() {
        return new Builder();
    }

    public static ProguardClassNameList emptyList() {
        return new EmptyClassNameList();
    }

    public static ProguardClassNameList singletonList(ProguardTypeMatcher proguardTypeMatcher) {
        return new SingleClassNameList(proguardTypeMatcher);
    }

    static Iterable<ProguardWildcard> getWildcardsOrEmpty(ProguardClassNameList proguardClassNameList) {
        return proguardClassNameList == null ? Collections::emptyIterator : proguardClassNameList.getWildcards();
    }

    public abstract int size();

    public abstract void writeTo(StringBuilder var1);

    public String toString() {
        StringBuilder stringBuilder;
        ProguardClassNameList proguardClassNameList = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        proguardClassNameList.writeTo(new StringBuilder());
        return stringBuilder2.toString();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract List<j0> asSpecificDexTypes();

    public abstract boolean matches(j0 var1);

    protected Iterable<ProguardWildcard> getWildcards() {
        return Collections::emptyIterator;
    }

    public boolean hasWildcards() {
        return this.getWildcards().iterator().hasNext();
    }

    protected ProguardClassNameList materialize(Z z4) {
        return this;
    }

    public abstract void forEachTypeMatcher(Consumer<ProguardTypeMatcher> var1);

    private static class MixedClassNameList
    extends ProguardClassNameList {
        private final H<ProguardTypeMatcher> classNames;

        private MixedClassNameList(H<ProguardTypeMatcher> h4) {
            this.classNames = h4;
        }

        @Override
        public int size() {
            return ((G)this.classNames).size();
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
            boolean bl = true;
            for (H.a a5 : ((G)this.classNames).i()) {
                if (!bl) {
                    stringBuilder.append(',');
                }
                if (((a)(a5 = (a)a5)).b()) {
                    stringBuilder.append('!');
                }
                stringBuilder.append(((ProguardTypeMatcher)((a)a5).getKey()).toString());
                bl = false;
            }
        }

        @Override
        public boolean equals(Object object) {
            if (mixedClassNameList2 == object) {
                return true;
            }
            if (object != null && mixedClassNameList2.getClass() == object.getClass()) {
                MixedClassNameList mixedClassNameList = mixedClassNameList2;
                MixedClassNameList mixedClassNameList2 = (MixedClassNameList)object;
                return Objects.equals(mixedClassNameList.classNames, mixedClassNameList2.classNames);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.classNames);
        }

        @Override
        public List<j0> asSpecificDexTypes() {
            return null;
        }

        @Override
        public boolean matches(j0 j02) {
            z0 z02 = ((G)((MixedClassNameList)((Object)z02)).classNames).i().iterator();
            while (z02.hasNext()) {
                a a5 = (a)((H.a)z02.next());
                if (!((ProguardTypeMatcher)a5.getKey()).matches(j02)) continue;
                return a5.b() ^ true;
            }
            return false;
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return ((G)this.classNames).keySet().stream().map(ProguardTypeMatcher::getWildcards).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false))::iterator;
        }

        @Override
        protected ProguardClassNameList materialize(Z z4) {
            Builder builder = ProguardClassNameList.builder();
            this.classNames.forEach((proguardTypeMatcher, bl) -> {
                boolean bl2 = bl;
                builder.addClassName(bl2, proguardTypeMatcher.materialize(z4));
            });
            return builder.build();
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            ((G)this.classNames).i().forEach(a5 -> consumer.accept((ProguardTypeMatcher)((a)a5).getKey()));
        }
    }

    private static class PositiveClassNameList
    extends ProguardClassNameList {
        private final X<ProguardTypeMatcher> classNames;

        private PositiveClassNameList(Collection<ProguardTypeMatcher> collection) {
            this.classNames = X.a(collection);
        }

        @Override
        public int size() {
            return this.classNames.size();
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
            boolean bl = true;
            N2<ProguardTypeMatcher> n22 = this.classNames.e();
            while (n22.hasNext()) {
                ProguardTypeMatcher proguardTypeMatcher = (ProguardTypeMatcher)n22.next();
                if (!bl) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(proguardTypeMatcher);
                bl = false;
            }
        }

        @Override
        public boolean equals(Object object) {
            if (positiveClassNameList2 == object) {
                return true;
            }
            if (object != null && positiveClassNameList2.getClass() == object.getClass()) {
                PositiveClassNameList positiveClassNameList = positiveClassNameList2;
                PositiveClassNameList positiveClassNameList2 = (PositiveClassNameList)object;
                return Objects.equals(positiveClassNameList.classNames, positiveClassNameList2.classNames);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.classNames);
        }

        @Override
        public List<j0> asSpecificDexTypes() {
            if (this.classNames.stream().allMatch(proguardTypeMatcher -> proguardTypeMatcher.getSpecificType() != null)) {
                return this.classNames.stream().map(ProguardTypeMatcher::getSpecificType).collect(Collectors.toList());
            }
            return null;
        }

        @Override
        public boolean matches(j0 j02) {
            return this.classNames.stream().anyMatch(proguardTypeMatcher -> proguardTypeMatcher.matches(j02));
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return this.classNames.stream().map(ProguardTypeMatcher::getWildcards).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false))::iterator;
        }

        @Override
        protected PositiveClassNameList materialize(Z z4) {
            return new PositiveClassNameList(this.classNames.stream().map(proguardTypeMatcher -> proguardTypeMatcher.materialize(z4)).collect(Collectors.toList()));
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            this.classNames.forEach(consumer);
        }
    }

    static class SingleClassNameList
    extends ProguardClassNameList {
        final ProguardTypeMatcher className;

        private SingleClassNameList(ProguardTypeMatcher proguardTypeMatcher) {
            this.className = proguardTypeMatcher;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
            stringBuilder.append(this.className.toString());
        }

        @Override
        public boolean equals(Object object) {
            if (singleClassNameList2 == object) {
                return true;
            }
            if (object != null && singleClassNameList2.getClass() == object.getClass()) {
                SingleClassNameList singleClassNameList = singleClassNameList2;
                SingleClassNameList singleClassNameList2 = (SingleClassNameList)object;
                return Objects.equals(singleClassNameList.className, singleClassNameList2.className);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.className);
        }

        @Override
        public List<j0> asSpecificDexTypes() {
            j0 j02 = ((SingleClassNameList)((Object)j02)).className.getSpecificType();
            return j02 == null ? null : Collections.singletonList(j02);
        }

        @Override
        public boolean matches(j0 j02) {
            return this.className.matches(j02);
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return this.className.getWildcards();
        }

        @Override
        protected SingleClassNameList materialize(Z z4) {
            return new SingleClassNameList(this.className.materialize(z4));
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            consumer.accept(this.className);
        }
    }

    private static class EmptyClassNameList
    extends ProguardClassNameList {
        private EmptyClassNameList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof EmptyClassNameList;
        }

        @Override
        public int hashCode() {
            return 7;
        }

        @Override
        public List<j0> asSpecificDexTypes() {
            return null;
        }

        @Override
        public boolean matches(j0 j02) {
            return false;
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
        }
    }

    public static class Builder {
        private final H<ProguardTypeMatcher> matchers;

        private Builder() {
            G g4;
            G g5 = g4;
            g4 = new G();
            v1.matchers = g5;
        }

        public Builder addClassName(boolean bl, ProguardTypeMatcher proguardTypeMatcher) {
            Builder builder = this;
            ((G)builder.matchers).a(proguardTypeMatcher, bl);
            return builder;
        }

        ProguardClassNameList build() {
            if (((G)this.matchers).a(true)) {
                return new MixedClassNameList(this.matchers);
            }
            if (((G)this.matchers).size() == 1) {
                return new SingleClassNameList((ProguardTypeMatcher)w.b(((G)this.matchers).keySet()));
            }
            return new PositiveClassNameList(((G)this.matchers).keySet());
        }
    }
}

