/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.androidtools;

import com.android.tools.build.bundletool.androidtools.CommandExecutor;
import com.android.tools.build.bundletool.androidtools.DefaultCommandExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Logger;

public interface AdbCommand {
    public static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(5L);

    public ImmutableList<String> installMultiPackage(ImmutableListMultimap<String, String> var1, boolean var2, boolean var3, Optional<Duration> var4, Optional<String> var5);

    public static AdbCommand create(Path adbPath) {
        return new DefaultAdbCommand(adbPath);
    }

    public static class DefaultAdbCommand
    implements AdbCommand {
        private static final Logger logger = Logger.getLogger(DefaultAdbCommand.class.getName());
        private final Path adbPath;

        public DefaultAdbCommand(Path adbPath) {
            this.adbPath = adbPath;
        }

        @Override
        public ImmutableList<String> installMultiPackage(ImmutableListMultimap<String, String> apkToInstallByPackage, boolean staged, boolean enableRollback, Optional<Duration> timeout, Optional<String> deviceId) {
            return this.installMultiPackage(apkToInstallByPackage, staged, enableRollback, timeout, deviceId, new DefaultCommandExecutor());
        }

        @VisibleForTesting
        ImmutableList<String> installMultiPackage(ImmutableListMultimap<String, String> apkToInstallByPackage, boolean staged, boolean enableRollback, Optional<Duration> timeout, Optional<String> deviceId, CommandExecutor commandExecutor) {
            ImmutableList.Builder commandBuilder = ImmutableList.builder().add((Object)this.adbPath.toString());
            deviceId.ifPresent(id -> commandBuilder.add((Object[])new String[]{"-s", id}));
            commandBuilder.add((Object)"install-multi-package");
            if (staged) {
                commandBuilder.add((Object)"--staged");
            }
            if (enableRollback) {
                commandBuilder.add((Object)"--enable-rollback");
            }
            if (timeout.isPresent()) {
                commandBuilder.add((Object)"--staged-ready-timeout").add((Object)String.format("%d", timeout.get().toMillis()));
            }
            apkToInstallByPackage.keySet().forEach(packageName -> commandBuilder.add((Object)String.join((CharSequence)":", (Iterable<? extends CharSequence>)apkToInstallByPackage.get(packageName))));
            logger.info(String.format("Executing: %s", String.join((CharSequence)" ", (Iterable<? extends CharSequence>)commandBuilder.build())));
            return commandExecutor.executeAndCapture((ImmutableList<String>)commandBuilder.build(), CommandExecutor.CommandOptions.builder().setTimeout(DEFAULT_TIMEOUT).build());
        }
    }
}

