/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.io.ByteSource;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

public class SdkBundleSerializer {
    public void writeToDisk(SdkBundle bundle, Path pathOnDisk) throws IOException {
        ZipBuilder zipBuilder = new ZipBuilder();
        zipBuilder.addFileWithProtoContent(ZipPath.create("BundleConfig.pb"), (MessageLite)bundle.getBundleConfig(), new ZipBuilder.EntryOption[0]);
        for (Map.Entry metadataEntry : bundle.getBundleMetadata().getFileContentMap().entrySet()) {
            zipBuilder.addFile(AppBundle.METADATA_DIRECTORY.resolve((ZipPath)metadataEntry.getKey()), (ByteSource)metadataEntry.getValue(), new ZipBuilder.EntryOption[0]);
        }
        BundleModule module = bundle.getModule();
        ZipPath moduleDir = ZipPath.create(module.getName().toString());
        for (ModuleEntry entry : module.getEntries()) {
            ZipPath entryPath = moduleDir.resolve(entry.getPath());
            zipBuilder.addFile(entryPath, entry.getContent(), new ZipBuilder.EntryOption[0]);
        }
        zipBuilder.addFileWithProtoContent(moduleDir.resolve(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath()), (MessageLite)module.getAndroidManifest().getManifestRoot().getProto(), new ZipBuilder.EntryOption[0]);
        module.getAssetsConfig().ifPresent(assetsConfig -> zipBuilder.addFileWithProtoContent(moduleDir.resolve(BundleModule.SpecialModuleEntry.ASSETS_TABLE.getPath()), (MessageLite)assetsConfig, new ZipBuilder.EntryOption[0]));
        module.getNativeConfig().ifPresent(nativeConfig -> zipBuilder.addFileWithProtoContent(moduleDir.resolve(BundleModule.SpecialModuleEntry.NATIVE_LIBS_TABLE.getPath()), (MessageLite)nativeConfig, new ZipBuilder.EntryOption[0]));
        module.getResourceTable().ifPresent(resourceTable -> zipBuilder.addFileWithProtoContent(moduleDir.resolve(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath()), (MessageLite)resourceTable, new ZipBuilder.EntryOption[0]));
        zipBuilder.writeTo(pathOnDisk);
    }
}

