/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SdkBundleHasOneModuleValidator
extends SubValidator {
    @Override
    public void validateBundleZipFile(ZipFile bundleFile) {
        this.checkSdkHasSingleModule(bundleFile);
    }

    private void checkSdkHasSingleModule(ZipFile bundleFile) {
        ImmutableSet<ZipPath> moduleDirectories = this.getModuleDirectories(bundleFile);
        if (moduleDirectories.size() != 1) {
            throw InvalidBundleException.builder().withUserMessage("SDK bundles need exactly one module, %d detected.", moduleDirectories.size()).build();
        }
    }

    private ImmutableSet<ZipPath> getModuleDirectories(ZipFile bundleFile) {
        return (ImmutableSet)Collections.list(bundleFile.entries()).stream().map(ZipEntry::getName).map(ZipPath::create).filter(entryPath -> entryPath.getNameCount() > 1).map(entryPath -> entryPath.getName(0)).filter((Predicate<ZipPath>)Predicates.not(arg_0 -> SdkBundle.NON_MODULE_DIRECTORIES.contains(arg_0))).collect(ImmutableSet.toImmutableSet());
    }
}

