/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import shadow.bundletool.com.android.ddmlib.Log;

public class ByteBufferUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer mapFile(File f5, long offset, ByteOrder byteOrder) throws IOException {
        try (FileInputStream dataFile = new FileInputStream(f5);){
            FileChannel fc = dataFile.getChannel();
            MappedByteBuffer buffer = fc.map(FileChannel.MapMode.READ_ONLY, offset, f5.length() - offset);
            buffer.order(byteOrder);
            MappedByteBuffer mappedByteBuffer = buffer;
            return mappedByteBuffer;
        }
    }

    public static String getString(ByteBuffer buf, int len) {
        char[] data = new char[len];
        for (int i4 = 0; i4 < len; ++i4) {
            data[i4] = buf.getChar();
        }
        return new String(data);
    }

    public static void putString(ByteBuffer buf, String str) {
        int len = str.length();
        for (int i4 = 0; i4 < len; ++i4) {
            buf.putChar(str.charAt(i4));
        }
    }

    public static boolean cleanBuffer(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            return true;
        }
        try {
            Class<?> unsafeClass = ByteBufferUtil.class.getClassLoader().loadClass("sun.misc.Unsafe");
            Field f5 = unsafeClass.getDeclaredField("theUnsafe");
            f5.setAccessible(true);
            Object unsafe = f5.get(null);
            MethodType type = MethodType.methodType(Void.TYPE, ByteBuffer.class);
            MethodHandle handle = MethodHandles.lookup().findVirtual(unsafeClass, "invokeCleaner", type);
            handle.invoke(unsafeClass.cast(unsafe), buffer);
            return true;
        }
        catch (Throwable ex) {
            Log.w("ddmlib", "ByteBufferUtil.cleanBuffer() failed " + ex);
            return false;
        }
    }
}

