/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.internal;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import shadow.bundletool.com.android.ddmlib.DdmJdwpExtension;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.internal.ClientImpl;
import shadow.bundletool.com.android.ddmlib.internal.Debugger;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.ChunkHandler;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import shadow.bundletool.com.android.ddmlib.jdwp.JdwpExtension;

public final class MonitorThread
extends Thread {
    private final DdmJdwpExtension mDdmJdwpExtension;
    private volatile boolean mQuit = false;
    private final ArrayList<ClientImpl> mClientList = new ArrayList();
    private Selector mSelector;
    private final List<JdwpExtension> mJdwpExtensions;
    private static MonitorThread sInstance;

    private MonitorThread() {
        super("Monitor");
        this.mDdmJdwpExtension = new DdmJdwpExtension();
        this.mJdwpExtensions = new LinkedList<JdwpExtension>();
        this.mJdwpExtensions.add(this.mDdmJdwpExtension);
    }

    public static MonitorThread createInstance() {
        sInstance = new MonitorThread();
        return sInstance;
    }

    public static MonitorThread getInstance() {
        return sInstance;
    }

    public boolean getRetryOnBadHandshake() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientImpl[] getClients() {
        ArrayList<ClientImpl> arrayList = this.mClientList;
        synchronized (arrayList) {
            return this.mClientList.toArray(new ClientImpl[0]);
        }
    }

    public synchronized void registerChunkHandler(int type, ChunkHandler handler) {
        if (sInstance == null) {
            return;
        }
        this.mDdmJdwpExtension.registerHandler(type, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Log.d("ddms", "Monitor is up");
        try {
            this.mSelector = Selector.open();
        }
        catch (IOException ioe) {
            Log.logAndDisplay(Log.LogLevel.ERROR, "ddms", "Failed to initialize Monitor Thread: " + ioe.getMessage());
            return;
        }
        while (!this.mQuit) {
            int count;
            ArrayList<ClientImpl> ioe = this.mClientList;
            synchronized (ioe) {
            }
            try {
                count = this.mSelector.select();
            }
            catch (IOException ioe2) {
                ioe2.printStackTrace();
                continue;
            }
            catch (CancelledKeyException cke) {
            }
            try {
                if (count == 0) continue;
                Set<SelectionKey> keys = this.mSelector.selectedKeys();
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    try {
                        if (key.attachment() instanceof ClientImpl) {
                            this.processClientActivity(key);
                            continue;
                        }
                        if (key.attachment() instanceof Debugger) {
                            this.processDebuggerActivity(key);
                            continue;
                        }
                        Log.e("ddms", "unknown activity key");
                    }
                    catch (Exception e5) {
                        Log.e("ddms", "Exception during activity from Selector.");
                        Log.e("ddms", e5);
                    }
                }
            }
            catch (Exception e6) {
                Log.e("ddms", "Exception MonitorThread.run()");
                Log.e("ddms", e6);
            }
        }
    }

    private void processClientActivity(SelectionKey key) {
        ClientImpl client = (ClientImpl)key.attachment();
        try {
            if (!key.isReadable() || !key.isValid()) {
                Log.d("ddms", "Invalid key from " + client + ". Dropping client.");
                this.dropClient(client, true);
                return;
            }
            client.read();
            JdwpPacket packet = client.getJdwpPacket();
            while (packet != null) {
                packet.log("Client: received jdwp packet");
                client.incoming(packet, client.getDebugger());
                packet.consume();
                packet = client.getJdwpPacket();
            }
        }
        catch (CancelledKeyException e5) {
            this.dropClient(client, true);
        }
        catch (IOException ex) {
            this.dropClient(client, true);
        }
        catch (Exception ex) {
            Log.e("ddms", ex);
            this.dropClient(client, true);
            if (ex instanceof BufferOverflowException) {
                Log.w("ddms", "Client data packet exceeded maximum buffer size " + client);
            }
            Log.e("ddms", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dropClient(ClientImpl client, boolean notify) {
        if (sInstance == null) {
            return;
        }
        ArrayList<ClientImpl> arrayList = this.mClientList;
        synchronized (arrayList) {
            if (!this.mClientList.remove(client)) {
                return;
            }
        }
        client.close(notify);
        this.mDdmJdwpExtension.broadcast(DdmJdwpExtension.Event.CLIENT_DISCONNECTED, client);
        this.wakeup();
    }

    public synchronized void dropClients(Collection<? extends ClientImpl> clients, boolean notify) {
        for (ClientImpl clientImpl : clients) {
            this.dropClient(clientImpl, notify);
        }
    }

    private void processDebuggerActivity(SelectionKey key) {
        Debugger dbg = (Debugger)key.attachment();
        try {
            if (key.isAcceptable()) {
                try {
                    this.acceptNewDebugger(dbg, null);
                }
                catch (IOException ioe) {
                    Log.w("ddms", "debugger accept() failed");
                    ioe.printStackTrace();
                }
            } else if (key.isReadable()) {
                this.processDebuggerData(key);
            } else {
                Log.d("ddm-debugger", "key in unknown state");
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptNewDebugger(Debugger dbg, ServerSocketChannel acceptChan) throws IOException {
        ArrayList<ClientImpl> arrayList = this.mClientList;
        synchronized (arrayList) {
            SocketChannel chan = acceptChan == null ? dbg.accept() : dbg.accept(acceptChan);
            if (chan != null) {
                chan.socket().setTcpNoDelay(true);
                this.wakeup();
                try {
                    chan.register(this.mSelector, 1, dbg);
                }
                catch (IOException ioe) {
                    dbg.closeData();
                    throw ioe;
                }
                catch (RuntimeException re) {
                    dbg.closeData();
                    throw re;
                }
            } else {
                Log.w("ddms", "ignoring duplicate debugger");
            }
        }
    }

    private void processDebuggerData(SelectionKey key) {
        Debugger dbg = (Debugger)key.attachment();
        dbg.processChannelData();
    }

    private void wakeup() {
        if (this.mSelector != null) {
            this.mSelector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void quit() {
        this.mQuit = true;
        this.wakeup();
        Log.d("ddms", "Waiting for Monitor thread");
        try {
            this.join();
            ArrayList<ClientImpl> arrayList = this.mClientList;
            synchronized (arrayList) {
                for (ClientImpl c5 : this.mClientList) {
                    c5.close(false);
                    this.mDdmJdwpExtension.broadcast(DdmJdwpExtension.Event.CLIENT_DISCONNECTED, c5);
                }
                this.mClientList.clear();
            }
            if (this.mSelector != null) {
                this.mSelector.close();
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (IOException e5) {
            e5.printStackTrace();
        }
        sInstance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addClient(ClientImpl client) {
        if (sInstance == null) {
            return;
        }
        Log.d("ddms", "Adding new client " + client);
        ArrayList<ClientImpl> arrayList = this.mClientList;
        synchronized (arrayList) {
            this.mClientList.add(client);
            for (JdwpExtension extension : this.mJdwpExtensions) {
                extension.intercept(client);
            }
            try {
                this.wakeup();
                client.register(this.mSelector);
                Debugger dbg = client.getDebugger();
                if (dbg != null) {
                    dbg.registerListener(this.mSelector);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public DdmJdwpExtension getDdmExtension() {
        return this.mDdmJdwpExtension;
    }
}

