/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultBuildType;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.internal.reflect.Instantiator;

public class BuildType
extends DefaultBuildType
implements CoreBuildType,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Project project;
    private final Logger logger;
    private final NdkOptions ndkConfig;
    private Boolean useJack;
    private boolean shrinkResources = false;
    private boolean useProguard = true;

    public BuildType(String name, Project project, Instantiator instantiator, Logger logger) {
        super(name);
        this.project = project;
        this.logger = logger;
        this.ndkConfig = (NdkOptions)instantiator.newInstance(NdkOptions.class, new Object[0]);
    }

    BuildType(String name, Project project, Logger logger) {
        super(name);
        this.project = project;
        this.logger = logger;
        this.ndkConfig = null;
    }

    @Override
    public CoreNdkOptions getNdkConfig() {
        return this.ndkConfig;
    }

    public void init(SigningConfig debugSigningConfig) {
        if ("debug".equals(this.getName())) {
            this.setDebuggable(true);
            this.setEmbedMicroApp(false);
            assert (debugSigningConfig != null);
            this.setSigningConfig(debugSigningConfig);
        } else if ("release".equals(this.getName())) {
            // empty if block
        }
    }

    public SigningConfig getSigningConfig() {
        return (SigningConfig)super.getSigningConfig();
    }

    protected void _initWith(BaseConfig that) {
        super._initWith(that);
        BuildType thatBuildType = (BuildType)that;
        this.shrinkResources = thatBuildType.isShrinkResources();
        this.useJack = thatBuildType.getUseJack();
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.useJack != null ? this.useJack.hashCode() : 0);
        result = 31 * result + (this.shrinkResources ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildType other = (BuildType)o;
        if (this.useJack != other.getUseJack()) {
            return false;
        }
        return this.shrinkResources == other.isShrinkResources();
    }

    public void buildConfigField(String type, String name, String value) {
        ClassField alreadyPresent = (ClassField)this.getBuildConfigFields().get(name);
        if (alreadyPresent != null) {
            this.logger.info("BuildType({}): buildConfigField '{}' value is being replaced: {} -> {}", new Object[]{this.getName(), name, alreadyPresent.getValue(), value});
        }
        this.addBuildConfigField(AndroidBuilder.createClassField((String)type, (String)name, (String)value));
    }

    public void resValue(String type, String name, String value) {
        ClassField alreadyPresent = (ClassField)this.getResValues().get(name);
        if (alreadyPresent != null) {
            this.logger.info("BuildType({}): resValue '{}' value is being replaced: {} -> {}", new Object[]{this.getName(), name, alreadyPresent.getValue(), value});
        }
        this.addResValue(AndroidBuilder.createClassField((String)type, (String)name, (String)value));
    }

    public BuildType proguardFile(Object proguardFile) {
        this.getProguardFiles().add(this.project.file(proguardFile));
        return this;
    }

    public BuildType proguardFiles(Object ... proguardFiles) {
        this.getProguardFiles().addAll(this.project.files(proguardFiles).getFiles());
        return this;
    }

    public BuildType setProguardFiles(Iterable<?> proguardFileIterable) {
        this.getProguardFiles().clear();
        for (Object proguardFile : proguardFileIterable) {
            this.getProguardFiles().add(this.project.file(proguardFile));
        }
        return this;
    }

    public BuildType testProguardFile(Object proguardFile) {
        this.getTestProguardFiles().add(this.project.file(proguardFile));
        return this;
    }

    public BuildType testProguardFiles(Object ... proguardFiles) {
        this.getTestProguardFiles().addAll(this.project.files(proguardFiles).getFiles());
        return this;
    }

    public void setTestProguardFiles(Iterable<?> files) {
        this.getTestProguardFiles().clear();
        for (Object proguardFile : files) {
            this.getTestProguardFiles().add(this.project.file(proguardFile));
        }
    }

    public BuildType consumerProguardFiles(Object ... proguardFiles) {
        this.getConsumerProguardFiles().addAll(this.project.files(proguardFiles).getFiles());
        return this;
    }

    public void consumerProguardFile(Object proguardFile) {
        this.getConsumerProguardFiles().add(this.project.file(proguardFile));
    }

    public BuildType setConsumerProguardFiles(Iterable<?> proguardFileIterable) {
        this.getConsumerProguardFiles().clear();
        for (Object proguardFile : proguardFileIterable) {
            this.getConsumerProguardFiles().add(this.project.file(proguardFile));
        }
        return this;
    }

    public void ndk(Action<NdkOptions> action) {
        action.execute((Object)this.ndkConfig);
    }

    @Override
    public Boolean getUseJack() {
        return this.useJack;
    }

    public void setUseJack(Boolean useJack) {
        this.useJack = useJack;
    }

    public void useJack(Boolean useJack) {
        this.setUseJack(useJack);
    }

    @Override
    public boolean isShrinkResources() {
        return this.shrinkResources;
    }

    @Override
    public boolean isUseProguard() {
        return this.useProguard;
    }

    public void setUseProguard(boolean useProguard) {
        this.useProguard = useProguard;
    }

    public void useProguard(boolean useProguard) {
        this.setUseProguard(useProguard);
    }

    public void setShrinkResources(boolean shrinkResources) {
        this.shrinkResources = shrinkResources;
    }

    public void shrinkResources(boolean flag) {
        this.shrinkResources = flag;
    }

    public void jarJarRuleFile(Object file) {
        this.getJarJarRuleFiles().add(this.project.file(file));
    }

    public void jarJarRuleFiles(Object ... files) {
        this.getJarJarRuleFiles().clear();
        for (Object file : files) {
            this.getJarJarRuleFiles().add(this.project.file(file));
        }
    }
}

