/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.builder.core.BuilderConstants;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.SimpleTestRunner;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.GradleException;
import org.gradle.api.Nullable;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskAction;
import org.gradle.logging.ConsoleRenderer;

public class DeviceProviderInstrumentTestTask
extends BaseTask
implements AndroidTestTask {
    private File reportsDir;
    private File resultsDir;
    private File coverageDir;
    private String flavorName;
    @Nullable
    private Collection<String> installOptions;
    private DeviceProvider deviceProvider;
    private TestData testData;
    private File adbExec;
    @Nullable
    private File splitSelectExec;
    private ProcessExecutor processExecutor;
    private boolean ignoreFailures;
    private boolean testFailed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    protected void runTests() throws DeviceException, IOException, InterruptedException, TestRunner.NoAuthorizedDeviceFoundException, TestException {
        File resultsOutDir = this.getResultsDir();
        FileUtils.emptyFolder((File)resultsOutDir);
        File coverageOutDir = this.getCoverageDir();
        FileUtils.emptyFolder((File)coverageOutDir);
        boolean success = false;
        if (!this.testsFound()) {
            this.getLogger().info("No tests found, nothing to do.");
            File emptyCoverageFile = new File(coverageOutDir, "coverage.ec");
            emptyCoverageFile.createNewFile();
            success = true;
        } else {
            File testApk = this.testData.getTestApk();
            String flavor = this.getFlavorName();
            SimpleTestRunner testRunner = new SimpleTestRunner(this.getSplitSelectExec(), this.getProcessExecutor());
            this.deviceProvider.init();
            ImmutableList extraArgs = this.installOptions == null || this.installOptions.isEmpty() ? ImmutableList.of() : this.installOptions;
            try {
                success = testRunner.runTests(this.getProject().getName(), flavor, testApk, this.testData, this.deviceProvider.getDevices(), this.deviceProvider.getMaxThreads(), this.deviceProvider.getTimeoutInMs(), (Collection)extraArgs, resultsOutDir, coverageOutDir, this.getILogger());
            }
            finally {
                this.deviceProvider.terminate();
            }
        }
        File reportOutDir = this.getReportsDir();
        FileUtils.emptyFolder((File)reportOutDir);
        TestReport report = new TestReport(ReportType.SINGLE_FLAVOR, resultsOutDir, reportOutDir);
        report.generateReport();
        if (!success) {
            this.testFailed = true;
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message = "There were failing tests. See the report at: " + reportUrl;
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message);
                return;
            }
            throw new GradleException(message);
        }
        this.testFailed = false;
    }

    private boolean testsFound() {
        return !this.getProject().files(new Object[]{this.testData.getTestDirectories()}).getAsFileTree().isEmpty();
    }

    public File getReportsDir() {
        return this.reportsDir;
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    @Override
    public File getResultsDir() {
        return this.resultsDir;
    }

    public void setResultsDir(File resultsDir) {
        this.resultsDir = resultsDir;
    }

    public File getCoverageDir() {
        return this.coverageDir;
    }

    public void setCoverageDir(File coverageDir) {
        this.coverageDir = coverageDir;
    }

    public String getFlavorName() {
        return this.flavorName;
    }

    public void setFlavorName(String flavorName) {
        this.flavorName = flavorName;
    }

    public Collection<String> getInstallOptions() {
        return this.installOptions;
    }

    public void setInstallOptions(Collection<String> installOptions) {
        this.installOptions = installOptions;
    }

    public DeviceProvider getDeviceProvider() {
        return this.deviceProvider;
    }

    public void setDeviceProvider(DeviceProvider deviceProvider) {
        this.deviceProvider = deviceProvider;
    }

    public TestData getTestData() {
        return this.testData;
    }

    public void setTestData(TestData testData) {
        this.testData = testData;
    }

    public File getAdbExec() {
        return this.adbExec;
    }

    public void setAdbExec(File adbExec) {
        this.adbExec = adbExec;
    }

    public File getSplitSelectExec() {
        return this.splitSelectExec;
    }

    public void setSplitSelectExec(File splitSelectExec) {
        this.splitSelectExec = splitSelectExec;
    }

    public ProcessExecutor getProcessExecutor() {
        return this.processExecutor;
    }

    public void setProcessExecutor(ProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Override
    public boolean getTestFailed() {
        return this.testFailed;
    }

    public static class ConfigAction
    implements TaskConfigAction<DeviceProviderInstrumentTestTask> {
        private final VariantScope scope;
        private final DeviceProvider deviceProvider;
        private final TestData testData;

        public ConfigAction(VariantScope scope, DeviceProvider deviceProvider, TestData testData) {
            this.scope = scope;
            this.deviceProvider = deviceProvider;
            this.testData = testData;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName(this.deviceProvider.getName());
        }

        @Override
        public Class<DeviceProviderInstrumentTestTask> getType() {
            return DeviceProviderInstrumentTestTask.class;
        }

        @Override
        public void execute(DeviceProviderInstrumentTestTask task) {
            String variantName;
            boolean connected = this.deviceProvider instanceof ConnectedDeviceProvider;
            String string = variantName = this.scope.getTestedVariantData() != null ? this.scope.getTestedVariantData().getName() : this.scope.getVariantData().getName();
            if (connected) {
                task.setDescription("Installs and runs the tests for " + variantName + " on connected devices.");
            } else {
                task.setDescription("Installs and runs the tests for " + variantName + " using provider: " + StringHelper.capitalize((String)this.deviceProvider.getName()));
            }
            task.setGroup("verification");
            task.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            task.setVariantName(variantName);
            task.setTestData(this.testData);
            task.setFlavorName(this.testData.getFlavorName());
            task.setDeviceProvider(this.deviceProvider);
            task.setInstallOptions(this.scope.getGlobalScope().getExtension().getAdbOptions().getInstallOptions());
            task.setProcessExecutor(this.scope.getGlobalScope().getAndroidBuilder().getProcessExecutor());
            String flavorFolder = this.testData.getFlavorName();
            if (!flavorFolder.isEmpty()) {
                flavorFolder = "flavors/" + flavorFolder;
            }
            String providerFolder = connected ? "connected" : "device/" + this.deviceProvider.getName();
            final String subFolder = "/" + providerFolder + "/" + flavorFolder;
            ConventionMappingHelper.map((Task)task, "adbExec", new Callable<File>(){

                @Override
                public File call() {
                    SdkInfo info = ConfigAction.this.scope.getGlobalScope().getSdkHandler().getSdkInfo();
                    return info == null ? null : info.getAdb();
                }
            });
            ConventionMappingHelper.map((Task)task, "splitSelectExec", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    String path;
                    TargetInfo info = ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getTargetInfo();
                    String string = path = info == null ? null : info.getBuildTools().getPath(BuildToolInfo.PathId.SPLIT_SELECT);
                    if (path != null) {
                        File splitSelectExe = new File(path);
                        return splitSelectExe.exists() ? splitSelectExe : null;
                    }
                    return null;
                }
            });
            ConventionMappingHelper.map((Task)task, "resultsDir", new Callable<File>(){

                @Override
                public File call() {
                    String rootLocation = ConfigAction.this.scope.getGlobalScope().getExtension().getTestOptions().getResultsDir();
                    if (rootLocation == null) {
                        rootLocation = ConfigAction.this.scope.getGlobalScope().getBuildDir() + "/" + "outputs" + "/" + BuilderConstants.FD_ANDROID_RESULTS;
                    }
                    return ConfigAction.this.scope.getGlobalScope().getProject().file((Object)(rootLocation + subFolder));
                }
            });
            ConventionMappingHelper.map((Task)task, "reportsDir", new Callable<File>(){

                @Override
                public File call() {
                    String rootLocation = ConfigAction.this.scope.getGlobalScope().getExtension().getTestOptions().getReportDir();
                    if (rootLocation == null) {
                        rootLocation = ConfigAction.this.scope.getGlobalScope().getBuildDir() + "/" + "reports" + "/" + "androidTests";
                    }
                    return ConfigAction.this.scope.getGlobalScope().getProject().file((Object)(rootLocation + subFolder));
                }
            });
            String rootLocation = this.scope.getGlobalScope().getBuildDir() + "/" + "outputs" + "/code-coverage";
            task.setCoverageDir(this.scope.getGlobalScope().getProject().file((Object)(rootLocation + subFolder)));
            if (this.scope.getVariantData() instanceof TestVariantData) {
                TestVariantData testVariantData = (TestVariantData)this.scope.getVariantData();
                if (connected) {
                    testVariantData.connectedTestTask = task;
                } else {
                    testVariantData.providerTestTaskList.add(task);
                }
            }
            task.setEnabled(this.deviceProvider.isConfigured());
        }
    }
}

