/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.OptionalCompilationStep;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.ChangeRecords;
import com.android.build.gradle.internal.transforms.InstantRunBuildType;
import com.android.build.gradle.tasks.ColdswapArtifactsKickerTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.gradle.api.logging.Logger;

public class InstantRunDex
extends Transform {
    private final AndroidBuilder androidBuilder;
    private final DexOptions dexOptions;
    private final ILogger logger;
    private final Set<QualifiedContent.ContentType> inputTypes;
    private final InstantRunBuildType buildType;
    private final VariantScope variantScope;
    private final InstantRunBuildContext instantRunBuildContext;

    public InstantRunDex(VariantScope variantScope, InstantRunBuildType buildType, AndroidBuilder androidBuilder, DexOptions dexOptions, Logger logger, Set<QualifiedContent.ContentType> inputTypes) {
        this.variantScope = variantScope;
        this.buildType = buildType;
        this.androidBuilder = androidBuilder;
        this.dexOptions = dexOptions;
        this.logger = new LoggerWrapper(logger);
        this.inputTypes = inputTypes;
        this.instantRunBuildContext = variantScope.getInstantRunBuildContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        File outputFolder = this.buildType.getOutputFolder(this.variantScope);
        boolean changesAreCompatible = this.variantScope.getInstantRunBuildContext().hasPassedVerification();
        boolean restartDexRequested = this.variantScope.getGlobalScope().isActive(OptionalCompilationStep.RESTART_ONLY);
        switch (this.buildType) {
            case RELOAD: {
                if (changesAreCompatible && !restartDexRequested) break;
                FileUtils.emptyFolder((File)outputFolder);
                return;
            }
            case RESTART: {
                if (changesAreCompatible && !restartDexRequested) {
                    if (outputFolder.exists()) {
                        for (File file : outputFolder.listFiles()) {
                            if (file.getName().equals("build-info.xml") || file.delete()) continue;
                            this.logger.warning("Cannot delete " + file, new Object[0]);
                        }
                    }
                    return;
                }
                this.logger.warning("InstantRun incompatible change detected for API 20 or below, full APK rebuild necessary, aborting", new Object[0]);
                this.instantRunBuildContext.abort();
                File incremental = this.buildType.getIncrementalChangesFile(this.variantScope);
                if (incremental.exists()) {
                    incremental.delete();
                }
                return;
            }
            default: {
                throw new RuntimeException("Unhandled build type " + (Object)((Object)this.buildType));
            }
        }
        File classesJar = new File(outputFolder, "classes.jar");
        if (classesJar.exists()) {
            classesJar.delete();
        }
        Files.createParentDirs((File)classesJar);
        final JarClassesBuilder jarClassesBuilder = this.getJarClassBuilder(classesJar);
        try {
            for (TransformInput input : invocation.getReferencedInputs()) {
                for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                    if (!directoryInput.getContentTypes().containsAll(this.inputTypes)) continue;
                    final File folder = directoryInput.getFile();
                    File incremental = this.buildType.getIncrementalChangesFile(this.variantScope);
                    if (!incremental.exists()) continue;
                    ChangeRecords.process(incremental, new ChangeRecords.RecordHandler(){

                        @Override
                        public void handle(String filePath, Status status) throws IOException {
                            jarClassesBuilder.add(folder, new File(filePath));
                        }
                    });
                }
            }
        }
        finally {
            jarClassesBuilder.close();
        }
        if (jarClassesBuilder.isEmpty()) {
            FileUtils.emptyFolder((File)outputFolder);
            if (!classesJar.delete()) {
                this.logger.warning("Cannot delete tmp file : " + classesJar.getAbsolutePath(), new Object[0]);
            }
            return;
        }
        ImmutableList.Builder inputFiles = ImmutableList.builder();
        inputFiles.add((Object)classesJar);
        try {
            this.variantScope.getInstantRunBuildContext().startRecording(InstantRunBuildContext.TaskType.INSTANT_RUN_DEX);
            this.convertByteCode((List<File>)inputFiles.build(), outputFolder);
            this.variantScope.getInstantRunBuildContext().addChangedFile(this.buildType == InstantRunBuildType.RELOAD ? InstantRunBuildContext.FileType.RELOAD_DEX : InstantRunBuildContext.FileType.RESTART_DEX, new File(outputFolder, "classes.dex"));
        }
        catch (ProcessException e) {
            throw new TransformException((Throwable)e);
        }
        finally {
            this.variantScope.getInstantRunBuildContext().stopRecording(InstantRunBuildContext.TaskType.INSTANT_RUN_DEX);
        }
    }

    protected void convertByteCode(List<File> inputFiles, File outputFolder) throws InterruptedException, ProcessException, IOException {
        this.androidBuilder.convertByteCode(inputFiles, outputFolder, false, null, this.dexOptions, (List)ImmutableList.of(), false, true, (ProcessOutputHandler)new LoggedProcessOutputHandler(this.logger), true);
    }

    protected JarClassesBuilder getJarClassBuilder(File outputFile) {
        return new JarClassesBuilder(outputFile);
    }

    private static void copyFileInJar(File inputDir, File inputFile, JarOutputStream jarOutputStream) throws IOException {
        String entryName = inputFile.getPath().substring(inputDir.getPath().length() + 1);
        JarEntry jarEntry = new JarEntry(entryName);
        jarOutputStream.putNextEntry(jarEntry);
        Files.copy((File)inputFile, (OutputStream)jarOutputStream);
        jarOutputStream.closeEntry();
    }

    public String getName() {
        return "instant+" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.buildType.name()) + "Dex";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.inputTypes;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return ImmutableSet.of();
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[0]);
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        return this.buildType == InstantRunBuildType.RESTART ? ImmutableList.of((Object)new SecondaryFile(ColdswapArtifactsKickerTask.ConfigAction.getMarkerFile(this.variantScope), true)) : ImmutableList.of();
    }

    public boolean isIncremental() {
        return false;
    }

    static class JarClassesBuilder {
        final File outputFile;
        JarOutputStream jarOutputStream;
        boolean empty = true;

        JarClassesBuilder(File outputFile) {
            this.outputFile = outputFile;
        }

        void add(File inputDir, File file) throws IOException {
            if (this.jarOutputStream == null) {
                this.jarOutputStream = new JarOutputStream(new FileOutputStream(this.outputFile));
            }
            this.empty = false;
            InstantRunDex.copyFileInJar(inputDir, file, this.jarOutputStream);
        }

        void close() throws IOException {
            if (this.jarOutputStream != null) {
                this.jarOutputStream.close();
            }
        }

        boolean isEmpty() {
            return this.empty;
        }
    }
}

