/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.shrinker.ClassLookupException;
import com.android.build.gradle.shrinker.Dependency;
import com.android.build.gradle.shrinker.DependencyType;
import com.android.build.gradle.shrinker.FilterMembersVisitor;
import com.android.build.gradle.shrinker.PostProcessingData;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.android.build.gradle.shrinker.TypeHierarchyTraverser;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.FileUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public abstract class AbstractShrinker<T> {
    private static final boolean IGNORE_PACKAGE_NAME = Boolean.getBoolean("android.newShrinker.ignorePackageName");
    protected final WaitableExecutor<Void> mExecutor;
    protected final ShrinkerGraph<T> mGraph;
    protected final ShrinkerLogger mShrinkerLogger;

    protected AbstractShrinker(ShrinkerGraph<T> graph, WaitableExecutor<Void> executor, ShrinkerLogger shrinkerLogger) {
        this.mGraph = graph;
        this.mExecutor = executor;
        this.mShrinkerLogger = shrinkerLogger;
    }

    static boolean isSdkPackage(String className) {
        if (IGNORE_PACKAGE_NAME) {
            return false;
        }
        return className.startsWith("java/") || className.startsWith("android/") && !className.contains("/support/");
    }

    protected Optional<File> chooseOutputFile(T klass, File classFile, Iterable<TransformInput> inputs, TransformOutputProvider output) {
        String classFilePath = classFile.getAbsolutePath();
        for (TransformInput input : inputs) {
            Iterable directoriesAndJars = Iterables.concat((Iterable)input.getDirectoryInputs(), (Iterable)input.getJarInputs());
            for (QualifiedContent directoryOrJar : directoriesAndJars) {
                File file = directoryOrJar.getFile();
                if (!classFilePath.startsWith(file.getAbsolutePath())) continue;
                File outputDir = output.getContentLocation(FileUtils.getDirectoryNameForJar((File)file), directoryOrJar.getContentTypes(), directoryOrJar.getScopes(), Format.DIRECTORY);
                return Optional.of((Object)new File(outputDir, this.mGraph.getClassName(klass) + ".class"));
            }
        }
        return Optional.absent();
    }

    protected static Collection<File> getAllDirectories(TransformInput input) {
        ArrayList files = Lists.newArrayList();
        for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
            files.add(directoryInput.getFile());
        }
        return files;
    }

    protected static Collection<File> getAllJars(TransformInput input) {
        ArrayList files = Lists.newArrayList();
        for (JarInput jarInput : input.getJarInputs()) {
            files.add(jarInput.getFile());
        }
        return files;
    }

    protected void incrementCounter(T member, DependencyType dependencyType, CounterSet counterSet) {
        if (this.mGraph.incrementAndCheck(member, dependencyType, counterSet)) {
            for (Dependency<T> dependency : this.mGraph.getDependencies(member)) {
                this.incrementCounter(dependency.target, dependency.type, counterSet);
            }
        }
    }

    protected void resolveReferences(Iterable<PostProcessingData.UnresolvedReference<T>> unresolvedReferences) {
        for (final PostProcessingData.UnresolvedReference<T> unresolvedReference : unresolvedReferences) {
            this.mExecutor.execute((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    Object target = unresolvedReference.target;
                    Object source = unresolvedReference.method;
                    Object startClass = AbstractShrinker.this.mGraph.getClassForMember(target);
                    if (unresolvedReference.invokespecial) {
                        Object sourceClass = AbstractShrinker.this.mGraph.getClassForMember(source);
                        try {
                            startClass = AbstractShrinker.this.mGraph.getSuperclass(sourceClass);
                            Preconditions.checkState((startClass != null ? 1 : 0) != 0);
                        }
                        catch (ClassLookupException e) {
                            AbstractShrinker.this.mShrinkerLogger.invalidClassReference(AbstractShrinker.this.mGraph.getClassName(sourceClass), e.getClassName());
                        }
                    }
                    if (!AbstractShrinker.this.mGraph.isClassKnown(startClass)) {
                        AbstractShrinker.this.mShrinkerLogger.invalidClassReference(AbstractShrinker.this.mGraph.getMemberName(source), AbstractShrinker.this.mGraph.getClassName(startClass));
                        return null;
                    }
                    TypeHierarchyTraverser traverser = TypeHierarchyTraverser.superclassesAndInterfaces(AbstractShrinker.this.mGraph, AbstractShrinker.this.mShrinkerLogger);
                    for (Object currentClass : traverser.preOrderTraversal(startClass)) {
                        Object matchingMethod = AbstractShrinker.this.mGraph.findMatchingMethod(currentClass, target);
                        if (matchingMethod == null) continue;
                        if (AbstractShrinker.this.isProgramClass(AbstractShrinker.this.mGraph.getClassForMember(matchingMethod))) {
                            AbstractShrinker.this.mGraph.addDependency(source, currentClass, unresolvedReference.dependencyType);
                            AbstractShrinker.this.mGraph.addDependency(source, matchingMethod, unresolvedReference.dependencyType);
                        }
                        return null;
                    }
                    AbstractShrinker.this.mShrinkerLogger.invalidMemberReference(AbstractShrinker.this.mGraph.getMemberName(source), AbstractShrinker.this.mGraph.getMemberName(target));
                    return null;
                }
            });
        }
    }

    protected boolean isProgramClass(T klass) {
        return !this.mGraph.isLibraryClass(klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] rewrite(String className, File classFile, Set<String> membersToKeep, Predicate<String> keepInterface) throws IOException {
        byte[] bytes;
        if (Files.getFileExtension((String)classFile.getName()).equals("class")) {
            bytes = Files.toByteArray((File)classFile);
        } else {
            JarFile jarFile = new JarFile(classFile);
            try {
                JarEntry jarEntry = jarFile.getJarEntry(className + ".class");
                bytes = ByteStreams.toByteArray((InputStream)jarFile.getInputStream(jarEntry));
            }
            finally {
                jarFile.close();
            }
        }
        ClassReader classReader = new ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(0);
        FilterMembersVisitor filter = new FilterMembersVisitor(membersToKeep, keepInterface, (ClassVisitor)classWriter);
        classReader.accept((ClassVisitor)filter, 0);
        return classWriter.toByteArray();
    }

    protected void setCounters(final CounterSet counterSet) {
        Map<T, DependencyType> roots = this.mGraph.getRoots(counterSet);
        for (final Map.Entry<T, DependencyType> toIncrementEntry : roots.entrySet()) {
            this.mExecutor.execute((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    AbstractShrinker.this.incrementCounter(toIncrementEntry.getKey(), (DependencyType)((Object)toIncrementEntry.getValue()), counterSet);
                    return null;
                }
            });
        }
        this.waitForAllTasks();
    }

    protected void updateClassFiles(Iterable<T> classesToWrite, Iterable<File> classFilesToDelete, Iterable<TransformInput> inputs, TransformOutputProvider output) throws IOException {
        for (final T klass : classesToWrite) {
            final File sourceFile = this.mGraph.getSourceFile(klass);
            Preconditions.checkState((sourceFile != null ? 1 : 0) != 0, (Object)"Program class has no source file.");
            Optional<File> outputFile = this.chooseOutputFile(klass, sourceFile, inputs, output);
            if (!outputFile.isPresent()) continue;
            Files.createParentDirs((File)((File)outputFile.get()));
            Predicate<String> keepInterfacePredicate = new Predicate<String>(){

                public boolean apply(String input) {
                    Object iface = AbstractShrinker.this.mGraph.getClassReference(input);
                    return !AbstractShrinker.this.isProgramClass(iface) || AbstractShrinker.this.mGraph.isReachable(iface, CounterSet.SHRINK);
                }
            };
            this.mExecutor.execute((Callable)new Callable<Void>((Predicate)keepInterfacePredicate, outputFile){
                final /* synthetic */ Predicate val$keepInterfacePredicate;
                final /* synthetic */ Optional val$outputFile;
                {
                    this.val$keepInterfacePredicate = predicate;
                    this.val$outputFile = optional;
                }

                @Override
                public Void call() throws Exception {
                    byte[] newBytes = AbstractShrinker.rewrite(AbstractShrinker.this.mGraph.getClassName(klass), sourceFile, AbstractShrinker.this.mGraph.getReachableMembersLocalNames(klass, CounterSet.SHRINK), (Predicate<String>)this.val$keepInterfacePredicate);
                    Files.write((byte[])newBytes, (File)((File)this.val$outputFile.get()));
                    return null;
                }
            });
        }
        for (File classFile : classFilesToDelete) {
            FileUtils.delete((File)classFile);
        }
        this.waitForAllTasks();
    }

    protected void waitForAllTasks() {
        try {
            this.mExecutor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (LoggedErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public static void logTime(String section, Stopwatch stopwatch) {
        if (System.getProperty("android.newShrinker.profile") != null) {
            System.out.println(section + ": " + stopwatch);
            stopwatch.reset();
            stopwatch.start();
        }
    }

    public static enum CounterSet {
        SHRINK,
        LEGACY_MULTIDEX;

    }
}

