/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.builder.model.OptionalCompilationStep;
import com.android.repository.api.Channel;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.StringTokenizer;
import org.gradle.api.Project;

@Deprecated
public class AndroidGradleOptions {
    public static final String USE_DEPRECATED_NDK = "android.useDeprecatedNdk";
    public static final String PROPERTY_KEEP_TIMESTAMPS_IN_APK = "android.keepTimestampsInApk";
    public static final String ANDROID_ADVANCED_PROFILING_TRANSFORMS = "android.advanced.profiling.transforms";
    public static final String ANDROID_SDK_CHANNEL = "android.sdk.channel";
    public static final String PROPERTY_SHARD_TESTS_BETWEEN_DEVICES = "android.androidTest.shardBetweenDevices";
    public static final String PROPERTY_SHARD_COUNT = "android.androidTest.numShards";
    public static final String PROPERTY_USE_SDK_DOWNLOAD = "android.builder.sdkDownload";
    public static final String GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY = "android.overrideVersionCheck";
    public static final String OLD_GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY = "com.android.build.gradle.overrideVersionCheck";
    public static final String OVERRIDE_PATH_CHECK_PROPERTY = "android.overridePathCheck";
    public static final String OLD_OVERRIDE_PATH_CHECK_PROPERTY = "com.android.build.gradle.overridePathCheck";

    public static boolean getUseSdkDownload(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_USE_SDK_DOWNLOAD, true) && !AndroidGradleOptions.invokedFromIde(project);
    }

    public static boolean getShardAndroidTestsBetweenDevices(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_SHARD_TESTS_BETWEEN_DEVICES, false);
    }

    public static Integer getInstrumentationShardCount(Project project) {
        return AndroidGradleOptions.getInteger(project, PROPERTY_SHARD_COUNT);
    }

    public static boolean invokedFromIde(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.invoked.from.ide");
    }

    public static boolean buildModelOnly(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only");
    }

    public static boolean refreshExternalNativeModel(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.refresh.external.native.model");
    }

    public static boolean buildModelOnlyAdvanced(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only.advanced");
    }

    public static boolean keepTimestampsInApk(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_KEEP_TIMESTAMPS_IN_APK);
    }

    public static boolean getTestOnly(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.testOnly");
    }

    public static Integer buildModelOnlyVersion(Project project) {
        String revision = AndroidGradleOptions.getString(project, "android.injected.build.model.only.versioned");
        if (revision != null) {
            return Integer.parseInt(revision);
        }
        if (AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only.advanced")) {
            return 1;
        }
        if (AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only")) {
            return 0;
        }
        return null;
    }

    public static boolean buildModelWithFullDependencies(Project project) {
        String value = AndroidGradleOptions.getString(project, "android.injected.build.model.feature.full.dependencies");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public static File getApkLocation(Project project) {
        String locString = AndroidGradleOptions.getString(project, "android.injected.apk.location");
        if (locString == null) {
            return null;
        }
        return project.file((Object)locString);
    }

    public static String getBuildTargetDensity(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.build.density");
    }

    public static String getBuildTargetAbi(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.build.abi");
    }

    public static AndroidVersion getTargetAndroidVersion(Project project) {
        Integer apiLevel = AndroidGradleOptions.getInteger(project, "android.injected.build.api");
        if (apiLevel == null) {
            return AndroidVersion.DEFAULT;
        }
        String codeName = AndroidGradleOptions.getString(project, "android.injected.build.codename");
        return new AndroidVersion(apiLevel.intValue(), codeName);
    }

    public static boolean useDeprecatedNdk(Project project) {
        return AndroidGradleOptions.getBoolean(project, USE_DEPRECATED_NDK);
    }

    public static EnumSet<OptionalCompilationStep> getOptionalCompilationSteps(Project project) {
        String values = AndroidGradleOptions.getString(project, "android.optional.compilation");
        if (values != null) {
            ArrayList<OptionalCompilationStep> optionalCompilationSteps = new ArrayList<OptionalCompilationStep>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                optionalCompilationSteps.add(OptionalCompilationStep.valueOf((String)st.nextToken()));
            }
            return EnumSet.copyOf(optionalCompilationSteps);
        }
        return EnumSet.noneOf(OptionalCompilationStep.class);
    }

    private static String getString(Project project, String propertyName) {
        return project.hasProperty(propertyName) ? project.property(propertyName).toString() : null;
    }

    private static Integer getInteger(Project project, String propertyName) {
        if (project.hasProperty(propertyName)) {
            try {
                return Integer.parseInt(project.property(propertyName).toString());
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Property " + propertyName + " needs to be an integer.");
            }
        }
        return null;
    }

    private static Long getLong(Project project, String propertyName) {
        if (project.hasProperty(propertyName)) {
            try {
                return Long.parseLong(project.property(propertyName).toString());
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Property " + propertyName + " needs to be a long.");
            }
        }
        return null;
    }

    private static boolean getBoolean(Project project, String propertyName) {
        return AndroidGradleOptions.getBoolean(project, propertyName, false);
    }

    private static boolean getBoolean(Project project, String propertyName, boolean defaultValue) {
        if (project.hasProperty(propertyName)) {
            Object value = project.property(propertyName);
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
        }
        return defaultValue;
    }

    public static String[] getAdvancedProfilingTransforms(Project project) {
        String string = AndroidGradleOptions.getString(project, ANDROID_ADVANCED_PROFILING_TRANSFORMS);
        return string == null ? new String[]{} : string.split(",");
    }

    public static String getRestrictVariantProject(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.restrict.variant.project");
    }

    public static String getRestrictVariantName(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.restrict.variant.name");
    }

    public static Channel getSdkChannel(Project project) {
        Integer channel = AndroidGradleOptions.getInteger(project, ANDROID_SDK_CHANNEL);
        if (channel != null) {
            return Channel.create((int)channel);
        }
        return Channel.DEFAULT;
    }

    public static boolean overrideGradleVersionCheck(Project project) {
        if (project.hasProperty(GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY)) {
            return AndroidGradleOptions.getBoolean(project, GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY);
        }
        return Boolean.getBoolean(OLD_GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY);
    }

    public static boolean overridePathCheck(Project project) {
        if (project.hasProperty(OVERRIDE_PATH_CHECK_PROPERTY)) {
            return AndroidGradleOptions.getBoolean(project, OVERRIDE_PATH_CHECK_PROPERTY);
        }
        if (project.hasProperty(OLD_OVERRIDE_PATH_CHECK_PROPERTY)) {
            return AndroidGradleOptions.getBoolean(project, OLD_OVERRIDE_PATH_CHECK_PROPERTY);
        }
        return Boolean.getBoolean(OLD_OVERRIDE_PATH_CHECK_PROPERTY);
    }
}

