/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.DefaultGradlePackagingScope;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AppPreBuildTask;
import com.android.build.gradle.internal.tasks.ApplicationId;
import com.android.build.gradle.internal.tasks.ApplicationIdWriterTask;
import com.android.build.gradle.internal.tasks.TestPreBuildTask;
import com.android.build.gradle.internal.transforms.InstantRunDependenciesApkBuilder;
import com.android.build.gradle.internal.transforms.InstantRunSliceSplitApkBuilder;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.AndroidJarTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.profile.Recorder;
import com.android.utils.FileUtils;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ApplicationTaskManager
extends TaskManager {
    public ApplicationTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(TaskFactory tasks, VariantScope variantScope) {
        BaseVariantData variantData = variantScope.getVariantData();
        assert (variantData instanceof ApplicationVariantData);
        this.createAnchorTasks(tasks, variantScope);
        this.createCheckManifestTask(tasks, variantScope);
        this.handleMicroApp(tasks, variantScope);
        this.createDependencyStreams(tasks, variantScope);
        this.createApplicationIdWriterTask(tasks, variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeApkManifestsTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createGenerateResValuesTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createRenderscriptTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeResourcesTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeAssetsTask(tasks, variantScope, null));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createBuildConfigTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_PROCESS_RES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createApkProcessResTask(tasks, variantScope);
            this.createProcessJavaResTask(tasks, variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_AIDL_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createAidlTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_SHADER_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createShaderTask(tasks, variantScope));
        if (!this.isComponentModelPlugin()) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_NDK_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createNdkTasks(tasks, variantScope));
        } else if (variantData.compileTask != null) {
            variantData.compileTask.dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        } else {
            variantScope.getCompileTask().dependsOn(tasks, (Object)this.getNdkBuildable(variantData));
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_EXTERNAL_NATIVE_BUILD_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createExternalNativeBuildJsonGenerators(variantScope);
            this.createExternalNativeBuildTasks(tasks, variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_JNILIBS_FOLDERS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeJniLibFoldersTasks(tasks, variantScope));
        this.createDataBindingTasksIfNecessary(tasks, variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_COMPILE_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.addCompileTask(tasks, variantScope));
        ApplicationTaskManager.createStripNativeLibraryTask(tasks, variantScope);
        if (variantScope.getSplitScope().getSplitHandlingPolicy().equals((Object)SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY)) {
            if (this.extension.getBuildToolsRevision().getMajor() < 21) {
                throw new RuntimeException("Pure splits can only be used with buildtools 21 and later");
            }
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_SPLIT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createSplitTasks(tasks, variantScope));
        }
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_PACKAGING_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            AndroidTask<BuildInfoWriterTask> buildInfoWriterTask = this.createBuildInfoWriterTask(tasks, variantScope);
            this.createInstantRunPackagingTasks(tasks, buildInfoWriterTask, variantScope);
            this.createPackagingTask(tasks, variantScope, buildInfoWriterTask);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_LINT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createLintTasks(tasks, variantScope));
    }

    protected AndroidTask<BuildInfoWriterTask> createBuildInfoWriterTask(TaskFactory tasks, VariantScope scope) {
        return this.getAndroidTasks().create(tasks, new BuildInfoWriterTask.ConfigAction(scope, this.getLogger()));
    }

    private void addCompileTask(TaskFactory tasks, VariantScope variantScope) {
        this.createDataBindingMergeArtifactsTaskIfNecessary(tasks, variantScope);
        AndroidTask<? extends JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
        VariantScope.Java8LangSupport java8LangSupport = variantScope.getJava8LangSupportType();
        if (java8LangSupport == VariantScope.Java8LangSupport.INVALID) {
            return;
        }
        String pluginName = null;
        if (java8LangSupport == VariantScope.Java8LangSupport.DEXGUARD) {
            pluginName = "dexguard";
        } else if (java8LangSupport == VariantScope.Java8LangSupport.RETROLAMBDA) {
            pluginName = "me.tatarka.retrolambda";
        }
        if (pluginName != null) {
            String warningMsg = String.format("One of the plugins you are using supports Java 8 language features. To try the support built into the Android plugin, remove the following from your build.gradle:\n    apply plugin: '%s'\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n", pluginName);
            this.androidBuilder.getErrorReporter().handleSyncWarning(null, 0, warningMsg);
        }
        this.addJavacClassesStream(variantScope);
        ApplicationTaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
        this.getAndroidTasks().create(tasks, new AndroidJarTask.JarClassesConfigAction(variantScope));
        this.createPostCompilationTasks(tasks, variantScope);
    }

    protected void createInstantRunPackagingTasks(TaskFactory tasks, AndroidTask<BuildInfoWriterTask> buildInfoGeneratorTask, VariantScope variantScope) {
        if (!variantScope.getInstantRunBuildContext().isInInstantRunMode() || variantScope.getInstantRunTaskManager() == null) {
            return;
        }
        variantScope.getInstantRunTaskManager().configureBuildInfoWriterTask(buildInfoGeneratorTask, new AndroidTask[0]);
        InstantRunPatchingPolicy patchingPolicy = variantScope.getInstantRunBuildContext().getPatchingPolicy();
        if (patchingPolicy == InstantRunPatchingPolicy.MULTI_APK) {
            DefaultGradlePackagingScope packagingScope = new DefaultGradlePackagingScope(variantScope);
            InstantRunDependenciesApkBuilder dependenciesApkBuilder = new InstantRunDependenciesApkBuilder(this.getLogger(), this.project, variantScope.getInstantRunBuildContext(), variantScope.getGlobalScope().getAndroidBuilder(), packagingScope, packagingScope.getSigningConfig(), AaptGeneration.fromProjectOptions(this.projectOptions), packagingScope.getAaptOptions(), new File(packagingScope.getInstantRunSplitApkOutputFolder(), "dep"), packagingScope.getInstantRunSupportDir());
            Optional<AndroidTask<TransformTask>> dependenciesApkBuilderTask = variantScope.getTransformManager().addTransform(tasks, variantScope, dependenciesApkBuilder);
            dependenciesApkBuilderTask.ifPresent(task -> task.dependsOn(tasks, this.getValidateSigningTask(tasks, packagingScope)));
            InstantRunSliceSplitApkBuilder slicesApkBuilder = new InstantRunSliceSplitApkBuilder(this.getLogger(), this.project, variantScope.getInstantRunBuildContext(), variantScope.getGlobalScope().getAndroidBuilder(), packagingScope, packagingScope.getSigningConfig(), AaptGeneration.fromProjectOptions(this.projectOptions), packagingScope.getAaptOptions(), new File(packagingScope.getInstantRunSplitApkOutputFolder(), "slices"), packagingScope.getInstantRunSupportDir());
            Optional<AndroidTask<TransformTask>> transformTaskAndroidTask = variantScope.getTransformManager().addTransform(tasks, variantScope, slicesApkBuilder);
            if (transformTaskAndroidTask.isPresent()) {
                AndroidTask<TransformTask> splitApk = transformTaskAndroidTask.get();
                variantScope.getAssembleTask().dependsOn(tasks, splitApk);
                buildInfoGeneratorTask.configure(tasks, (Action<BuildInfoWriterTask>)((Action)task -> task.mustRunAfter(new Object[]{splitApk.getName()})));
            }
            variantScope.getAssembleTask().dependsOn(tasks, buildInfoGeneratorTask);
        }
    }

    @Override
    protected void postJavacCreation(TaskFactory tasks, final VariantScope scope) {
        final FileCollection javacOutput = scope.getOutput(TaskOutputHolder.TaskOutputType.JAVAC);
        final FileCollection preJavacGeneratedBC = scope.getVariantData().getAllPreJavacGeneratedBytecode();
        final FileCollection postJavacGeneratedBC = scope.getVariantData().getAllPostJavacGeneratedBytecode();
        final File dest = new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"intermediates", "classes-jar", scope.getVariantConfiguration().getDirName()}));
        AndroidTask<Jar> task = this.androidTasks.create(tasks, new TaskConfigAction<Jar>(){

            @Override
            public String getName() {
                return scope.getTaskName("bundleAppClasses");
            }

            @Override
            public Class<Jar> getType() {
                return Jar.class;
            }

            @Override
            public void execute(Jar task) {
                task.from(new Object[]{javacOutput});
                task.from(new Object[]{preJavacGeneratedBC});
                task.from(new Object[]{postJavacGeneratedBC});
                task.setDestinationDir(dest);
                task.setArchiveName("classes.jar");
            }
        });
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.APP_CLASSES, new File(dest, "classes.jar"), task.getName());
        ConfigurableFileCollection fileCollection = scope.createAnchorOutput(TaskOutputHolder.AnchorOutputType.CLASSES_FOR_UNIT_TESTS);
        fileCollection.from(new Object[]{javacOutput});
        fileCollection.from(new Object[]{preJavacGeneratedBC});
        fileCollection.from(new Object[]{postJavacGeneratedBC});
    }

    @Override
    protected AndroidTask<? extends DefaultTask> createVariantPreBuildTask(TaskFactory tasks, VariantScope scope) {
        switch (scope.getVariantConfiguration().getType()) {
            case DEFAULT: {
                return this.getAndroidTasks().create(tasks, new AppPreBuildTask.ConfigAction(scope));
            }
            case ANDROID_TEST: {
                return this.getAndroidTasks().create(tasks, new TestPreBuildTask.ConfigAction(scope));
            }
        }
        return super.createVariantPreBuildTask(tasks, scope);
    }

    protected Set<QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private void handleMicroApp(TaskFactory tasks, VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        Boolean unbundledWearApp = variantConfiguration.getMergedFlavor().getWearAppUnbundled();
        if (!Boolean.TRUE.equals(unbundledWearApp) && ((CoreBuildType)variantConfiguration.getBuildType()).isEmbedMicroApp()) {
            Configuration wearApp = variantData.getVariantDependency().getWearAppConfiguration();
            if (!wearApp.getAllDependencies().isEmpty()) {
                this.createGenerateMicroApkDataTask(tasks, scope, wearApp.getIncoming().artifactView(config -> config.attributes(container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.APK.getType()))).getFiles());
            }
        } else if (Boolean.TRUE.equals(unbundledWearApp)) {
            this.createGenerateMicroApkDataTask(tasks, scope, null);
        }
    }

    private void createApplicationIdWriterTask(TaskFactory tasks, VariantScope variantScope) {
        File applicationIdOutputDirectory = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"applicationId", variantScope.getVariantConfiguration().getDirName()});
        AndroidTask<ApplicationIdWriterTask> writeTask = this.androidTasks.create(tasks, new ApplicationIdWriterTask.ConfigAction(variantScope, applicationIdOutputDirectory));
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.METADATA_APP_ID_DECLARATION, ApplicationId.getOutputFile(applicationIdOutputDirectory), writeTask.getName());
    }
}

