/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.LintGradleProject;
import com.android.build.gradle.tasks.Lint;
import com.android.builder.Version;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.LintOptions;
import com.android.builder.model.Variant;
import com.android.sdklib.BuildToolInfo;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Warning;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.w3c.dom.Document;

public class LintGradleClient
extends LintCliClient {
    private final AndroidProject modelProject;
    private final Variant variant;
    private final Project gradleProject;
    private final File manifestReportFile;
    private List<File> customRules = Lists.newArrayList();
    private File sdkHome;
    private final BuildToolInfo buildToolInfo;

    public LintGradleClient(IssueRegistry registry, LintCliFlags flags, Project gradleProject, AndroidProject modelProject, File sdkHome, Variant variant, BuildToolInfo buildToolInfo, File reportFile) {
        super(flags, "gradle");
        this.gradleProject = gradleProject;
        this.modelProject = modelProject;
        this.sdkHome = sdkHome;
        this.registry = registry;
        this.buildToolInfo = buildToolInfo;
        this.variant = variant;
        this.manifestReportFile = reportFile;
    }

    public String getClientRevision() {
        return Version.ANDROID_GRADLE_PLUGIN_VERSION;
    }

    public void setCustomRules(List<File> customRules) {
        this.customRules = customRules;
    }

    public Configuration getConfiguration(com.android.tools.lint.detector.api.Project project, LintDriver driver) {
        AndroidProject gradleProjectModel = project.getGradleProjectModel();
        if (gradleProjectModel != null) {
            Map overrides;
            LintOptions lintOptions = gradleProjectModel.getLintOptions();
            File lintXml = lintOptions.getLintConfig();
            if (lintXml == null) {
                lintXml = new File(project.getDir(), "lint.xml");
            }
            if ((overrides = lintOptions.getSeverityOverrides()) != null && !overrides.isEmpty()) {
                return new LintCliClient.CliConfiguration(lintXml, this.getConfiguration(), project, this.flags.isFatalOnly()){

                    public Severity getSeverity(Issue issue) {
                        Integer optionSeverity = (Integer)overrides.get(issue.getId());
                        if (optionSeverity != null) {
                            Severity severity = Severity.fromLintOptionSeverity((int)optionSeverity);
                            if (LintGradleClient.this.flags.isFatalOnly() && severity != Severity.FATAL) {
                                return Severity.IGNORE;
                            }
                            return severity;
                        }
                        return super.getSeverity(issue);
                    }
                };
            }
        }
        return super.getConfiguration(project, driver);
    }

    public List<File> findRuleJars(com.android.tools.lint.detector.api.Project project) {
        return this.customRules;
    }

    protected com.android.tools.lint.detector.api.Project createProject(File dir, File referenceDir) {
        throw new IllegalStateException();
    }

    public File getSdkHome() {
        if (this.sdkHome != null) {
            return this.sdkHome;
        }
        return super.getSdkHome();
    }

    public File getCacheDir(boolean create) {
        File dir = new File(this.gradleProject.getRootProject().getBuildDir(), "intermediates" + File.separator + "lint-cache");
        if (dir.exists() || create && dir.mkdirs()) {
            return dir;
        }
        return super.getCacheDir(create);
    }

    protected LintRequest createLintRequest(List<File> files) {
        LintRequest lintRequest = new LintRequest((LintClient)this, files);
        if (Lint.MODEL_LIBRARIES) {
            LintGradleProject.ProjectSearch search = new LintGradleProject.ProjectSearch();
            com.android.tools.lint.detector.api.Project project = search.getProject(this, this.gradleProject, this.variant.getName());
            lintRequest.setProjects(Collections.singletonList(project));
            this.setCustomRules(search.customViewRuleJars);
        } else {
            Pair<LintGradleProject, List<File>> result = LintGradleProject.create(this, this.modelProject, this.variant, this.gradleProject);
            lintRequest.setProjects(Collections.singletonList(result.getFirst()));
            this.setCustomRules((List)result.getSecond());
        }
        return lintRequest;
    }

    public Pair<List<Warning>, LintBaseline> run(IssueRegistry registry) throws IOException {
        int exitCode = this.run(registry, Collections.emptyList());
        if (exitCode == 6) {
            throw new GradleException("Aborting build since new baseline file was created");
        }
        return Pair.of((Object)this.warnings, (Object)this.driver.getBaseline());
    }

    public static List<Warning> merge(Map<Variant, List<Warning>> warningMap, AndroidProject project) {
        if (warningMap.size() == 1) {
            return warningMap.values().iterator().next();
        }
        int maxCount = 0;
        for (List<Warning> warnings : warningMap.values()) {
            int size = warnings.size();
            maxCount = Math.max(size, maxCount);
        }
        if (maxCount == 0) {
            return Collections.emptyList();
        }
        int totalVariantCount = project.getVariants().size();
        ArrayList merged = Lists.newArrayListWithExpectedSize((int)(2 * maxCount));
        HashMap map = Maps.newHashMapWithExpectedSize((int)(2 * maxCount));
        for (Map.Entry<Variant, List<Warning>> entry : warningMap.entrySet()) {
            Variant variant = entry.getKey();
            List<Warning> warnings = entry.getValue();
            for (Warning warning : warnings) {
                String fileName;
                Warning canonical;
                Map fileMap;
                Map lineMap;
                Map messageMap = (Map)map.get(warning.issue);
                if (messageMap == null) {
                    messageMap = Maps.newHashMap();
                    map.put(warning.issue, messageMap);
                }
                if ((lineMap = (Map)messageMap.get(warning.message)) == null) {
                    lineMap = Maps.newHashMap();
                    messageMap.put(warning.message, lineMap);
                }
                if ((fileMap = (Map)lineMap.get(warning.line)) == null) {
                    fileMap = Maps.newHashMap();
                    lineMap.put(warning.line, fileMap);
                }
                if ((canonical = (Warning)fileMap.get(fileName = warning.file != null ? warning.file.getName() : "<unknown>")) == null) {
                    canonical = warning;
                    fileMap.put(fileName, canonical);
                    canonical.variants = Sets.newHashSet();
                    canonical.gradleProject = project;
                    merged.add(canonical);
                }
                canonical.variants.add(variant);
            }
        }
        for (Warning warning : merged) {
            if (warning.variants == null || warning.variants.size() != totalVariantCount) continue;
            warning.variants = null;
        }
        Collections.sort(merged);
        return merged;
    }

    protected void addProgressPrinter() {
    }

    public BuildToolInfo getBuildTools(com.android.tools.lint.detector.api.Project project) {
        return this.buildToolInfo;
    }

    public void report(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format, LintFix fix) {
        if (issue == IssueRegistry.LINT_ERROR && message.startsWith("No `.class` files were found in project")) {
            return;
        }
        super.report(context, issue, severity, location, message, format, fix);
    }

    public Document getMergedManifest(com.android.tools.lint.detector.api.Project project) {
        Variant variant = project.getCurrentVariant();
        if (variant != null) {
            Collection outputs = variant.getMainArtifact().getOutputs();
            for (AndroidArtifactOutput output : outputs) {
                File manifest = output.getGeneratedManifest();
                if (!manifest.exists()) continue;
                try {
                    String xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
                    Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                    if (document == null) continue;
                    this.resolveMergeManifestSources(document, this.manifestReportFile);
                    return document;
                }
                catch (IOException ioe) {
                    this.log(ioe, "Could not read %1$s", new Object[]{manifest});
                }
            }
        }
        return super.getMergedManifest(project);
    }
}

