/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.LintGradleClient;
import com.android.build.gradle.internal.ToolingRegistryProvider;
import com.android.build.gradle.tasks.Lint;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.w3c.dom.Document;

public class LintGradleProject
extends com.android.tools.lint.detector.api.Project {
    protected AndroidVersion minSdkVersion;
    protected AndroidVersion targetSdkVersion;

    private LintGradleProject(LintGradleClient client, File dir, File referenceDir, File manifest) {
        super((LintClient)client, dir, referenceDir);
        this.gradleProject = true;
        this.mergeManifests = true;
        this.directLibraries = Lists.newArrayList();
        if (manifest != null) {
            this.readManifest(manifest);
        }
    }

    private static void addJarsFromJavaLibrariesTransitively(Collection<? extends JavaLibrary> libraries, List<File> list, boolean skipProvided) {
        for (JavaLibrary javaLibrary : libraries) {
            if (javaLibrary.isSkipped() || skipProvided && javaLibrary.isProvided()) continue;
            File jar = javaLibrary.getJarFile();
            if (!list.contains(jar) && jar.exists()) {
                list.add(jar);
            }
            LintGradleProject.addJarsFromJavaLibrariesTransitively(javaLibrary.getDependencies(), list, skipProvided);
        }
    }

    private static void addJarsFromAndroidLibrariesTransitively(Collection<? extends AndroidLibrary> libraries, List<File> list, boolean skipProvided) {
        for (AndroidLibrary androidLibrary : libraries) {
            if (androidLibrary.getProject() != null || androidLibrary.isSkipped() || skipProvided && androidLibrary.isProvided()) continue;
            File jar = androidLibrary.getJarFile();
            if (!list.contains(jar) && jar.exists()) {
                list.add(jar);
            }
            LintGradleProject.addJarsFromJavaLibrariesTransitively(androidLibrary.getJavaDependencies(), list, skipProvided);
            LintGradleProject.addJarsFromAndroidLibrariesTransitively(androidLibrary.getLibraryDependencies(), list, skipProvided);
        }
    }

    public static Pair<LintGradleProject, List<File>> create(LintGradleClient client, AndroidProject project, Variant variant, Project gradleProject) {
        assert (!Lint.MODEL_LIBRARIES);
        File dir = gradleProject.getProjectDir();
        AppGradleProject lintProject = new AppGradleProject(client, dir, dir, project, variant);
        ArrayList customRules = Lists.newArrayList();
        File appLintJar = new File(gradleProject.getBuildDir(), "lint" + File.separatorChar + "lint.jar");
        if (appLintJar.exists()) {
            customRules.add(appLintJar);
        }
        HashSet libraries = Sets.newHashSet();
        Dependencies dependencies = variant.getMainArtifact().getDependencies();
        for (AndroidLibrary library : dependencies.getLibraries()) {
            lintProject.addDirectLibrary(LintGradleProject.createLibrary(client, library, libraries, customRules));
        }
        return Pair.of((Object)((Object)lintProject), (Object)customRules);
    }

    protected void initialize() {
    }

    protected void readManifest(File manifest) {
        if (manifest.exists()) {
            try {
                String xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document != null) {
                    this.readManifest(document);
                }
            }
            catch (IOException e) {
                this.client.log((Throwable)e, "Could not read manifest %1$s", new Object[]{manifest});
            }
        }
    }

    public boolean isGradleProject() {
        return true;
    }

    protected static boolean dependsOn(Dependencies dependencies, String artifact) {
        for (AndroidLibrary library : dependencies.getLibraries()) {
            if (!LintGradleProject.dependsOn(library, artifact)) continue;
            return true;
        }
        return false;
    }

    protected static boolean dependsOn(AndroidLibrary library, String artifact) {
        if ("com.android.support:support-v4".equals(artifact) ? library.getJarFile().getName().startsWith("support-v4-") : "com.android.support:appcompat-v7".equals(artifact) && library.getName() != null && library.getName().startsWith(artifact)) {
            return true;
        }
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            if (!LintGradleProject.dependsOn(dependency, artifact)) continue;
            return true;
        }
        return false;
    }

    void addDirectLibrary(com.android.tools.lint.detector.api.Project project) {
        this.directLibraries.add(project);
    }

    private static LibraryProject createLibrary(LintGradleClient client, AndroidLibrary library, Set<AndroidLibrary> seen, List<File> customRules) {
        seen.add(library);
        File dir = library.getFolder();
        LibraryProject project = new LibraryProject(client, dir, dir, library);
        File ruleJar = library.getLintJar();
        if (ruleJar.exists()) {
            customRules.add(ruleJar);
        }
        for (AndroidLibrary dependent : library.getLibraryDependencies()) {
            if (seen.contains(dependent)) continue;
            project.addDirectLibrary(LintGradleProject.createLibrary(client, dependent, seen, customRules));
        }
        return project;
    }

    private static class JavaLibraryProject
    extends LintGradleProject {
        private final JavaLibrary mLibrary;

        private JavaLibraryProject(LintGradleClient client, File dir, File referenceDir, JavaLibrary library) {
            super(client, dir, referenceDir, null);
            this.mLibrary = library;
            this.reportIssues = false;
        }

        public boolean isLibrary() {
            return true;
        }

        public List<File> getManifestFiles() {
            return Collections.emptyList();
        }

        public List<File> getProguardFiles() {
            return Collections.emptyList();
        }

        public List<File> getResourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getAssetFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getGeneratedSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getTestSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            if (!includeProvided && this.mLibrary.isProvided()) {
                return Collections.emptyList();
            }
            if (this.javaLibraries == null) {
                this.javaLibraries = Lists.newArrayList();
                this.javaLibraries.add(this.mLibrary.getJarFile());
            }
            return this.javaLibraries;
        }
    }

    static class ProjectSearch {
        public final Map<AndroidProject, com.android.tools.lint.detector.api.Project> appProjects = Maps.newHashMap();
        public final Map<AndroidLibrary, com.android.tools.lint.detector.api.Project> libraryProjects = Maps.newHashMap();
        public final Map<MavenCoordinates, com.android.tools.lint.detector.api.Project> libraryProjectsByCoordinate = Maps.newHashMap();
        public final Map<String, com.android.tools.lint.detector.api.Project> namedProjects = Maps.newHashMap();
        public final Map<JavaLibrary, com.android.tools.lint.detector.api.Project> javaLibraryProjects = Maps.newHashMap();
        public final Map<MavenCoordinates, com.android.tools.lint.detector.api.Project> javaLibraryProjectsByCoordinate = Maps.newHashMap();
        public final Map<Project, AndroidProject> gradleProjects = Maps.newHashMap();
        public final List<File> customViewRuleJars = Lists.newArrayList();
        private final Set<Object> mSeen = Sets.newHashSet();

        public ProjectSearch() {
            assert (Lint.MODEL_LIBRARIES);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static AndroidProject createAndroidProject(Project gradleProject) {
            PluginContainer pluginContainer = gradleProject.getPlugins();
            for (Plugin p : pluginContainer) {
                ExtraPropertiesExtension ext;
                if (!(p instanceof ToolingRegistryProvider)) continue;
                ToolingModelBuilderRegistry registry = ((ToolingRegistryProvider)p).getModelBuilderRegistry();
                String modelName = AndroidProject.class.getName();
                ToolingModelBuilder builder = registry.getBuilder(modelName);
                assert (builder.canBuild(modelName)) : modelName;
                ExtraPropertiesExtension extraPropertiesExtension = ext = gradleProject.getExtensions().getExtraProperties();
                synchronized (extraPropertiesExtension) {
                    AndroidProject androidProject;
                    ext.set("android.injected.build.model.only.versioned", (Object)Integer.toString(3));
                    try {
                        androidProject = (AndroidProject)builder.buildAll(modelName, gradleProject);
                    }
                    catch (Throwable throwable) {
                        ext.set("android.injected.build.model.only.versioned", null);
                        throw throwable;
                    }
                    ext.set("android.injected.build.model.only.versioned", null);
                    return androidProject;
                }
            }
            return null;
        }

        private AndroidProject getAndroidProject(LintGradleClient client, Project gradleProject) {
            AndroidProject androidProject = this.gradleProjects.get(gradleProject);
            if (androidProject == null && (androidProject = ProjectSearch.createAndroidProject(gradleProject)) != null) {
                this.gradleProjects.put(gradleProject, androidProject);
            }
            return androidProject;
        }

        public com.android.tools.lint.detector.api.Project getProject(LintGradleClient lintClient, Project gradleProject, String variantName) {
            JavaPluginConvention convention;
            AndroidProject androidProject = this.getAndroidProject(lintClient, gradleProject);
            if (androidProject != null) {
                Collection variants = androidProject.getVariants();
                for (Variant variant : variants) {
                    if (!variantName.equals(variant.getName())) continue;
                    return this.getProject(lintClient, androidProject, variant, gradleProject);
                }
                if (!variants.isEmpty()) {
                    Variant defaultVariant = (Variant)variants.iterator().next();
                    return this.getProject(lintClient, androidProject, defaultVariant, gradleProject);
                }
                assert (false) : variantName;
            }
            if ((convention = (JavaPluginConvention)gradleProject.getConvention().findPlugin(JavaPluginConvention.class)) == null) {
                return null;
            }
            SourceSetContainer sourceSets = convention.getSourceSets();
            if (sourceSets != null) {
                final ArrayList sources = Lists.newArrayList();
                final ArrayList classes = Lists.newArrayList();
                final ArrayList libs = Lists.newArrayList();
                final ArrayList tests = Lists.newArrayList();
                for (SourceSet sourceSet : sourceSets) {
                    SourceSetOutput output;
                    SourceDirectorySet javaSrc;
                    if (sourceSet.getName().equals("test")) {
                        javaSrc = sourceSet.getJava();
                        if (javaSrc == null) continue;
                        tests.addAll(javaSrc.getSrcDirs());
                        continue;
                    }
                    javaSrc = sourceSet.getJava();
                    if (javaSrc != null) {
                        sources.addAll(javaSrc.getSrcDirs());
                    }
                    if ((output = sourceSet.getOutput()) != null) {
                        classes.add(output.getClassesDir());
                    }
                    libs.addAll(sourceSet.getCompileClasspath().getFiles());
                }
                File projectDir = gradleProject.getProjectDir();
                final ArrayList dependencies = Lists.newArrayList();
                com.android.tools.lint.detector.api.Project project = new com.android.tools.lint.detector.api.Project((LintClient)lintClient, projectDir, projectDir){

                    protected void initialize() {
                        this.gradleProject = true;
                        this.mergeManifests = true;
                        this.directLibraries = dependencies;
                        this.javaSourceFolders = sources;
                        this.javaClassFolders = classes;
                        this.javaLibraries = libs;
                        this.testSourceFolders = tests;
                    }

                    public boolean isGradleProject() {
                        return true;
                    }

                    public boolean isAndroidProject() {
                        return false;
                    }

                    public IAndroidTarget getBuildTarget() {
                        return null;
                    }
                };
                ConfigurationContainer configurations = gradleProject.getConfigurations();
                Configuration compile = configurations.getByName("compile");
                if (compile != null) {
                    for (Dependency dependency : compile.getDependencies()) {
                        Set files;
                        if (dependency instanceof ProjectDependency) {
                            com.android.tools.lint.detector.api.Project lintProject;
                            Project p = ((ProjectDependency)dependency).getDependencyProject();
                            if (p == null || (lintProject = this.getProject(lintClient, p.getName(), p, variantName)) == null) continue;
                            dependencies.add(lintProject);
                            continue;
                        }
                        if (dependency instanceof ExternalDependency) {
                            MavenCoordinatesImpl coordinates;
                            com.android.tools.lint.detector.api.Project javaLib;
                            String group = dependency.getGroup();
                            String name = dependency.getName();
                            String version = dependency.getVersion();
                            if (name == null || group == null || version == null || (javaLib = this.javaLibraryProjectsByCoordinate.get(coordinates = new MavenCoordinatesImpl(group, name, version))) == null) continue;
                            dependencies.add(javaLib);
                            continue;
                        }
                        if (!(dependency instanceof FileCollectionDependency) || (files = ((FileCollectionDependency)dependency).resolve()) == null) continue;
                        libs.addAll(files);
                    }
                }
                return project;
            }
            return null;
        }

        public com.android.tools.lint.detector.api.Project getProject(LintGradleClient client, AndroidProject project, Variant variant, Project gradleProject) {
            com.android.tools.lint.detector.api.Project cached = this.appProjects.get(project);
            if (cached != null) {
                return cached;
            }
            this.mSeen.add(project);
            File dir = gradleProject.getProjectDir();
            AppGradleProject lintProject = new AppGradleProject(client, dir, dir, project, variant);
            this.appProjects.put(project, lintProject);
            File appLintJar = new File(gradleProject.getBuildDir(), "lint" + File.separatorChar + "lint.jar");
            if (appLintJar.exists()) {
                this.customViewRuleJars.add(appLintJar);
            }
            Dependencies dependencies = variant.getMainArtifact().getDependencies();
            for (AndroidLibrary library : dependencies.getLibraries()) {
                if (library.getProject() != null) {
                    File ruleJar = library.getLintJar();
                    if (!ruleJar.exists()) continue;
                    this.customViewRuleJars.add(ruleJar);
                    continue;
                }
                lintProject.addDirectLibrary(this.getLibrary(client, library, gradleProject, variant));
            }
            List processedProjects = null;
            ConfigurationContainer configurations = gradleProject.getConfigurations();
            Configuration compile = configurations.getByName("compile");
            if (compile != null) {
                for (Dependency dependency : compile.getDependencies()) {
                    com.android.tools.lint.detector.api.Project depProject;
                    Project p;
                    if (!(dependency instanceof ProjectDependency) || (p = ((ProjectDependency)dependency).getDependencyProject()) == null || (depProject = this.getProject(client, p, variant.getName())) == null) continue;
                    if (processedProjects == null) {
                        processedProjects = Lists.newArrayList();
                    }
                    processedProjects.add(p.getPath());
                    lintProject.addDirectLibrary(depProject);
                }
            }
            for (JavaLibrary library : dependencies.getJavaLibraries()) {
                String projectName = library.getProject();
                if (projectName != null) {
                    if (processedProjects != null && processedProjects.contains(projectName)) continue;
                    com.android.tools.lint.detector.api.Project libLintProject = this.getProject(client, projectName, gradleProject, variant.getName());
                    if (libLintProject != null) {
                        lintProject.addDirectLibrary(libLintProject);
                        continue;
                    }
                }
                lintProject.addDirectLibrary(this.getLibrary(client, library));
            }
            return lintProject;
        }

        private com.android.tools.lint.detector.api.Project getProject(LintGradleClient client, String name, Project gradleProject, String variantName) {
            com.android.tools.lint.detector.api.Project project;
            com.android.tools.lint.detector.api.Project cached = this.namedProjects.get(name);
            if (cached != null) {
                return cached;
            }
            Project namedProject = gradleProject.findProject(name);
            if (namedProject != null && (project = this.getProject(client, namedProject, variantName)) != null) {
                this.namedProjects.put(name, project);
                return project;
            }
            return null;
        }

        private com.android.tools.lint.detector.api.Project getLibrary(LintGradleClient client, AndroidLibrary library, Project gradleProject, Variant variant) {
            com.android.tools.lint.detector.api.Project project;
            com.android.tools.lint.detector.api.Project cached = this.libraryProjects.get(library);
            if (cached != null) {
                return cached;
            }
            MavenCoordinates coordinates = library.getResolvedCoordinates();
            cached = this.libraryProjectsByCoordinate.get(coordinates);
            if (cached != null) {
                return cached;
            }
            if (library.getProject() != null && (project = this.getProject(client, library.getProject(), gradleProject, variant.getName())) != null) {
                this.libraryProjects.put(library, project);
                return project;
            }
            this.mSeen.add(library);
            File dir = library.getFolder();
            LibraryProject project2 = new LibraryProject(client, dir, dir, library);
            this.libraryProjects.put(library, project2);
            this.libraryProjectsByCoordinate.put(coordinates, project2);
            File ruleJar = library.getLintJar();
            if (ruleJar.exists()) {
                this.customViewRuleJars.add(ruleJar);
            }
            for (AndroidLibrary dependent : library.getLibraryDependencies()) {
                project2.addDirectLibrary(this.getLibrary(client, dependent, gradleProject, variant));
            }
            return project2;
        }

        private com.android.tools.lint.detector.api.Project getLibrary(LintGradleClient client, JavaLibrary library) {
            com.android.tools.lint.detector.api.Project cached = this.javaLibraryProjects.get(library);
            if (cached != null) {
                return cached;
            }
            MavenCoordinates coordinates = library.getResolvedCoordinates();
            cached = this.javaLibraryProjectsByCoordinate.get(coordinates);
            if (cached != null) {
                return cached;
            }
            this.mSeen.add(library);
            File dir = library.getJarFile();
            JavaLibraryProject project = new JavaLibraryProject(client, dir, dir, library);
            this.javaLibraryProjects.put(library, project);
            this.javaLibraryProjectsByCoordinate.put(coordinates, project);
            for (JavaLibrary dependent : library.getDependencies()) {
                project.addDirectLibrary(this.getLibrary(client, dependent));
            }
            return project;
        }
    }

    private static class LibraryProject
    extends LintGradleProject {
        private final AndroidLibrary mLibrary;

        private LibraryProject(LintGradleClient client, File dir, File referenceDir, AndroidLibrary library) {
            super(client, dir, referenceDir, library.getManifest());
            this.mLibrary = library;
            this.reportIssues = false;
        }

        public boolean isLibrary() {
            return true;
        }

        public AndroidLibrary getGradleLibraryModel() {
            return this.mLibrary;
        }

        public Variant getCurrentVariant() {
            return null;
        }

        public List<File> getManifestFiles() {
            if (this.manifestFiles == null) {
                File manifest = this.mLibrary.getManifest();
                this.manifestFiles = manifest.exists() ? Collections.singletonList(manifest) : Collections.emptyList();
            }
            return this.manifestFiles;
        }

        public List<File> getProguardFiles() {
            if (this.proguardFiles == null) {
                File proguardRules = this.mLibrary.getProguardRules();
                this.proguardFiles = proguardRules.exists() ? Collections.singletonList(proguardRules) : Collections.emptyList();
            }
            return this.proguardFiles;
        }

        public List<File> getResourceFolders() {
            if (this.resourceFolders == null) {
                File folder = this.mLibrary.getResFolder();
                this.resourceFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.resourceFolders;
        }

        public List<File> getAssetFolders() {
            if (this.assetFolders == null) {
                File folder = this.mLibrary.getAssetsFolder();
                this.assetFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.assetFolders;
        }

        public List<File> getJavaSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getGeneratedSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getTestSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            if (!includeProvided && this.mLibrary.isProvided()) {
                return Collections.emptyList();
            }
            if (this.javaLibraries == null) {
                this.javaLibraries = Stream.concat(Stream.of(this.mLibrary.getJarFile()), this.mLibrary.getLocalJars().stream()).filter(File::exists).collect(Collectors.toList());
            }
            return this.javaLibraries;
        }

        public Boolean dependsOn(String artifact) {
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.supportLib == null) {
                    this.supportLib = LibraryProject.dependsOn(this.mLibrary, artifact);
                }
                return this.supportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.appCompat == null) {
                    this.appCompat = LibraryProject.dependsOn(this.mLibrary, artifact);
                }
                return this.appCompat;
            }
            return super.dependsOn(artifact);
        }
    }

    private static class AppGradleProject
    extends LintGradleProject {
        private final AndroidProject mProject;
        private final Variant mVariant;
        private List<SourceProvider> mProviders;
        private List<SourceProvider> mTestProviders;

        private AppGradleProject(LintGradleClient client, File dir, File referenceDir, AndroidProject project, Variant variant) {
            super(client, dir, referenceDir, ((AndroidArtifactOutput)variant.getMainArtifact().getOutputs().iterator().next()).getGeneratedManifest());
            this.mProject = project;
            this.mVariant = variant;
        }

        public boolean isLibrary() {
            return this.mProject.isLibrary();
        }

        public AndroidProject getGradleProjectModel() {
            return this.mProject;
        }

        public Variant getCurrentVariant() {
            return this.mVariant;
        }

        private List<SourceProvider> getSourceProviders() {
            if (this.mProviders == null) {
                this.mProviders = LintUtils.getSourceProviders((AndroidProject)this.mProject, (Variant)this.mVariant);
            }
            return this.mProviders;
        }

        private List<SourceProvider> getTestSourceProviders() {
            if (this.mTestProviders == null) {
                this.mTestProviders = LintUtils.getTestSourceProviders((AndroidProject)this.mProject, (Variant)this.mVariant);
            }
            return this.mTestProviders;
        }

        public List<File> getManifestFiles() {
            if (this.manifestFiles == null) {
                this.manifestFiles = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    File manifestFile = provider.getManifestFile();
                    if (!manifestFile.exists()) continue;
                    this.manifestFiles.add(manifestFile);
                }
            }
            return this.manifestFiles;
        }

        public List<File> getProguardFiles() {
            if (this.proguardFiles == null) {
                ProductFlavor flavor = this.mProject.getDefaultConfig().getProductFlavor();
                this.proguardFiles = flavor.getProguardFiles().stream().filter(File::exists).collect(Collectors.toList());
                try {
                    this.proguardFiles.addAll(flavor.getConsumerProguardFiles().stream().filter(File::exists).collect(Collectors.toList()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.proguardFiles;
        }

        public List<File> getResourceFolders() {
            if (this.resourceFolders == null) {
                this.resourceFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    Collection resDirs = provider.getResDirectories();
                    this.resourceFolders.addAll(resDirs.stream().filter(File::exists).collect(Collectors.toList()));
                }
                this.resourceFolders.addAll(this.mVariant.getMainArtifact().getGeneratedResourceFolders().stream().filter(File::exists).collect(Collectors.toList()));
            }
            return this.resourceFolders;
        }

        public List<File> getAssetFolders() {
            if (this.assetFolders == null) {
                this.assetFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    Collection dirs = provider.getAssetsDirectories();
                    this.assetFolders.addAll(dirs.stream().filter(File::exists).collect(Collectors.toList()));
                }
            }
            return this.assetFolders;
        }

        public List<File> getJavaSourceFolders() {
            if (this.javaSourceFolders == null) {
                this.javaSourceFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    Collection srcDirs = provider.getJavaDirectories();
                    this.javaSourceFolders.addAll(srcDirs.stream().filter(File::exists).collect(Collectors.toList()));
                }
            }
            return this.javaSourceFolders;
        }

        public List<File> getGeneratedSourceFolders() {
            if (this.generatedSourceFolders == null) {
                AndroidArtifact artifact = this.mVariant.getMainArtifact();
                this.generatedSourceFolders = artifact.getGeneratedSourceFolders().stream().filter(File::exists).collect(Collectors.toList());
            }
            return this.generatedSourceFolders;
        }

        public List<File> getTestSourceFolders() {
            if (this.testSourceFolders == null) {
                this.testSourceFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getTestSourceProviders()) {
                    this.testSourceFolders.addAll(provider.getJavaDirectories().stream().filter(File::exists).collect(Collectors.toList()));
                }
            }
            return this.testSourceFolders;
        }

        public List<File> getJavaClassFolders() {
            if (this.javaClassFolders == null) {
                this.javaClassFolders = new ArrayList(1);
                File outputClassFolder = this.mVariant.getMainArtifact().getClassesFolder();
                if (outputClassFolder.exists()) {
                    this.javaClassFolders.add(outputClassFolder);
                } else if (this.isLibrary()) {
                    for (Variant variant : this.mProject.getVariants()) {
                        if (variant == this.mVariant || !(outputClassFolder = variant.getMainArtifact().getClassesFolder()).exists()) continue;
                        this.javaClassFolders.add(outputClassFolder);
                        break;
                    }
                }
            }
            return this.javaClassFolders;
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            if (includeProvided) {
                if (this.javaLibraries == null) {
                    Dependencies dependencies = this.mVariant.getMainArtifact().getDependencies();
                    Collection libs = dependencies.getJavaLibraries();
                    this.javaLibraries = Lists.newArrayListWithExpectedSize((int)libs.size());
                    for (JavaLibrary lib : libs) {
                        File jar = lib.getJarFile();
                        if (!jar.exists()) continue;
                        this.javaLibraries.add(jar);
                    }
                }
                return this.javaLibraries;
            }
            if (this.nonProvidedJavaLibraries == null) {
                Dependencies dependencies = this.mVariant.getMainArtifact().getDependencies();
                Collection libs = dependencies.getJavaLibraries();
                this.nonProvidedJavaLibraries = Lists.newArrayListWithExpectedSize((int)libs.size());
                for (JavaLibrary lib : libs) {
                    File jar = lib.getJarFile();
                    if (!jar.exists() || lib.isProvided()) continue;
                    this.nonProvidedJavaLibraries.add(jar);
                }
            }
            return this.nonProvidedJavaLibraries;
        }

        public List<File> getTestLibraries() {
            if (this.testLibraries == null) {
                this.testLibraries = Lists.newArrayListWithExpectedSize((int)6);
                for (AndroidArtifact artifact : this.mVariant.getExtraAndroidArtifacts()) {
                    if (!"_android_test_".equals(artifact.getName()) && !"_unit_test_".equals(artifact.getName())) continue;
                    Dependencies dependencies = artifact.getDependencies();
                    LintGradleProject.addJarsFromJavaLibrariesTransitively(dependencies.getJavaLibraries(), this.testLibraries, false);
                    LintGradleProject.addJarsFromAndroidLibrariesTransitively(dependencies.getLibraries(), this.testLibraries, false);
                }
            }
            return this.testLibraries;
        }

        public String getPackage() {
            String packageName;
            if (this.pkg == null && (packageName = this.mProject.getDefaultConfig().getProductFlavor().getApplicationId()) != null) {
                return packageName;
            }
            return this.pkg;
        }

        public AndroidVersion getMinSdkVersion() {
            if (this.minSdkVersion == null) {
                ApiVersion minSdk = this.mVariant.getMergedFlavor().getMinSdkVersion();
                if (minSdk == null) {
                    ProductFlavor flavor = this.mProject.getDefaultConfig().getProductFlavor();
                    minSdk = flavor.getMinSdkVersion();
                }
                this.minSdkVersion = minSdk != null ? LintUtils.convertVersion((ApiVersion)minSdk, (IAndroidTarget[])this.client.getTargets()) : super.getMinSdkVersion();
            }
            return this.minSdkVersion;
        }

        public AndroidVersion getTargetSdkVersion() {
            if (this.targetSdkVersion == null) {
                ApiVersion targetSdk = this.mVariant.getMergedFlavor().getTargetSdkVersion();
                if (targetSdk == null) {
                    ProductFlavor flavor = this.mProject.getDefaultConfig().getProductFlavor();
                    targetSdk = flavor.getTargetSdkVersion();
                }
                this.targetSdkVersion = targetSdk != null ? LintUtils.convertVersion((ApiVersion)targetSdk, (IAndroidTarget[])this.client.getTargets()) : super.getTargetSdkVersion();
            }
            return this.targetSdkVersion;
        }

        public int getBuildSdk() {
            String compileTarget = this.mProject.getCompileTarget();
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)compileTarget);
            if (version != null) {
                return version.getFeatureLevel();
            }
            return super.getBuildSdk();
        }

        public String getBuildTargetHash() {
            return this.mProject.getCompileTarget();
        }

        public Boolean dependsOn(String artifact) {
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.supportLib == null) {
                    Dependencies dependencies = this.mVariant.getMainArtifact().getDependencies();
                    this.supportLib = AppGradleProject.dependsOn(dependencies, artifact);
                }
                return this.supportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.appCompat == null) {
                    Dependencies dependencies = this.mVariant.getMainArtifact().getDependencies();
                    this.appCompat = AppGradleProject.dependsOn(dependencies, artifact);
                }
                return this.appCompat;
            }
            return super.dependsOn(artifact);
        }
    }
}

