/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.ArtifactTransform;

public class AarTransform
extends ArtifactTransform {
    private final AndroidArtifacts.ArtifactType targetType;

    @Inject
    public AarTransform(AndroidArtifacts.ArtifactType targetType) {
        this.targetType = targetType;
    }

    public static AndroidArtifacts.ArtifactType[] getTransformTargets() {
        return new AndroidArtifacts.ArtifactType[]{AndroidArtifacts.ArtifactType.CLASSES, AndroidArtifacts.ArtifactType.JAVA_RES, AndroidArtifacts.ArtifactType.JAR, AndroidArtifacts.ArtifactType.MANIFEST, AndroidArtifacts.ArtifactType.ANDROID_RES, AndroidArtifacts.ArtifactType.ASSETS, AndroidArtifacts.ArtifactType.JNI, AndroidArtifacts.ArtifactType.AIDL, AndroidArtifacts.ArtifactType.RENDERSCRIPT, AndroidArtifacts.ArtifactType.PROGUARD_RULES, AndroidArtifacts.ArtifactType.LINT, AndroidArtifacts.ArtifactType.ANNOTATIONS, AndroidArtifacts.ArtifactType.PUBLIC_RES, AndroidArtifacts.ArtifactType.SYMBOL_LIST, AndroidArtifacts.ArtifactType.DATA_BINDING};
    }

    public List<File> transform(File input) {
        File file;
        switch (this.targetType) {
            case CLASSES: 
            case JAVA_RES: 
            case JAR: {
                return AarTransform.getJars(input);
            }
            case LINT: {
                file = FileUtils.join((File)input, (String[])new String[]{"jars", "lint.jar"});
                break;
            }
            case MANIFEST: {
                file = new File(input, "AndroidManifest.xml");
                break;
            }
            case ANDROID_RES: {
                file = new File(input, "res");
                break;
            }
            case ASSETS: {
                file = new File(input, "assets");
                break;
            }
            case JNI: {
                file = new File(input, "jni");
                break;
            }
            case AIDL: {
                file = new File(input, "aidl");
                break;
            }
            case RENDERSCRIPT: {
                file = new File(input, "rs");
                break;
            }
            case PROGUARD_RULES: {
                file = new File(input, "proguard.txt");
                break;
            }
            case ANNOTATIONS: {
                file = new File(input, "annotations.zip");
                break;
            }
            case PUBLIC_RES: {
                file = new File(input, "public.txt");
                break;
            }
            case SYMBOL_LIST: {
                file = new File(input, "R.txt");
                break;
            }
            case DATA_BINDING: {
                file = new File(input, "data-binding");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type in AarTransform: " + (Object)((Object)this.targetType));
            }
        }
        if (file.exists()) {
            return Collections.singletonList(file);
        }
        return Collections.emptyList();
    }

    private static List<File> getJars(File explodedAar) {
        File localJarFolder;
        File[] jars;
        ArrayList files = Lists.newArrayList();
        File jarFolder = new File(explodedAar, "jars");
        File file = FileUtils.join((File)jarFolder, (String[])new String[]{"classes.jar"});
        if (file.isFile()) {
            files.add(file);
        }
        if ((jars = (localJarFolder = new File(jarFolder, "libs")).listFiles((dir, name) -> name.endsWith(".jar"))) != null) {
            files.addAll(Arrays.asList(jars));
        }
        return files;
    }
}

