/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.MutableDependencyDataMap;
import com.android.builder.core.SyncIssueHandler;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.level2.AndroidDependency;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.dependency.level2.JavaDependency;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.SyncIssue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.ModuleVersionIdentifier;

public class DependencyChecker
implements SyncIssueHandler {
    private final String projectName;
    private final String variantName;
    private SyncIssueHandler syncIssueHandler;
    private VariantType variantType;
    private final VariantType testedVariantType;
    private final List<SyncIssue> syncIssues = Lists.newArrayList();
    private final Map<ModuleVersionIdentifier, Integer> legacyApiLevels = Maps.newHashMap();

    public DependencyChecker(String projectName, String variantName, SyncIssueHandler syncIssueHandler, VariantType variantType, VariantType testedVariantType) {
        this.projectName = projectName;
        this.variantName = variantName;
        this.syncIssueHandler = syncIssueHandler;
        this.variantType = variantType;
        this.testedVariantType = testedVariantType;
    }

    public Map<ModuleVersionIdentifier, Integer> getLegacyApiLevels() {
        return this.legacyApiLevels;
    }

    public List<SyncIssue> getSyncIssues() {
        return this.syncIssues;
    }

    public String getVariantName() {
        return this.variantName;
    }

    public boolean checkForExclusion(ModuleVersionIdentifier id) {
        String group = id.getGroup();
        String name = id.getName();
        String version = id.getVersion();
        if ("com.google.android".equals(group) && "android".equals(name)) {
            int moduleLevel = DependencyChecker.getApiLevelFromMavenArtifact(version);
            this.legacyApiLevels.put(id, moduleLevel);
            this.handleIssue(id.toString(), 14, 1, String.format("Ignoring Android API artifact %s for %s", id, this.variantName));
            return true;
        }
        if (this.variantType == VariantType.UNIT_TEST) {
            return false;
        }
        if ("org.apache.httpcomponents".equals(group) && "httpclient".equals(name) || "xpp3".equals(group) && name.equals("xpp3") || "commons-logging".equals(group) && "commons-logging".equals(name) || "xerces".equals(group) && "xmlParserAPIs".equals(name) || "org.json".equals(group) && "json".equals(name) || "org.khronos".equals(group) && "opengl-api".equals(name)) {
            this.handleIssue(id.toString(), 15, 1, String.format("WARNING: Dependency %s is ignored for %s as it may be conflicting with the internal version provided by Android.\n         In case of problem, please repackage it with jarjar to change the class packages", id, this.variantName));
            return true;
        }
        return false;
    }

    private static int getApiLevelFromMavenArtifact(String version) {
        switch (version) {
            case "1.5_r3": 
            case "1.5_r4": {
                return 3;
            }
            case "1.6_r2": {
                return 4;
            }
            case "2.1_r1": 
            case "2.1.2": {
                return 7;
            }
            case "2.2.1": {
                return 8;
            }
            case "2.3.1": {
                return 9;
            }
            case "2.3.3": {
                return 10;
            }
            case "4.0.1.2": {
                return 14;
            }
            case "4.1.1.4": {
                return 15;
            }
        }
        return -1;
    }

    private void compareAndroidDependencies(Map<String, AndroidDependency> compileMap, Map<String, AndroidDependency> packageMap, MutableDependencyDataMap mutableDependencyDataMap, Map<String, String> testedMap) {
        for (String coordinateKey : compileMap.keySet()) {
            AndroidDependency compileLib = compileMap.get(coordinateKey);
            AndroidDependency packageMatch = packageMap.get(coordinateKey);
            if (packageMatch != null) {
                this.skipTestDependency(mutableDependencyDataMap, (Dependency)packageMatch, testedMap);
                packageMap.remove(coordinateKey);
                if (compileLib.getCoordinates().getVersion().equals(packageMatch.getCoordinates().getVersion())) continue;
                this.handleIssue(coordinateKey, 9, 2, String.format("Conflict with dependency '%s' in project '%s'. Resolved versions for compilation (%s) and packaging (%s) differ. This can generate runtime errors due to mismatched resources.", coordinateKey, this.projectName, compileLib.getCoordinates().getVersion(), packageMatch.getCoordinates().getVersion()));
                continue;
            }
            MavenCoordinates resolvedCoordinates = compileLib.getCoordinates();
            if (this.variantType == VariantType.LIBRARY || this.testedVariantType == VariantType.LIBRARY && this.variantType.isForTesting()) continue;
            this.handleIssue(resolvedCoordinates.toString(), 7, 2, String.format("Project %s: Provided dependencies can only be jars. %s is an Android Library.", this.projectName, resolvedCoordinates.toString()));
        }
        for (AndroidDependency packageOnlyDep : packageMap.values()) {
            MavenCoordinates packagedCoords = packageOnlyDep.getCoordinates();
            this.handleIssue(packagedCoords.toString(), 6, 2, String.format("Project %s: apk-only dependencies can only be jars. %s is an Android Library.", this.projectName, packagedCoords));
        }
    }

    private void compareJavaDependencies(Map<String, JavaDependency> compileMap, Map<String, JavaDependency> packageMap, MutableDependencyDataMap mutableDependencyDataMap, Map<String, String> testedMap) {
        for (String coordinateKey : compileMap.keySet()) {
            JavaDependency packageMatch = packageMap.get(coordinateKey);
            if (packageMatch == null) continue;
            this.skipTestDependency(mutableDependencyDataMap, (Dependency)packageMatch, testedMap);
            packageMap.remove(coordinateKey);
        }
    }

    private void skipTestDependency(MutableDependencyDataMap mutableDependencyDataMap, Dependency dependency, Map<String, String> testedMap) {
        if (testedMap.isEmpty()) {
            return;
        }
        MavenCoordinates coordinates = dependency.getCoordinates();
        String testedVersion = testedMap.get(coordinates.getVersionlessId());
        if (testedVersion == null) {
            return;
        }
        mutableDependencyDataMap.skip(dependency);
        if (!testedVersion.equals(coordinates.getVersion())) {
            String artifactInfo = coordinates.getGroupId() + ":" + coordinates.getArtifactId();
            this.handleIssue(artifactInfo, 9, 2, String.format("Conflict with dependency '%s' in project '%s'. Resolved versions for app (%s) and test app (%s) differ. See http://g.co/androidstudio/app-test-app-conflict for details.", artifactInfo, this.projectName, testedVersion, coordinates.getVersion()));
        }
    }

    private static void collectSkippableLibraryMap(Collection<Dependency> dependencies, Map<String, AndroidDependency> androidMap, Map<String, JavaDependency> javaMap) {
        for (Dependency dependency : dependencies) {
            MavenCoordinates coordinates;
            if (dependency instanceof AndroidDependency) {
                coordinates = dependency.getCoordinates();
                androidMap.put(coordinates.getVersionlessId(), (AndroidDependency)dependency);
                continue;
            }
            if (!(dependency instanceof JavaDependency)) continue;
            coordinates = dependency.getCoordinates();
            javaMap.put(coordinates.getVersionlessId(), (JavaDependency)dependency);
        }
    }

    public SyncIssue handleIssue(String data, int type, int severity, String msg) {
        SyncIssue issue = this.syncIssueHandler.handleIssue(data, type, severity, msg);
        this.syncIssues.add(issue);
        return issue;
    }

    public boolean hasSyncIssue(int type) {
        return this.syncIssues.stream().anyMatch(syncIssue -> syncIssue.getType() == type);
    }
}

