/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreShaderOptions;
import com.android.build.gradle.internal.dsl.ExternalNativeBuildOptions;
import com.android.build.gradle.internal.dsl.JackOptions;
import com.android.build.gradle.internal.dsl.JavaCompileOptions;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.dsl.PostprocessingOptions;
import com.android.build.gradle.internal.dsl.ShaderOptions;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.builder.core.DefaultBuildType;
import com.android.builder.core.ErrorReporter;
import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.internal.reflect.Instantiator;

public class BuildType
extends DefaultBuildType
implements CoreBuildType,
Serializable {
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<Boolean> dslChecksEnabled = ThreadLocal.withInitial(new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            return true;
        }
    });
    private final Project project;
    private final NdkOptions ndkConfig;
    private final ExternalNativeBuildOptions externalNativeBuildOptions;
    private final JackOptions jackOptions;
    private final JavaCompileOptions javaCompileOptions;
    private final ShaderOptions shaderOptions;
    private final ErrorReporter errorReporter;
    private final PostprocessingOptions postprocessingOptions;
    private PostprocessingConfiguration postprocessingConfiguration;
    private String postprocessingDslMethodUsed;
    private boolean shrinkResources = false;
    private Boolean useProguard;

    public BuildType(String name, Project project, Instantiator instantiator, ErrorReporter errorReporter) {
        super(name);
        this.project = project;
        this.errorReporter = errorReporter;
        this.jackOptions = (JackOptions)instantiator.newInstance(JackOptions.class, new Object[]{errorReporter});
        this.javaCompileOptions = (JavaCompileOptions)instantiator.newInstance(JavaCompileOptions.class, new Object[]{instantiator});
        this.shaderOptions = (ShaderOptions)instantiator.newInstance(ShaderOptions.class, new Object[0]);
        this.ndkConfig = (NdkOptions)instantiator.newInstance(NdkOptions.class, new Object[0]);
        this.externalNativeBuildOptions = (ExternalNativeBuildOptions)instantiator.newInstance(ExternalNativeBuildOptions.class, new Object[]{instantiator});
        this.postprocessingOptions = (PostprocessingOptions)instantiator.newInstance(PostprocessingOptions.class, new Object[0]);
    }

    BuildType(String name, Project project, ErrorReporter errorReporter) {
        super(name);
        this.project = project;
        this.errorReporter = errorReporter;
        this.jackOptions = new JackOptions(errorReporter);
        this.javaCompileOptions = new JavaCompileOptions();
        this.shaderOptions = new ShaderOptions();
        this.ndkConfig = new NdkOptions();
        this.externalNativeBuildOptions = new ExternalNativeBuildOptions();
        this.postprocessingOptions = new PostprocessingOptions();
    }

    @Override
    public CoreNdkOptions getNdkConfig() {
        return this.ndkConfig;
    }

    @Override
    public ExternalNativeBuildOptions getExternalNativeBuildOptions() {
        return this.externalNativeBuildOptions;
    }

    @Override
    public JackOptions getJackOptions() {
        return this.jackOptions;
    }

    @Override
    public com.android.build.gradle.api.JavaCompileOptions getJavaCompileOptions() {
        return this.javaCompileOptions;
    }

    @Override
    public CoreShaderOptions getShaders() {
        return this.shaderOptions;
    }

    public void init(SigningConfig debugSigningConfig) {
        if ("debug".equals(this.getName())) {
            this.setDebuggable(true);
            this.setEmbedMicroApp(false);
            assert (debugSigningConfig != null);
            this.setSigningConfig(debugSigningConfig);
        }
    }

    public SigningConfig getSigningConfig() {
        return (SigningConfig)super.getSigningConfig();
    }

    protected void _initWith(BaseConfig that) {
        super._initWith(that);
        BuildType thatBuildType = (BuildType)that;
        this.ndkConfig._initWith(thatBuildType.getNdkConfig());
        this.jackOptions._initWith(thatBuildType.getJackOptions());
        this.javaCompileOptions.getAnnotationProcessorOptions()._initWith(thatBuildType.getJavaCompileOptions().getAnnotationProcessorOptions());
        this.shrinkResources = thatBuildType.isShrinkResources();
        this.shaderOptions._initWith(thatBuildType.getShaders());
        this.externalNativeBuildOptions._initWith(thatBuildType.getExternalNativeBuildOptions());
        this.useProguard = thatBuildType.isUseProguard();
        this.postprocessingOptions.initWith(((BuildType)that).getPostprocessing());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getJackOptions().hashCode();
        result = 31 * result + this.javaCompileOptions.hashCode();
        result = 31 * result + (this.shrinkResources ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildType other = (BuildType)o;
        if (!this.ndkConfig.equals(other.ndkConfig)) {
            return false;
        }
        if (!this.jackOptions.equals(other.jackOptions)) {
            return false;
        }
        if (!this.javaCompileOptions.equals(other.javaCompileOptions)) {
            return false;
        }
        return this.shrinkResources == other.isShrinkResources();
    }

    public void buildConfigField(String type, String name, String value) {
        ClassField alreadyPresent = (ClassField)this.getBuildConfigFields().get(name);
        if (alreadyPresent != null) {
            String message = String.format("BuildType(%s): buildConfigField '%s' value is being replaced: %s -> %s", this.getName(), name, alreadyPresent.getValue(), value);
            this.errorReporter.handleSyncWarning(null, 0, message);
        }
        this.addBuildConfigField((ClassField)new ClassFieldImpl(type, name, value));
    }

    public void resValue(String type, String name, String value) {
        ClassField alreadyPresent = (ClassField)this.getResValues().get(name);
        if (alreadyPresent != null) {
            String message = String.format("BuildType(%s): resValue '%s' value is being replaced: %s -> %s", this.getName(), name, alreadyPresent.getValue(), value);
            this.errorReporter.handleSyncWarning(null, 0, message);
        }
        this.addResValue((ClassField)new ClassFieldImpl(type, name, value));
    }

    public BuildType proguardFile(Object proguardFile) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "proguardFile");
        this.getProguardFiles().add(this.project.file(proguardFile));
        return this;
    }

    public BuildType proguardFiles(Object ... files) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "proguardFiles");
        for (Object file : files) {
            this.proguardFile(file);
        }
        return this;
    }

    public BuildType setProguardFiles(Iterable<?> proguardFileIterable) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "setProguardFiles");
        this.getProguardFiles().clear();
        this.proguardFiles(Iterables.toArray(proguardFileIterable, Object.class));
        return this;
    }

    public BuildType testProguardFile(Object proguardFile) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "testProguardFile");
        this.getTestProguardFiles().add(this.project.file(proguardFile));
        return this;
    }

    public BuildType testProguardFiles(Object ... proguardFiles) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "testProguardFiles");
        for (Object proguardFile : proguardFiles) {
            this.testProguardFile(proguardFile);
        }
        return this;
    }

    public BuildType setTestProguardFiles(Iterable<?> files) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "setTestProguardFiles");
        this.getTestProguardFiles().clear();
        this.testProguardFiles(Iterables.toArray(files, Object.class));
        return this;
    }

    public BuildType consumerProguardFile(Object proguardFile) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "consumerProguardFile");
        this.getConsumerProguardFiles().add(this.project.file(proguardFile));
        return this;
    }

    public BuildType consumerProguardFiles(Object ... proguardFiles) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "consumerProguardFiles");
        for (Object proguardFile : proguardFiles) {
            this.consumerProguardFile(proguardFile);
        }
        return this;
    }

    public BuildType setConsumerProguardFiles(Iterable<?> proguardFileIterable) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "setConsumerProguardFiles");
        this.getConsumerProguardFiles().clear();
        this.consumerProguardFiles(Iterables.toArray(proguardFileIterable, Object.class));
        return this;
    }

    public void ndk(Action<NdkOptions> action) {
        action.execute((Object)this.ndkConfig);
    }

    public ExternalNativeBuildOptions externalNativeBuild(Action<ExternalNativeBuildOptions> action) {
        action.execute((Object)this.externalNativeBuildOptions);
        return this.externalNativeBuildOptions;
    }

    public void jackOptions(Action<JackOptions> action) {
        action.execute((Object)this.jackOptions);
    }

    @Deprecated
    public Boolean getUseJack() {
        this.errorReporter.handleSyncWarning(null, 0, "The Jack toolchain is deprecated and will not run. To enable support for Java 8 language features built into the plugin, remove 'jackOptions { ... }' from your build.gradle file, and add\n\nandroid.compileOptions.sourceCompatibility 1.8\nandroid.compileOptions.targetCompatibility 1.8\n\nFuture versions of the plugin will not support usage of 'jackOptions' in build.gradle.\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n");
        return null;
    }

    @Deprecated
    public void setUseJack(Boolean useJack) {
        this.errorReporter.handleSyncWarning(null, 0, "The Jack toolchain is deprecated and will not run. To enable support for Java 8 language features built into the plugin, remove 'jackOptions { ... }' from your build.gradle file, and add\n\nandroid.compileOptions.sourceCompatibility 1.8\nandroid.compileOptions.targetCompatibility 1.8\n\nFuture versions of the plugin will not support usage of 'jackOptions' in build.gradle.\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n");
    }

    public void shaders(Action<ShaderOptions> action) {
        action.execute((Object)this.shaderOptions);
    }

    public com.android.builder.model.BuildType setMinifyEnabled(boolean enabled) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "setMinifyEnabled");
        return super.setMinifyEnabled(enabled);
    }

    public boolean isMinifyEnabled() {
        if (this.postprocessingConfiguration != PostprocessingConfiguration.POSTPROCESSING_BLOCK) {
            return super.isMinifyEnabled();
        }
        return this.postprocessingOptions.isRemoveUnusedCode() || this.postprocessingOptions.isObfuscate() || this.postprocessingOptions.isOptimizeCode();
    }

    @Override
    public boolean isShrinkResources() {
        if (this.postprocessingConfiguration != PostprocessingConfiguration.POSTPROCESSING_BLOCK) {
            return this.shrinkResources;
        }
        return this.postprocessingOptions.isRemoveUnusedResources();
    }

    public void setShrinkResources(boolean shrinkResources) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "setShrinkResources");
        this.shrinkResources = shrinkResources;
    }

    @Override
    public Boolean isUseProguard() {
        if (this.postprocessingConfiguration != PostprocessingConfiguration.POSTPROCESSING_BLOCK) {
            return this.useProguard;
        }
        return this.postprocessingOptions.getCodeShrinkerEnum() == CodeShrinker.PROGUARD;
    }

    public void setUseProguard(boolean useProguard) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.OLD_DSL, "setUseProguard");
        this.useProguard = useProguard;
    }

    public void jarJarRuleFile(Object file) {
        this.getJarJarRuleFiles().add(this.project.file(file));
    }

    public void jarJarRuleFiles(Object ... files) {
        this.getJarJarRuleFiles().clear();
        for (Object file : files) {
            this.getJarJarRuleFiles().add(this.project.file(file));
        }
    }

    public PostprocessingOptions getPostprocessing() {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.POSTPROCESSING_BLOCK, "getPostprocessing");
        return this.postprocessingOptions;
    }

    public void postprocessing(Action<PostprocessingOptions> action) {
        this.checkPostprocessingConfiguration(PostprocessingConfiguration.POSTPROCESSING_BLOCK, "postprocessing");
        action.execute((Object)this.postprocessingOptions);
    }

    public PostprocessingConfiguration getPostprocessingConfiguration() {
        return this.postprocessingConfiguration != null ? this.postprocessingConfiguration : PostprocessingConfiguration.POSTPROCESSING_BLOCK;
    }

    private void checkPostprocessingConfiguration(PostprocessingConfiguration used, String methodName) {
        if (!dslChecksEnabled.get().booleanValue()) {
            return;
        }
        if (this.postprocessingConfiguration == null) {
            this.postprocessingConfiguration = used;
            this.postprocessingDslMethodUsed = methodName;
        } else if (this.postprocessingConfiguration != used) {
            String message;
            assert (this.postprocessingDslMethodUsed != null);
            switch (used) {
                case POSTPROCESSING_BLOCK: {
                    message = String.format("The `postprocessing` block cannot be used with together with the `%s` method.", this.postprocessingDslMethodUsed);
                    break;
                }
                case OLD_DSL: {
                    message = String.format("The `%s` method cannot be used with together with the `postprocessing` block.", methodName);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown value " + (Object)((Object)used)));
                }
            }
            this.errorReporter.handleSyncError(methodName, 0, message);
        }
    }

    public DefaultBuildType initWith(com.android.builder.model.BuildType that) {
        dslChecksEnabled.set(false);
        try {
            DefaultBuildType defaultBuildType = super.initWith(that);
            return defaultBuildType;
        }
        finally {
            dslChecksEnabled.set(true);
        }
    }

    public static enum PostprocessingConfiguration {
        POSTPROCESSING_BLOCK,
        OLD_DSL;

    }
}

