/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.dependency.ArtifactCollectionWithExtraArtifact;
import com.android.build.gradle.internal.dependency.ConfigurationDependencyGraphs;
import com.android.build.gradle.internal.dependency.VariantAttr;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.ide.level2.AndroidLibraryImpl;
import com.android.build.gradle.internal.ide.level2.FullDependencyGraphsImpl;
import com.android.build.gradle.internal.ide.level2.GraphItemImpl;
import com.android.build.gradle.internal.ide.level2.JavaLibraryImpl;
import com.android.build.gradle.internal.ide.level2.ModuleLibraryImpl;
import com.android.build.gradle.internal.ide.level2.SimpleDependencyGraphsImpl;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.dependency.level2.JavaDependency;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.builder.model.level2.Library;
import com.android.ide.common.caching.CreatingCache;
import com.android.utils.ImmutableCollectors;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.component.Artifact;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;

public class ArtifactDependencyGraph {
    private static final String LOCAL_AAR_GROUPID = "__local_aars__";
    private static final CreatingCache<HashableResolvedArtifactResult, MavenCoordinates> sMavenCoordinatesCache = new CreatingCache(ArtifactDependencyGraph::computeMavenCoordinates);
    private static final CreatingCache<HashableResolvedArtifactResult, Library> sLibraryCache = new CreatingCache(ArtifactDependencyGraph::instantiateLibrary);
    private static final Map<String, Library> sGlobalLibrary = Maps.newHashMap();
    private final List<Throwable> failures = Lists.newArrayList();

    public static void clearCaches() {
        sMavenCoordinatesCache.clear();
        sLibraryCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Library instantiateLibrary(HashableResolvedArtifactResult artifact) {
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        String address = ArtifactDependencyGraph.computeAddress(artifact);
        Library library = id instanceof ProjectComponentIdentifier ? new ModuleLibraryImpl(address, artifact.getFile(), ((ProjectComponentIdentifier)id).getProjectPath(), ArtifactDependencyGraph.getVariant(artifact)) : (artifact.isJava ? new JavaLibraryImpl(address, artifact.getFile()) : new AndroidLibraryImpl(address, null, artifact.getFile(), (Collection<File>)ImmutableList.of()));
        Map<String, Library> map = sGlobalLibrary;
        synchronized (map) {
            sGlobalLibrary.put(library.getArtifactAddress(), library);
        }
        return library;
    }

    public static Map<String, Library> getGlobalLibMap() {
        return ImmutableMap.copyOf(sGlobalLibrary);
    }

    public static String getVariant(ResolvedArtifactResult artifact) {
        VariantAttr variantAttr = (VariantAttr)artifact.getVariant().getAttributes().getAttribute(VariantAttr.ATTRIBUTE);
        return variantAttr == null ? null : variantAttr.getName();
    }

    private static String computeAddress(HashableResolvedArtifactResult artifact) {
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        if (id instanceof ProjectComponentIdentifier) {
            String variant = ArtifactDependencyGraph.getVariant(artifact);
            if (variant == null) {
                return ((ProjectComponentIdentifier)id).getProjectPath().intern();
            }
            return (((ProjectComponentIdentifier)id).getProjectPath() + "::" + variant).intern();
        }
        if (id instanceof ModuleComponentIdentifier || id instanceof OpaqueComponentArtifactIdentifier) {
            MavenCoordinates coordinates = (MavenCoordinates)sMavenCoordinatesCache.get((Object)artifact);
            Preconditions.checkNotNull((Object)coordinates);
            return coordinates.toString().intern();
        }
        throw new RuntimeException("Don't know how to handle ComponentIdentifier '" + id.getDisplayName() + "'of type " + id.getClass());
    }

    private static MavenCoordinates computeMavenCoordinates(ResolvedArtifactResult artifact) {
        String extension;
        HashableResolvedArtifactResult hashableResult = (HashableResolvedArtifactResult)artifact;
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        File artifactFile = artifact.getFile();
        String fileName = artifactFile.getName();
        String string = extension = hashableResult.isJava ? "jar" : "aar";
        if (id instanceof ModuleComponentIdentifier) {
            String pattern;
            Pattern p;
            Matcher m;
            ModuleComponentIdentifier moduleComponentId = (ModuleComponentIdentifier)id;
            String module = moduleComponentId.getModule();
            String version = moduleComponentId.getVersion();
            String classifier = null;
            if (!artifact.getFile().isDirectory() && (m = (p = Pattern.compile(pattern = "^" + module + "-" + version + "-(.+)\\." + extension + "$")).matcher(fileName)).matches()) {
                classifier = m.group(1);
            }
            return new MavenCoordinatesImpl(moduleComponentId.getGroup(), module, version, extension, classifier);
        }
        if (id instanceof ProjectComponentIdentifier) {
            return new MavenCoordinatesImpl("artifacts", ((ProjectComponentIdentifier)id).getProjectPath(), "unspecified");
        }
        if (id instanceof OpaqueComponentArtifactIdentifier) {
            if (hashableResult.isJava) {
                return JavaDependency.getCoordForLocalJar((File)artifactFile);
            }
            assert (artifactFile.isDirectory());
            return ArtifactDependencyGraph.getMavenCoordForLocalFile(artifactFile);
        }
        throw new RuntimeException("Don't know how to compute maven coordinate for artifact '" + artifact.getId().getDisplayName() + "' with component identifier of type '" + id.getClass() + "'.");
    }

    public static MavenCoordinatesImpl getMavenCoordForLocalFile(File artifactFile) {
        return new MavenCoordinatesImpl(LOCAL_AAR_GROUPID, artifactFile.getPath(), "unspecified");
    }

    private Set<HashableResolvedArtifactResult> getAllArtifacts(VariantScope variantScope, AndroidArtifacts.ConsumedConfigType consumedConfigType) {
        ArtifactCollection mainArtifactList = variantScope.getArtifactCollection(consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR);
        ArtifactCollection externalAarList = variantScope.getArtifactCollection(consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.EXPLODED_AAR);
        if (mainArtifactList instanceof ArtifactCollectionWithExtraArtifact) {
            mainArtifactList = ((ArtifactCollectionWithExtraArtifact)mainArtifactList).getParentArtifacts();
        }
        if (externalAarList instanceof ArtifactCollectionWithExtraArtifact) {
            externalAarList = ((ArtifactCollectionWithExtraArtifact)externalAarList).getParentArtifacts();
        }
        this.failures.addAll(externalAarList.getFailures());
        HashMap externalAarMap = Maps.newHashMap();
        for (ResolvedArtifactResult result : externalAarList.getArtifacts()) {
            externalAarMap.put(result.getId().getComponentIdentifier(), new HashableResolvedArtifactResult(result, false));
        }
        Set mainArtifacts = mainArtifactList.getArtifacts();
        LinkedHashSet artifacts = Sets.newLinkedHashSet();
        for (ResolvedArtifactResult result : mainArtifacts) {
            ComponentIdentifier componentIdentifier = result.getId().getComponentIdentifier();
            if (externalAarMap.containsKey(componentIdentifier)) {
                artifacts.add(externalAarMap.get(componentIdentifier));
                continue;
            }
            artifacts.add(new HashableResolvedArtifactResult(result, true));
        }
        this.handleJavadoc(variantScope.getGlobalScope().getProject(), artifacts.stream().map(artifactResult -> artifactResult.getId().getComponentIdentifier()).collect(Collectors.toList()));
        return artifacts;
    }

    public DependencyGraphs createLevel2DependencyGraph(VariantScope variantScope, boolean withFullDependency) {
        ArrayList compileItems = Lists.newArrayList();
        Set<HashableResolvedArtifactResult> artifacts = this.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH);
        for (HashableResolvedArtifactResult hashableResolvedArtifactResult : artifacts) {
            compileItems.add(new GraphItemImpl(ArtifactDependencyGraph.computeAddress(hashableResolvedArtifactResult), (List<GraphItem>)ImmutableList.of()));
            sLibraryCache.get((Object)hashableResolvedArtifactResult);
        }
        if (!withFullDependency) {
            return new SimpleDependencyGraphsImpl(compileItems);
        }
        ArrayList runtimeItems = Lists.newArrayList();
        artifacts = this.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH);
        for (HashableResolvedArtifactResult artifact : artifacts) {
            runtimeItems.add(new GraphItemImpl(ArtifactDependencyGraph.computeAddress(artifact), (List<GraphItem>)ImmutableList.of()));
            sLibraryCache.get((Object)artifact);
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)compileItems);
        arrayList.removeAll(runtimeItems);
        return new FullDependencyGraphsImpl(compileItems, runtimeItems, (List)arrayList.stream().map(GraphItem::getArtifactAddress).collect(ImmutableCollectors.toImmutableList()), (List<String>)ImmutableList.of());
    }

    public DependenciesImpl createDependencies(VariantScope variantScope) {
        ImmutableList.Builder projects = ImmutableList.builder();
        ImmutableList.Builder androidLibraries = ImmutableList.builder();
        ImmutableList.Builder javaLibrary = ImmutableList.builder();
        Set<HashableResolvedArtifactResult> artifacts = this.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH);
        for (HashableResolvedArtifactResult artifact : artifacts) {
            String projectPath;
            ComponentIdentifier id = artifact.getId().getComponentIdentifier();
            boolean isSubproject = id instanceof ProjectComponentIdentifier;
            String string = projectPath = isSubproject ? ((ProjectComponentIdentifier)id).getProjectPath() : null;
            if (artifact.isJava) {
                if (projectPath != null) {
                    projects.add((Object)projectPath);
                    continue;
                }
                javaLibrary.add((Object)new com.android.build.gradle.internal.ide.JavaLibraryImpl(artifact.getFile(), null, (List<JavaLibrary>)ImmutableList.of(), null, (MavenCoordinates)Preconditions.checkNotNull((Object)sMavenCoordinatesCache.get((Object)artifact)), false, false));
                continue;
            }
            androidLibraries.add((Object)new com.android.build.gradle.internal.ide.AndroidLibraryImpl((MavenCoordinates)Preconditions.checkNotNull((Object)sMavenCoordinatesCache.get((Object)artifact)), projectPath, artifact.getFile(), ArtifactDependencyGraph.getVariant(artifact), false, false, (List<AndroidLibrary>)ImmutableList.of(), (Collection<JavaLibrary>)ImmutableList.of(), (Collection<File>)ImmutableList.of()));
        }
        return new DependenciesImpl((List<AndroidLibrary>)androidLibraries.build(), (List<JavaLibrary>)javaLibrary.build(), (List<String>)projects.build());
    }

    public List<String> collectFailures() {
        if (this.failures.isEmpty()) {
            return ImmutableList.of();
        }
        Pattern pattern = Pattern.compile(".*any matches for ([a-zA-Z0-9:\\-.+]+) .*", 32);
        Pattern pattern2 = Pattern.compile(".*Could not find ([a-zA-Z0-9:\\-.]+)\\..*", 32);
        return this.failures.stream().map(throwable -> {
            String message;
            Matcher m;
            if (throwable instanceof ResolveException) {
                throwable = throwable.getCause();
            }
            if ((m = pattern.matcher(message = throwable.getMessage())).matches()) {
                return m.group(1);
            }
            m = pattern2.matcher(message);
            if (m.matches()) {
                return m.group(1);
            }
            return throwable.getMessage();
        }).collect(Collectors.toList());
    }

    public static Dependencies clone(Dependencies dependencies, int modelLevel) {
        if (modelLevel >= 4) {
            return ModelBuilder.EMPTY_DEPENDENCIES_IMPL;
        }
        List<AndroidLibrary> libraries = Collections.emptyList();
        ArrayList javaLibraries = Lists.newArrayList((Iterable)dependencies.getJavaLibraries());
        List<String> projects = Collections.emptyList();
        return new DependenciesImpl(libraries, javaLibraries, projects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyGraphs clone(DependencyGraphs dependencyGraphs, int modelLevel, boolean modelWithFullDependency) {
        if (modelLevel < 4) {
            return ModelBuilder.EMPTY_DEPENDENCY_GRAPH;
        }
        Preconditions.checkState((boolean)(dependencyGraphs instanceof ConfigurationDependencyGraphs));
        ConfigurationDependencyGraphs cdg = (ConfigurationDependencyGraphs)dependencyGraphs;
        List<Library> libs = cdg.getLibraries();
        Map<String, Library> map = sGlobalLibrary;
        synchronized (map) {
            for (Library library : libs) {
                sGlobalLibrary.put(library.getArtifactAddress(), library);
            }
        }
        List<GraphItem> nodes = cdg.getCompileDependencies();
        if (modelWithFullDependency) {
            return new FullDependencyGraphsImpl(nodes, nodes, (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of());
        }
        return new SimpleDependencyGraphsImpl(nodes);
    }

    private void handleJavadoc(Project project, List<ComponentIdentifier> artifacts) {
        DependencyHandler dependencies = project.getDependencies();
        ArtifactResolutionQuery query = dependencies.createArtifactResolutionQuery();
        query.forComponents(artifacts);
        Class[] artifactTypesArray = new Class[]{JavadocArtifact.class, SourcesArtifact.class};
        query.withArtifacts(JvmLibrary.class, artifactTypesArray);
        query.execute().getResolvedComponents();
    }

    private static class HashableResolvedArtifactResult
    implements ResolvedArtifactResult {
        private ResolvedArtifactResult delegate;
        private final boolean isJava;

        public HashableResolvedArtifactResult(ResolvedArtifactResult delegate, boolean isJava) {
            this.delegate = delegate;
            this.isJava = isJava;
        }

        public File getFile() {
            return this.delegate.getFile();
        }

        public ResolvedVariantResult getVariant() {
            return this.delegate.getVariant();
        }

        public ComponentArtifactIdentifier getId() {
            return this.delegate.getId();
        }

        public Class<? extends Artifact> getType() {
            return this.delegate.getType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashableResolvedArtifactResult that = (HashableResolvedArtifactResult)o;
            return Objects.equal((Object)this.getFile(), (Object)that.getFile()) && Objects.equal((Object)this.getId(), (Object)that.getId()) && Objects.equal(this.getType(), that.getType()) && this.isJava == that.isJava;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getFile(), this.getId(), this.getType(), this.isJava});
        }
    }
}

