/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.level2;

import com.android.builder.model.level2.Library;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class AndroidLibraryImpl
implements Library,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String address;
    private final File artifactFile;
    private final File folder;
    private final List<String> localJarPath;

    public AndroidLibraryImpl(String address, File artifactFile, File folder, Collection<File> localJarOverride) {
        this.address = address;
        this.artifactFile = artifactFile;
        this.folder = folder;
        this.localJarPath = Lists.newArrayListWithCapacity((int)localJarOverride.size());
        for (File localJar : localJarOverride) {
            this.localJarPath.add(FileUtils.relativePossiblyNonExistingPath((File)localJar, (File)folder).intern());
        }
    }

    public int getType() {
        return 1;
    }

    public String getArtifactAddress() {
        return this.address;
    }

    public File getArtifact() {
        if (this.artifactFile == null) {
            throw new UnsupportedOperationException("getArtifact() cannot be called when getType() returns ANDROID_LIBRARY");
        }
        return this.artifactFile;
    }

    public File getFolder() {
        return this.folder;
    }

    public String getManifest() {
        return "AndroidManifest.xml";
    }

    public String getJarFile() {
        return "jars" + File.separatorChar + "classes.jar";
    }

    public String getResFolder() {
        return "res";
    }

    public String getAssetsFolder() {
        return "assets";
    }

    public Collection<String> getLocalJars() {
        return this.localJarPath;
    }

    public String getJniFolder() {
        return "jni";
    }

    public String getAidlFolder() {
        return "aidl";
    }

    public String getRenderscriptFolder() {
        return "rs";
    }

    public String getProguardRules() {
        return "proguard.txt";
    }

    public String getLintJar() {
        return "jars" + File.separatorChar + "lint.jar";
    }

    public String getExternalAnnotations() {
        return "jars" + File.separatorChar + "annotations.zip";
    }

    public String getPublicResources() {
        return "public.txt";
    }

    public String getSymbolFile() {
        return "R.txt";
    }

    public String getVariant() {
        throw new UnsupportedOperationException("getVariant() cannot be called when getType() returns ANDROID_LIBRARY");
    }

    public String getProjectPath() {
        throw new UnsupportedOperationException("getProjectPath() cannot be called when getType() returns ANDROID_LIBRARY");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidLibraryImpl that = (AndroidLibraryImpl)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.artifactFile, that.artifactFile) && Objects.equals(this.folder, that.folder) && Objects.equals(this.localJarPath, that.localJarPath);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.artifactFile, this.folder, this.localJarPath);
    }
}

