/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.publishing;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.builder.core.VariantType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VariantPublishingSpec {
    private final VariantPublishingSpec parentSpec;
    private final VariantType variantType;
    private final Set<OutputPublishingSpec> taskSpecs;
    private final Map<VariantType, VariantPublishingSpec> testingSpecs = Maps.newEnumMap(VariantType.class);
    private Map<AndroidArtifacts.ArtifactType, OutputPublishingSpec> artifactMap;
    private Map<TaskOutputHolder.OutputType, OutputPublishingSpec> outputMap;
    private static final Map<VariantType, VariantPublishingSpec> variantMap = Maps.newHashMap();
    private static final ImmutableList<AndroidArtifacts.PublishedConfigType> API_ELEMENTS_ONLY = ImmutableList.of((Object)((Object)AndroidArtifacts.PublishedConfigType.API_ELEMENTS));
    private static final ImmutableList<AndroidArtifacts.PublishedConfigType> RUNTIME_ELEMENTS_ONLY = ImmutableList.of((Object)((Object)AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS));
    private static final ImmutableList<AndroidArtifacts.PublishedConfigType> API_AND_RUNTIME_ELEMENTS = ImmutableList.of((Object)((Object)AndroidArtifacts.PublishedConfigType.API_ELEMENTS), (Object)((Object)AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS));
    private static final ImmutableList<AndroidArtifacts.PublishedConfigType> METADATA_ELEMENTS_ONLY = ImmutableList.of((Object)((Object)AndroidArtifacts.PublishedConfigType.METADATA_ELEMENTS));

    public static VariantPublishingSpec getVariantSpec(VariantType variantType) {
        return variantMap.get(variantType);
    }

    public VariantPublishingSpec getTestingSpec(VariantType variantType) {
        Preconditions.checkState((boolean)variantType.isForTesting());
        VariantPublishingSpec testingSpec = this.testingSpecs.get(variantType);
        if (testingSpec != null) {
            return testingSpec;
        }
        return this;
    }

    public OutputPublishingSpec getSpec(AndroidArtifacts.ArtifactType artifactType) {
        OutputPublishingSpec spec;
        if (this.artifactMap == null) {
            this.artifactMap = Maps.newEnumMap(AndroidArtifacts.ArtifactType.class);
            for (OutputPublishingSpec taskSpec : this.taskSpecs) {
                this.artifactMap.put(taskSpec.artifactType, taskSpec);
            }
        }
        if ((spec = this.artifactMap.get((Object)artifactType)) != null) {
            return spec;
        }
        if (this.parentSpec != null) {
            return this.parentSpec.getSpec(artifactType);
        }
        return null;
    }

    public OutputPublishingSpec getSpec(TaskOutputHolder.OutputType taskOutputType) {
        OutputPublishingSpec spec;
        if (this.outputMap == null) {
            this.outputMap = Maps.newHashMap();
            for (OutputPublishingSpec taskSpec : this.taskSpecs) {
                this.outputMap.put(taskSpec.outputType, taskSpec);
            }
        }
        if ((spec = this.outputMap.get(taskOutputType)) != null) {
            return spec;
        }
        if (this.parentSpec != null) {
            return this.parentSpec.getSpec(taskOutputType);
        }
        return null;
    }

    private static VariantPublishingSpec variantSpec(VariantType variantType, OutputPublishingSpec ... taskSpecs) {
        VariantPublishingSpec spec = new VariantPublishingSpec(variantType, (Set<OutputPublishingSpec>)ImmutableSet.copyOf((Object[])taskSpecs));
        variantMap.put(spec.variantType, spec);
        return spec;
    }

    private VariantPublishingSpec withTestingSpec(VariantType variantType, OutputPublishingSpec ... taskSpecs) {
        Preconditions.checkState((!this.variantType.isForTesting() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)variantType.isForTesting());
        Preconditions.checkState((!this.testingSpecs.containsKey(variantType) ? 1 : 0) != 0);
        VariantPublishingSpec spec = new VariantPublishingSpec(this, variantType, (Set<OutputPublishingSpec>)ImmutableSet.copyOf((Object[])taskSpecs));
        this.testingSpecs.put(variantType, spec);
        return this;
    }

    private static OutputPublishingSpec outputSpec(TaskOutputHolder.OutputType taskOutputType, AndroidArtifacts.ArtifactType artifactType, ImmutableList<AndroidArtifacts.PublishedConfigType> publishedConfigTypes) {
        return new OutputPublishingSpec(taskOutputType, artifactType, publishedConfigTypes);
    }

    private VariantPublishingSpec(VariantType variantType, Set<OutputPublishingSpec> taskSpecs) {
        this(null, variantType, taskSpecs);
    }

    private VariantPublishingSpec(VariantPublishingSpec parentSpec, VariantType variantType, Set<OutputPublishingSpec> taskSpecs) {
        this.parentSpec = parentSpec;
        this.variantType = variantType;
        this.taskSpecs = taskSpecs;
    }

    static Map<VariantType, VariantPublishingSpec> getVariantMap() {
        return variantMap;
    }

    static {
        VariantPublishingSpec.variantSpec(VariantType.DEFAULT, VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.MANIFEST_METADATA, AndroidArtifacts.ArtifactType.MANIFEST_METADATA, API_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.APP_CLASSES, AndroidArtifacts.ArtifactType.JAR, API_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.APK, AndroidArtifacts.ArtifactType.APK, RUNTIME_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.APK_MAPPING, AndroidArtifacts.ArtifactType.APK_MAPPING, API_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.METADATA_APP_ID_DECLARATION, AndroidArtifacts.ArtifactType.METADATA_APP_ID_DECLARATION, METADATA_ELEMENTS_ONLY)).withTestingSpec(VariantType.ANDROID_TEST, VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.APP_CLASSES, AndroidArtifacts.ArtifactType.CLASSES, API_ELEMENTS_ONLY)).withTestingSpec(VariantType.UNIT_TEST, VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.APP_CLASSES, AndroidArtifacts.ArtifactType.CLASSES, API_AND_RUNTIME_ELEMENTS), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.JAVA_RES, AndroidArtifacts.ArtifactType.JAVA_RES, API_AND_RUNTIME_ELEMENTS));
        VariantPublishingSpec.variantSpec(VariantType.LIBRARY, VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.LIBRARY_MANIFEST, AndroidArtifacts.ArtifactType.MANIFEST, API_AND_RUNTIME_ELEMENTS), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.MERGED_ASSETS, AndroidArtifacts.ArtifactType.ASSETS, RUNTIME_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.PACKAGED_RES, AndroidArtifacts.ArtifactType.ANDROID_RES, RUNTIME_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.PUBLIC_RES, AndroidArtifacts.ArtifactType.PUBLIC_RES, RUNTIME_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.SYMBOL_LIST, AndroidArtifacts.ArtifactType.SYMBOL_LIST, RUNTIME_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.AIDL_PARCELABLE, AndroidArtifacts.ArtifactType.AIDL, API_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.RENDERSCRIPT_HEADERS, AndroidArtifacts.ArtifactType.RENDERSCRIPT, API_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.DATA_BINDING, AndroidArtifacts.ArtifactType.DATA_BINDING, API_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.LIBRARY_CLASSES, AndroidArtifacts.ArtifactType.CLASSES, API_AND_RUNTIME_ELEMENTS), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.LIBRARY_CLASSES_AS_JAR, AndroidArtifacts.ArtifactType.JAR, API_AND_RUNTIME_ELEMENTS), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.LIBRARY_JAVA_RES, AndroidArtifacts.ArtifactType.JAVA_RES, RUNTIME_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.CONSUMER_PROGUARD_FILE, AndroidArtifacts.ArtifactType.PROGUARD_RULES, RUNTIME_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.LIBRARY_JNI, AndroidArtifacts.ArtifactType.JNI, RUNTIME_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.LINT_JAR, AndroidArtifacts.ArtifactType.LINT, API_AND_RUNTIME_ELEMENTS), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.EXPLODED_AAR, AndroidArtifacts.ArtifactType.EXPLODED_AAR, API_AND_RUNTIME_ELEMENTS)).withTestingSpec(VariantType.UNIT_TEST, VariantPublishingSpec.outputSpec(TaskOutputHolder.AnchorOutputType.CLASSES_FOR_UNIT_TESTS, AndroidArtifacts.ArtifactType.CLASSES, API_AND_RUNTIME_ELEMENTS));
        VariantPublishingSpec.variantSpec(VariantType.FEATURE, VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.METADATA_FEATURE_DECLARATION, AndroidArtifacts.ArtifactType.METADATA_FEATURE_DECLARATION, METADATA_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.METADADA_FEATURE_MANIFEST, AndroidArtifacts.ArtifactType.METADATA_FEATURE_MANIFEST, METADATA_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.FEATURE_IDS_DECLARATION, AndroidArtifacts.ArtifactType.FEATURE_IDS_DECLARATION, API_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.FEATURE_APPLICATION_ID_DECLARATION, AndroidArtifacts.ArtifactType.FEATURE_APPLICATION_ID_DECLARATION, API_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.FEATURE_RESOURCE_PKG, AndroidArtifacts.ArtifactType.FEATURE_RESOURCE_PKG, API_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.JAVAC, AndroidArtifacts.ArtifactType.CLASSES, API_ELEMENTS_ONLY), VariantPublishingSpec.outputSpec(TaskOutputHolder.TaskOutputType.APK, AndroidArtifacts.ArtifactType.APK, RUNTIME_ELEMENTS_ONLY));
        VariantPublishingSpec.variantSpec(VariantType.ANDROID_TEST, new OutputPublishingSpec[0]);
        VariantPublishingSpec.variantSpec(VariantType.UNIT_TEST, new OutputPublishingSpec[0]);
        VariantPublishingSpec.variantSpec(VariantType.INSTANTAPP, new OutputPublishingSpec[0]);
    }

    public static final class OutputPublishingSpec {
        private final TaskOutputHolder.OutputType outputType;
        private final AndroidArtifacts.ArtifactType artifactType;
        private final List<AndroidArtifacts.PublishedConfigType> publishedConfigTypes;

        private OutputPublishingSpec(TaskOutputHolder.OutputType outputType, AndroidArtifacts.ArtifactType artifactType, ImmutableList<AndroidArtifacts.PublishedConfigType> publishedConfigTypes) {
            this.outputType = outputType;
            this.artifactType = artifactType;
            this.publishedConfigTypes = publishedConfigTypes;
        }

        public TaskOutputHolder.OutputType getOutputType() {
            return this.outputType;
        }

        public AndroidArtifacts.ArtifactType getArtifactType() {
            return this.artifactType;
        }

        public Collection<AndroidArtifacts.PublishedConfigType> getPublishedConfigTypes() {
            return this.publishedConfigTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutputPublishingSpec that = (OutputPublishingSpec)o;
            return this.outputType == that.outputType && this.artifactType == that.artifactType && Objects.equals(this.publishedConfigTypes, that.publishedConfigTypes);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.outputType, this.artifactType, this.publishedConfigTypes});
        }
    }
}

