/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.apkzlib.utils.CachedFileContents;
import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.ide.common.res2.FileStatus;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class KnownFilesSaveData {
    private static final String SAVE_DATA_FILE_NAME = "file-input-save-data.txt";
    private static final String COUNT_PROPERTY = "count";
    private static final String BASE_SUFFIX = ".base";
    private static final String FILE_SUFFIX = ".file";
    private static final String INPUT_SET_SUFFIX = ".set";
    private static final Map<File, CachedFileContents<KnownFilesSaveData>> mCache = Maps.newHashMap();
    private final CachedFileContents<KnownFilesSaveData> mFileContentsCache;
    private final Map<RelativeFile, InputSet> mFiles;
    private boolean mDirty;

    private KnownFilesSaveData(CachedFileContents<KnownFilesSaveData> cache) throws IOException {
        this.mFileContentsCache = cache;
        this.mFiles = Maps.newHashMap();
        if (cache.getFile().isFile()) {
            this.readCurrentData();
        }
        this.mDirty = false;
    }

    public static synchronized KnownFilesSaveData make(File intermediateDir) throws IOException {
        KnownFilesSaveData saveData;
        File saveFile = KnownFilesSaveData.computeSaveFile(intermediateDir);
        CachedFileContents cached = mCache.get(saveFile);
        if (cached == null) {
            cached = new CachedFileContents(saveFile);
            mCache.put(saveFile, (CachedFileContents<KnownFilesSaveData>)cached);
        }
        if ((saveData = (KnownFilesSaveData)cached.getCache()) == null) {
            saveData = new KnownFilesSaveData((CachedFileContents<KnownFilesSaveData>)cached);
            cached.closed((Object)saveData);
        }
        return saveData;
    }

    private static File computeSaveFile(File intermediateDir) {
        return new File(intermediateDir, SAVE_DATA_FILE_NAME);
    }

    private void readCurrentData() throws IOException {
        int fileCount;
        Closer closer = Closer.create();
        File saveFile = this.mFileContentsCache.getFile();
        Properties properties = new Properties();
        try {
            Reader saveDataReader = (Reader)closer.register((Closeable)new FileReader(saveFile));
            properties.load(saveDataReader);
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
        String fileCountText = null;
        try {
            fileCountText = properties.getProperty(COUNT_PROPERTY);
            if (fileCountText == null) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + COUNT_PROPERTY + "' has no value).");
            }
            fileCount = Integer.parseInt(fileCountText);
            if (fileCount < 0) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + COUNT_PROPERTY + "' has value " + fileCount + ").");
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + COUNT_PROPERTY + "' has value '" + fileCountText + "').", e);
        }
        for (int i = 0; i < fileCount; ++i) {
            InputSet is;
            String baseName = properties.getProperty(i + BASE_SUFFIX);
            if (baseName == null) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + BASE_SUFFIX + "' has no value).");
            }
            String fileName = properties.getProperty(i + FILE_SUFFIX);
            if (fileName == null) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + FILE_SUFFIX + "' has no value).");
            }
            String inputSetName = properties.getProperty(i + INPUT_SET_SUFFIX);
            if (inputSetName == null) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + INPUT_SET_SUFFIX + "' has no value).");
            }
            try {
                is = InputSet.valueOf(InputSet.class, inputSetName);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + INPUT_SET_SUFFIX + "' has invalid value '" + inputSetName + "').");
            }
            this.mFiles.put(new RelativeFile(new File(baseName), new File(fileName)), is);
        }
    }

    public void saveCurrentData() throws IOException {
        if (!this.mDirty) {
            return;
        }
        Closer closer = Closer.create();
        Properties properties = new Properties();
        properties.put(COUNT_PROPERTY, Integer.toString(this.mFiles.size()));
        int idx = 0;
        for (Map.Entry<RelativeFile, InputSet> e : this.mFiles.entrySet()) {
            RelativeFile rf = e.getKey();
            String basePath = (String)Verify.verifyNotNull((Object)rf.getBase().getPath());
            Verify.verify((!basePath.isEmpty() ? 1 : 0) != 0);
            String filePath = (String)Verify.verifyNotNull((Object)rf.getFile().getPath());
            Verify.verify((!filePath.isEmpty() ? 1 : 0) != 0);
            properties.put(idx + BASE_SUFFIX, basePath);
            properties.put(idx + FILE_SUFFIX, filePath);
            properties.put(idx + INPUT_SET_SUFFIX, e.getValue().name());
            ++idx;
        }
        try {
            Writer saveDataWriter = (Writer)closer.register((Closeable)new FileWriter(this.mFileContentsCache.getFile()));
            properties.store(saveDataWriter, "Internal package file, do not edit.");
            this.mFileContentsCache.closed((Object)this);
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    public ImmutableSet<RelativeFile> find(Set<File> files, InputSet inputSet) {
        HashSet found = Sets.newHashSet();
        for (RelativeFile rf : Maps.filterValues(this.mFiles, (Predicate)Predicates.equalTo((Object)((Object)inputSet))).keySet()) {
            if (!files.contains(rf.getFile())) continue;
            found.add(rf);
        }
        return ImmutableSet.copyOf((Collection)found);
    }

    private java.util.function.Function<File, RelativeFile> inInputSet(InputSet inputSet) {
        Map inverseFiltered = this.mFiles.entrySet().stream().filter(e -> e.getValue() == inputSet).map(Map.Entry::getKey).collect(HashMap::new, (m, rf) -> m.put(rf.getFile(), rf), Map::putAll);
        return inverseFiltered::get;
    }

    public void setInputSet(Collection<RelativeFile> files, InputSet set) {
        Iterator<Map.Entry<RelativeFile, InputSet>> it = this.mFiles.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<RelativeFile, InputSet> next = it.next();
            if (next.getValue() != set || files.contains(next.getKey())) continue;
            it.remove();
            this.mDirty = true;
        }
        files.forEach(f -> {
            if (!this.mFiles.containsKey(f)) {
                this.mFiles.put((RelativeFile)f, set);
                this.mDirty = true;
            }
        });
    }

    public static ImmutableMap<RelativeFile, FileStatus> getChangedInputs(Map<File, FileStatus> changedInputs, KnownFilesSaveData saveData, InputSet inputSet, Collection<File> baseFiles, FileCacheByPath cacheByPath, Set<Runnable> cacheUpdates) throws IOException {
        Set<File> deletedFiles = Maps.filterValues(changedInputs, (Predicate)Predicates.equalTo((Object)FileStatus.REMOVED)).keySet();
        ImmutableSet<RelativeFile> deletedRelativeFiles = saveData.find(deletedFiles, inputSet);
        Map nonDeletedFiles = Maps.filterValues(changedInputs, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)FileStatus.REMOVED)));
        ImmutableMap nonDeletedRelativeFiles = IncrementalRelativeFileSets.makeFromBaseFiles(baseFiles, (Map)nonDeletedFiles, (FileCacheByPath)cacheByPath, cacheUpdates);
        return new ImmutableMap.Builder().putAll(Maps.asMap(deletedRelativeFiles, (Function)Functions.constant((Object)FileStatus.REMOVED))).putAll((Map)nonDeletedRelativeFiles).build();
    }

    public static enum InputSet {
        DEX,
        JAVA_RESOURCE,
        NATIVE_RESOURCE,
        ANDROID_RESOURCE,
        ASSET;

    }
}

