/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.builder.profile.ProcessProfileWriter;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.wireless.android.sdk.stats.AnnotationProcessorInfo;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;

public class ProcessAnalyticsTask
extends BaseTask {
    private FileCollection processorListFile;

    @InputFiles
    public FileCollection getProcessorListFile() {
        return this.processorListFile;
    }

    public void init(String variantName, FileCollection processorListFile) {
        this.setVariantName(variantName);
        this.processorListFile = processorListFile;
    }

    @TaskAction
    public void processAnalytics() throws IOException {
        Gson gson = new GsonBuilder().create();
        FileReader reader = new FileReader(this.processorListFile.getSingleFile());
        List classNames = (List)gson.fromJson((Reader)reader, new TypeToken<List<String>>(){}.getType());
        String projectPath = this.getProject().getPath();
        String variantName = (String)Preconditions.checkNotNull((Object)this.getVariantName());
        GradleBuildVariant.Builder variant = ProcessProfileWriter.getOrCreateVariant((String)projectPath, (String)variantName);
        for (String processorName : classNames) {
            AnnotationProcessorInfo.Builder builder = AnnotationProcessorInfo.newBuilder();
            builder.setSpec(processorName);
            variant.addAnnotationProcessors(builder);
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<ProcessAnalyticsTask> {
        private final VariantScope scope;
        private final FileCollection processorListFile;

        public ConfigAction(VariantScope scope, FileCollection processorListFile) {
            this.scope = scope;
            this.processorListFile = processorListFile;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("processAnalytics");
        }

        @Override
        public Class<ProcessAnalyticsTask> getType() {
            return ProcessAnalyticsTask.class;
        }

        @Override
        public void execute(ProcessAnalyticsTask task) {
            task.init(this.scope.getFullVariantName(), this.processorListFile);
        }
    }
}

