/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.builder.core.DexOptions;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderConfig;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexArchives;
import com.android.builder.utils.ExceptionRunnable;
import com.android.builder.utils.FileCache;
import com.android.dx.command.dexer.DxContext;
import com.android.ide.common.process.ProcessOutput;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;

class DexArchiveBuilderTransformCallable
implements Callable<Void> {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DexArchiveBuilderTransformCallable.class);
    private final Path rootPath;
    private final Predicate<Path> toProcess;
    private final Predicate<Path> toRemove;
    private final File to;
    private final Set<String> hashes;
    private final ProcessOutput processOutput;
    private final FileCache userLevelCache;
    private final FileCache projectLevelCache;
    private final DexOptions dexOptions;
    private final int minSdkVersion;

    public DexArchiveBuilderTransformCallable(Path rootPath, Predicate<Path> toProcess, Predicate<Path> toRemove, File to, Set<String> hashes, ProcessOutput processOutput, FileCache userLevelCache, FileCache projectLevelCache, DexOptions dexOptions, int minSdkVersion) {
        this.rootPath = rootPath;
        this.toProcess = toProcess;
        this.toRemove = toRemove;
        this.to = to;
        this.hashes = hashes;
        this.processOutput = processOutput;
        this.userLevelCache = userLevelCache;
        this.projectLevelCache = projectLevelCache;
        this.dexOptions = dexOptions;
        this.minSdkVersion = minSdkVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        logger.verbose("predex will process %s", this.rootPath.toString());
        String hash = DexArchiveBuilderTransformCallable.getFileHash(this.rootPath.toFile());
        Set<String> set = this.hashes;
        synchronized (set) {
            if (this.hashes.contains(hash)) {
                logger.verbose("Input with the same hash exists. Pre-dexing skipped.", new Object[0]);
                return null;
            }
            this.hashes.add(hash);
        }
        ExceptionRunnable cacheMissAction = this.cacheMissAction();
        FileCache cache = this.cacheToUse();
        if (cache != null) {
            FileCache.Inputs buildCacheInputs = this.getBuildCacheInputs(this.rootPath.toFile(), this.dexOptions);
            String actionableMessage = this.userLevelCache == cache ? "To troubleshoot the issue or learn how to disable the build cache, go to https://d.android.com/r/tools/build-cache.html.\nIf you are unable to fix the issue, please file a bug at https://d.android.com/studio/report-bugs.html." : "";
            this.getFromCacheAndCreateIfMissing(cache, buildCacheInputs, cacheMissAction, actionableMessage);
        } else {
            cacheMissAction.run();
        }
        try (DexArchive outputArchive = DexArchives.fromInput((Path)this.to.toPath());){
            for (DexArchiveEntry entry : outputArchive.getFiles()) {
                Path dexPath = entry.getRelativePathInArchive();
                Path withClassExt = DexArchiveEntry.withClassExtension((Path)dexPath);
                if (!this.toRemove.test(withClassExt)) continue;
                outputArchive.removeFile(dexPath);
            }
        }
        return null;
    }

    private FileCache cacheToUse() {
        if (this.userLevelCache != null) {
            return this.userLevelCache;
        }
        if (this.projectLevelCache != null) {
            return this.projectLevelCache;
        }
        return null;
    }

    private void getFromCacheAndCreateIfMissing(FileCache cache, FileCache.Inputs key, ExceptionRunnable cacheMissAction, String actionableMessage) {
        FileCache.QueryResult result;
        try {
            result = cache.createFile(this.to, key, cacheMissAction);
        }
        catch (ExecutionException exception) {
            logger.error(null, String.format("Unable to pre-dex '%1$s' to '%2$s'", this.rootPath.toString(), this.to.getAbsolutePath()), new Object[0]);
            throw new RuntimeException(exception);
        }
        catch (Exception exception) {
            logger.error(null, String.format("Unable to pre-dex '%1$s' to '%2$s' using the build cache at '%3$s'.\n%4$s", this.rootPath.toString(), this.to.getAbsolutePath(), cache.getCacheDirectory().getAbsolutePath(), actionableMessage), new Object[0]);
            throw new RuntimeException(exception);
        }
        if (result.getQueryEvent().equals((Object)FileCache.QueryEvent.CORRUPTED)) {
            Verify.verifyNotNull((Object)result.getCauseOfCorruption());
            logger.verbose("The build cache at '%1$s' contained an invalid cache entry.\nCause: %2$s\nWe have recreated the cache entry.\n%3$s", cache.getCacheDirectory().getAbsolutePath(), Throwables.getStackTraceAsString((Throwable)result.getCauseOfCorruption()), actionableMessage);
        }
    }

    private ExceptionRunnable cacheMissAction() {
        return () -> {
            try (ClassFileInput input = ClassFileInputs.fromPath((Path)this.rootPath, this.toProcess);
                 DexArchive outputArchive = DexArchives.fromInput((Path)this.to.toPath());){
                boolean optimizedDex = !this.dexOptions.getAdditionalParameters().contains("--no-optimize");
                DxContext dxContext = new DxContext(this.processOutput.getStandardOutput(), this.processOutput.getErrorOutput());
                DexArchiveBuilderConfig config = new DexArchiveBuilderConfig(dxContext, optimizedDex, this.minSdkVersion);
                DexArchiveBuilder converter = new DexArchiveBuilder(config);
                converter.convert(input, outputArchive);
            }
        };
    }

    private FileCache.Inputs getBuildCacheInputs(File inputFile, DexOptions dexOptions) throws IOException {
        FileCache.Inputs.Builder buildCacheInputs = new FileCache.Inputs.Builder(FileCache.Command.PREDEX_LIBRARY_TO_DEX_ARCHIVE);
        if (inputFile.getPath().contains("exploded-aar")) {
            buildCacheInputs.putString(FileCacheInputParams.EXPLODED_AAR_FILE_PATH.name(), inputFile.getPath().substring(inputFile.getPath().lastIndexOf("exploded-aar")));
        } else if (inputFile.getName().equals("instant-run.jar")) {
            buildCacheInputs.putString(FileCacheInputParams.INSTANT_RUN_JAR_FILE_NAME.name(), inputFile.getName());
        } else {
            buildCacheInputs.putFilePath(FileCacheInputParams.FILE_PATH.name(), inputFile);
        }
        buildCacheInputs.putFileHash(FileCacheInputParams.FILE_HASH.name(), inputFile).putString(FileCacheInputParams.DX_VERSION.name(), "1.13").putBoolean(FileCacheInputParams.JUMBO_MODE.name(), dexOptions.getJumboMode()).putBoolean(FileCacheInputParams.OPTIMIZE.name(), !dexOptions.getAdditionalParameters().contains("--no-optimize"));
        return buildCacheInputs.build();
    }

    private static String getFileHash(File file) throws IOException {
        HashFunction hashFunction = Hashing.sha1();
        HashCode hashCode = file.isDirectory() ? hashFunction.hashString((CharSequence)file.getPath(), Charsets.UTF_16LE) : Files.hash((File)file, (HashFunction)hashFunction);
        return hashCode.toString();
    }

    private static enum FileCacheInputParams {
        FILE_PATH,
        EXPLODED_AAR_FILE_PATH,
        INSTANT_RUN_JAR_FILE_NAME,
        FILE_HASH,
        DX_VERSION,
        JUMBO_MODE,
        OPTIMIZE;

    }
}

