/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

@ParallelizableTask
@CacheableTask
public class ShaderCompile
extends BaseTask {
    private static final PatternSet PATTERN_SET = new PatternSet().include(new String[]{"**/*.vert"}).include(new String[]{"**/*.tesc"}).include(new String[]{"**/*.tese"}).include(new String[]{"**/*.geom"}).include(new String[]{"**/*.frag"}).include(new String[]{"**/*.comp"});
    private File outputDir;
    private File sourceDir;
    private List<String> defaultArgs = ImmutableList.of();
    private Map<String, List<String>> scopedArgs = ImmutableMap.of();
    private File ndkLocation;

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSourceFiles() {
        FileTree src = null;
        if (this.sourceDir.isDirectory()) {
            src = this.getProject().files(new Object[]{this.sourceDir}).getAsFileTree().matching((PatternFilterable)PATTERN_SET);
        }
        return src == null ? this.getProject().files(new Object[0]).getAsFileTree() : src;
    }

    @TaskAction
    protected void compileShaders() throws IOException {
        File destinationDir = this.getOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        try {
            this.getBuilder().compileAllShaderFiles(this.sourceDir, this.getOutputDir(), this.defaultArgs, this.scopedArgs, this.ndkLocation, (ProcessOutputHandler)new LoggedProcessOutputHandler(this.getILogger()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File sourceOutputDir) {
        this.outputDir = sourceOutputDir;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Input
    public List<String> getDefaultArgs() {
        return this.defaultArgs;
    }

    public void setDefaultArgs(List<String> defaultArgs) {
        this.defaultArgs = ImmutableList.copyOf(defaultArgs);
    }

    @Input
    public Map<String, List<String>> getScopedArgs() {
        return this.scopedArgs;
    }

    public void setScopedArgs(Map<String, List<String>> scopedArgs) {
        this.scopedArgs = ImmutableMap.copyOf(scopedArgs);
    }

    public static class ConfigAction
    implements TaskConfigAction<ShaderCompile> {
        VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("compile", "Shaders");
        }

        @Override
        public Class<ShaderCompile> getType() {
            return ShaderCompile.class;
        }

        @Override
        public void execute(ShaderCompile compileTask) {
            GradleVariantConfiguration variantConfiguration = this.scope.getVariantConfiguration();
            this.scope.getVariantData().shaderCompileTask = compileTask;
            compileTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            compileTask.setVariantName(variantConfiguration.getFullName());
            compileTask.ndkLocation = this.scope.getGlobalScope().getNdkHandler().getNdkDirectory();
            compileTask.setSourceDir(this.scope.getMergeShadersOutputDir());
            compileTask.setOutputDir(this.scope.getShadersOutputDir());
            compileTask.setDefaultArgs(variantConfiguration.getDefautGlslcArgs());
            compileTask.setScopedArgs(variantConfiguration.getScopedGlslcArgs());
        }
    }
}

