/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.cmake.server;

import com.android.build.gradle.external.cmake.server.CompileCommand;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;

public class ServerUtils {
    public static List<CompileCommand> getCompilationDatabase(File buildDirectory, String compileCommandsFilename) throws IOException, JsonSyntaxException {
        File compileCommandsFile = new File(buildDirectory, compileCommandsFilename);
        if (!compileCommandsFile.isFile()) {
            throw new RuntimeException(String.format("File %s not found", compileCommandsFile));
        }
        return ServerUtils.getCompilationDatabase(compileCommandsFile);
    }

    public static List<CompileCommand> getCompilationDatabase(File compileCommandsFile) throws IOException, JsonSyntaxException {
        String text = new String(Files.readAllBytes(compileCommandsFile.toPath()), StandardCharsets.UTF_8);
        Gson gson = new GsonBuilder().create();
        return Arrays.asList((Object[])gson.fromJson(text, CompileCommand[].class));
    }
}

