/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.google.common.io.Files;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.file.RelativePath;

public class LibraryCache {
    public static void unzipAar(File bundle, File folderOut, Project project) {
        for (File f : Files.fileTreeTraverser().postOrderTraversal((Object)folderOut)) {
            f.delete();
        }
        folderOut.mkdirs();
        project.copy(copySpec -> {
            copySpec.from(new Object[]{project.zipTree((Object)bundle)});
            copySpec.into((Object)folderOut);
            copySpec.filesMatching("**/*.jar", details -> {
                String path = details.getRelativePath().getPathString();
                if (path.equals("classes.jar") || path.equals("lint.jar") || path.startsWith("libs/")) {
                    details.setRelativePath(new RelativePath(false, new String[]{"jars"}).plus(details.getRelativePath()));
                } else if (!path.startsWith("res/raw/*") && !path.startsWith("assets/*")) {
                    project.getLogger().warn("Jar found at unexpected path (" + path + ") in " + bundle + " and will be ignored. Jars should be " + "placed inside 'jars' folder to be merged into dex. Jars " + "that are in assets/ or res/raw/ will be copied as-is.");
                }
            });
        });
    }
}

