/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.dsl.StringToEnumConverters;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;

public class PostprocessingOptions {
    private static final String AUTO = "auto";
    private final Project project;
    private boolean removeUnusedCode;
    private boolean removeUnusedResources;
    private boolean obfuscate;
    private boolean optimizeCode;
    private List<File> proguardFiles;
    private List<File> testProguardFiles;
    private List<File> consumerProguardFiles;
    private CodeShrinker codeShrinker;

    public PostprocessingOptions(Project project) {
        this(project, (List<File>)ImmutableList.of((Object)ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.NO_ACTIONS.fileName, project)));
    }

    PostprocessingOptions(Project project, List<File> proguardFiles) {
        this.project = project;
        this.proguardFiles = Lists.newArrayList(proguardFiles);
        this.testProguardFiles = new ArrayList<File>();
        this.consumerProguardFiles = new ArrayList<File>();
    }

    public void initWith(PostprocessingOptions that) {
        this.removeUnusedCode = that.isRemoveUnusedCode();
        this.removeUnusedResources = that.isRemoveUnusedResources();
        this.obfuscate = that.isObfuscate();
        this.optimizeCode = that.isOptimizeCode();
        this.proguardFiles = Lists.newArrayList(that.getProguardFiles());
        this.testProguardFiles = Lists.newArrayList(that.getTestProguardFiles());
        this.consumerProguardFiles = Lists.newArrayList(that.getConsumerProguardFiles());
        this.codeShrinker = that.getCodeShrinkerEnum();
    }

    public boolean isRemoveUnusedCode() {
        return this.removeUnusedCode;
    }

    public void setRemoveUnusedCode(boolean removeUnusedCode) {
        this.removeUnusedCode = removeUnusedCode;
    }

    public boolean isRemoveUnusedResources() {
        return this.removeUnusedResources;
    }

    public void setRemoveUnusedResources(boolean removeUnusedResources) {
        this.removeUnusedResources = removeUnusedResources;
    }

    public boolean isObfuscate() {
        return this.obfuscate;
    }

    public void setObfuscate(boolean obfuscate) {
        this.obfuscate = obfuscate;
    }

    public boolean isOptimizeCode() {
        return this.optimizeCode;
    }

    public void setOptimizeCode(boolean optimizeCode) {
        this.optimizeCode = optimizeCode;
    }

    public List<File> getProguardFiles() {
        return this.proguardFiles;
    }

    public void setProguardFiles(List<File> proguardFiles) {
        this.proguardFiles = proguardFiles;
    }

    public void proguardFile(Object file) {
        this.proguardFiles.add(this.project.file(file));
    }

    public void proguardFiles(Object ... files) {
        for (Object file : files) {
            this.proguardFile(file);
        }
    }

    public List<File> getTestProguardFiles() {
        return this.testProguardFiles;
    }

    public void setTestProguardFiles(List<File> testProguardFiles) {
        this.testProguardFiles = testProguardFiles;
    }

    public void testProguardFile(Object file) {
        this.testProguardFiles.add(this.project.file(file));
    }

    public void testProguardFiles(Object ... files) {
        for (Object file : files) {
            this.testProguardFile(file);
        }
    }

    public List<File> getConsumerProguardFiles() {
        return this.consumerProguardFiles;
    }

    public void setConsumerProguardFiles(List<File> consumerProguardFiles) {
        this.consumerProguardFiles = consumerProguardFiles;
    }

    public void consumerProguardFile(Object file) {
        this.consumerProguardFiles.add(this.project.file(file));
    }

    public void consumerProguardFiles(Object ... files) {
        for (Object file : files) {
            this.consumerProguardFile(file);
        }
    }

    public String getCodeShrinker() {
        if (this.codeShrinker == null) {
            return AUTO;
        }
        return (String)Verify.verifyNotNull((Object)StringToEnumConverters.forClass(CodeShrinker.class).reverse().convert((Object)this.codeShrinker));
    }

    public void setCodeShrinker(String name) {
        this.codeShrinker = name.equals(AUTO) ? null : (CodeShrinker)((Object)StringToEnumConverters.forClass(CodeShrinker.class).convert((Object)name));
    }

    public CodeShrinker getCodeShrinkerEnum() {
        return this.codeShrinker;
    }
}

