/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.externalBuild;

import com.android.build.VariantOutput;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.externalBuild.ExternalBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.GenericVariantScopeImpl;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.SplitScope;
import com.android.build.gradle.internal.scope.TransformGlobalScope;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.build.gradle.options.DeploymentDevice;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.internal.aapt.AaptOptions;
import com.android.ide.common.build.ApkData;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.Project;

class ExternalBuildVariantScope
extends GenericVariantScopeImpl
implements TransformVariantScope,
InstantRunVariantScope {
    private final TransformGlobalScope globalScope;
    private final File outputRootFolder;
    private final ExternalBuildContext externalBuildContext;
    private final InstantRunBuildContext mInstantRunBuildContext;
    private final AaptOptions aaptOptions;
    private final ManifestAttributeSupplier manifestAttributeSupplier;
    private final SplitScope splitScope;

    ExternalBuildVariantScope(TransformGlobalScope globalScope, File outputRootFolder, ExternalBuildContext externalBuildContext, AaptOptions aaptOptions, ManifestAttributeSupplier manifestAttributeSupplier, Collection<ApkData> apkDatas) {
        this.globalScope = globalScope;
        this.outputRootFolder = outputRootFolder;
        this.externalBuildContext = externalBuildContext;
        this.aaptOptions = aaptOptions;
        this.manifestAttributeSupplier = manifestAttributeSupplier;
        ProjectOptions projectOptions = globalScope.getProjectOptions();
        this.mInstantRunBuildContext = new InstantRunBuildContext(true, DeploymentDevice.getDeploymentDeviceAndroidVersion(projectOptions), projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI), projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY));
        this.splitScope = new SplitScope(SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY, apkDatas);
    }

    @Override
    public SplitScope getSplitScope() {
        return this.splitScope;
    }

    @Override
    public TransformGlobalScope getGlobalScope() {
        return this.globalScope;
    }

    @Override
    protected Project getProject() {
        return this.globalScope.getProject();
    }

    @Override
    public String getTaskName(String prefix) {
        return prefix + StringHelper.capitalize((String)this.getFullVariantName());
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        return prefix + StringHelper.capitalize((String)this.getFullVariantName()) + suffix;
    }

    @Override
    public String getDirName() {
        return "debug";
    }

    @Override
    public Collection<String> getDirectorySegments() {
        return ImmutableList.of((Object)"debug");
    }

    @Override
    public String getFullVariantName() {
        return "debug";
    }

    @Override
    public ImmutableList<File> getInstantRunBootClasspath() {
        IAndroidTarget target = this.externalBuildContext.getAndroidBuilder().getTarget();
        ImmutableList.Builder fileListBuilder = ImmutableList.builder();
        if (target != null) {
            for (String classpathElement : target.getBootClasspath()) {
                fileListBuilder.add((Object)new File(classpathElement));
            }
        }
        return fileListBuilder.build();
    }

    @Override
    public File getBuildInfoOutputFolder() {
        return new File(this.outputRootFolder, "/build-info/debug");
    }

    @Override
    public File getReloadDexOutputFolder() {
        return new File(this.outputRootFolder, "/reload-dex/debug");
    }

    @Override
    public File getRestartDexOutputFolder() {
        return new File(this.outputRootFolder, "/reload-dex/debug");
    }

    @Override
    public File getInstantRunSupportDir() {
        return new File(this.outputRootFolder, "/instant-run-support/debug");
    }

    @Override
    public File getIncrementalVerifierDir() {
        return new File(this.outputRootFolder, "/incremental-verifier/debug");
    }

    @Override
    public InstantRunBuildContext getInstantRunBuildContext() {
        return this.mInstantRunBuildContext;
    }

    @Override
    public File getIncrementalApplicationSupportDir() {
        return new File(this.outputRootFolder, "/incremental-classes/app-support");
    }

    @Override
    public File getInstantRunResourcesFile() {
        return new File(this.outputRootFolder, "/instant-run-resources/debug.ir.ap_");
    }

    @Override
    public File getIncrementalRuntimeSupportJar() {
        return new File(this.outputRootFolder, "/incremental-runtime-classes/instant-run.jar");
    }

    @Override
    public File getInstantRunPastIterationsFolder() {
        return FileUtils.join((File)this.outputRootFolder, (String[])new String[]{"intermediates", "builds", this.getFullVariantName()});
    }

    @Override
    public File getInstantRunSliceSupportDir() {
        return FileUtils.join((File)this.outputRootFolder, (String[])new String[]{"intermediates", "instant-run-slices", this.getFullVariantName()});
    }

    @Override
    public TransformVariantScope getTransformVariantScope() {
        return this;
    }

    public ApkOutputFile getMainOutputFile() {
        return new ApkOutputFile(VariantOutput.OutputType.MAIN, Collections.emptySet(), () -> new File(this.outputRootFolder, "/outputs/apk/debug.apk"), this.getVersionCode());
    }

    public File getIncrementalDir(String name) {
        return FileUtils.join((File)this.outputRootFolder, (String[])new String[]{"incremental", name});
    }

    public File getInstantRunSplitApkOutputFolder() {
        return FileUtils.join((File)this.outputRootFolder, (String[])new String[]{"incremental", "splits"});
    }

    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public String getApplicationId() {
        return this.manifestAttributeSupplier.getPackage();
    }

    public int getVersionCode() {
        return this.manifestAttributeSupplier.getVersionCode();
    }

    public String getVersionName() {
        return this.manifestAttributeSupplier.getVersionName();
    }
}

