/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.ide.DefaultJavaCompileOptions;
import com.android.builder.Version;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ArtifactMetaData;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.LintOptions;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;

final class DefaultAndroidProject
implements AndroidProject,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String compileTarget;
    private final Collection<String> bootClasspath;
    private final Collection<File> frameworkSource;
    private final Collection<SigningConfig> signingConfigs;
    private final AaptOptions aaptOptions;
    private final Collection<ArtifactMetaData> extraArtifacts;
    private final Collection<SyncIssue> syncIssues;
    private final int generation;
    private final boolean baseSplit;
    private final JavaCompileOptions javaCompileOptions;
    private final LintOptions lintOptions;
    private final File buildFolder;
    private final String buildToolsVersion;
    private final String resourcePrefix;
    private final Collection<NativeToolchain> nativeToolchains;
    private final int projectType;
    private final int apiVersion;
    private final ProductFlavorContainer defaultConfig;
    private final Collection<BuildTypeContainer> buildTypes;
    private final Collection<ProductFlavorContainer> productFlavors;
    private final Collection<Variant> variants;
    private final Collection<String> flavorDimensions;

    DefaultAndroidProject(String name, ProductFlavorContainer defaultConfig, Collection<String> flavorDimensions, Collection<BuildTypeContainer> buildTypes, Collection<ProductFlavorContainer> productFlavors, Collection<Variant> variants, String compileTarget, Collection<String> bootClasspath, Collection<File> frameworkSource, Collection<SigningConfig> signingConfigs, AaptOptions aaptOptions, Collection<ArtifactMetaData> extraArtifacts, Collection<SyncIssue> syncIssues, CompileOptions compileOptions, LintOptions lintOptions, File buildFolder, String resourcePrefix, Collection<NativeToolchain> nativeToolchains, String buildToolsVersion, int projectType, int apiVersion, int generation, boolean baseSplit) {
        this.name = name;
        this.defaultConfig = defaultConfig;
        this.flavorDimensions = flavorDimensions;
        this.buildTypes = buildTypes;
        this.productFlavors = productFlavors;
        this.variants = variants;
        this.compileTarget = compileTarget;
        this.bootClasspath = bootClasspath;
        this.frameworkSource = frameworkSource;
        this.signingConfigs = signingConfigs;
        this.aaptOptions = aaptOptions;
        this.extraArtifacts = extraArtifacts;
        this.syncIssues = syncIssues;
        this.javaCompileOptions = new DefaultJavaCompileOptions(compileOptions);
        this.lintOptions = lintOptions;
        this.buildFolder = buildFolder;
        this.resourcePrefix = resourcePrefix;
        this.projectType = projectType;
        this.apiVersion = apiVersion;
        this.generation = generation;
        this.nativeToolchains = nativeToolchains;
        this.buildToolsVersion = buildToolsVersion;
        this.baseSplit = baseSplit;
    }

    public String getModelVersion() {
        return Version.ANDROID_GRADLE_PLUGIN_VERSION;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public String getName() {
        return this.name;
    }

    public ProductFlavorContainer getDefaultConfig() {
        return this.defaultConfig;
    }

    public Collection<BuildTypeContainer> getBuildTypes() {
        return this.buildTypes;
    }

    public Collection<ProductFlavorContainer> getProductFlavors() {
        return this.productFlavors;
    }

    public Collection<Variant> getVariants() {
        return this.variants;
    }

    public Collection<String> getFlavorDimensions() {
        return this.flavorDimensions;
    }

    public Collection<ArtifactMetaData> getExtraArtifacts() {
        return this.extraArtifacts;
    }

    public boolean isLibrary() {
        return this.getProjectType() == 1;
    }

    public int getProjectType() {
        return this.projectType;
    }

    public String getCompileTarget() {
        return this.compileTarget;
    }

    public Collection<String> getBootClasspath() {
        return this.bootClasspath;
    }

    public Collection<File> getFrameworkSources() {
        return this.frameworkSource;
    }

    public Collection<SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public LintOptions getLintOptions() {
        return this.lintOptions;
    }

    public Collection<String> getUnresolvedDependencies() {
        return ImmutableList.of();
    }

    public Collection<SyncIssue> getSyncIssues() {
        return this.syncIssues;
    }

    public JavaCompileOptions getJavaCompileOptions() {
        return this.javaCompileOptions;
    }

    public File getBuildFolder() {
        return this.buildFolder;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public Collection<NativeToolchain> getNativeToolchains() {
        return this.nativeToolchains;
    }

    public String getBuildToolsVersion() {
        return this.buildToolsVersion;
    }

    public int getPluginGeneration() {
        return this.generation;
    }

    public boolean isBaseSplit() {
        return this.baseSplit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAndroidProject that = (DefaultAndroidProject)o;
        return this.generation == that.generation && this.projectType == that.projectType && this.apiVersion == that.apiVersion && Objects.equals(this.name, that.name) && Objects.equals(this.compileTarget, that.compileTarget) && Objects.equals(this.bootClasspath, that.bootClasspath) && Objects.equals(this.frameworkSource, that.frameworkSource) && Objects.equals(this.signingConfigs, that.signingConfigs) && Objects.equals(this.aaptOptions, that.aaptOptions) && Objects.equals(this.extraArtifacts, that.extraArtifacts) && Objects.equals(this.syncIssues, that.syncIssues) && Objects.equals(this.javaCompileOptions, that.javaCompileOptions) && Objects.equals(this.lintOptions, that.lintOptions) && Objects.equals(this.buildFolder, that.buildFolder) && Objects.equals(this.buildToolsVersion, that.buildToolsVersion) && Objects.equals(this.resourcePrefix, that.resourcePrefix) && Objects.equals(this.nativeToolchains, that.nativeToolchains) && Objects.equals(this.buildTypes, that.buildTypes) && Objects.equals(this.productFlavors, that.productFlavors) && Objects.equals(this.variants, that.variants) && Objects.equals(this.defaultConfig, that.defaultConfig) && Objects.equals(this.flavorDimensions, that.flavorDimensions) && Objects.equals(this.baseSplit, that.baseSplit);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.compileTarget, this.bootClasspath, this.frameworkSource, this.signingConfigs, this.aaptOptions, this.extraArtifacts, this.syncIssues, this.generation, this.javaCompileOptions, this.lintOptions, this.buildFolder, this.buildToolsVersion, this.resourcePrefix, this.nativeToolchains, this.projectType, this.apiVersion, this.buildTypes, this.productFlavors, this.variants, this.defaultConfig, this.flavorDimensions, this.baseSplit);
    }
}

