/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.api.AnnotationProcessorOptions;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class JavaPreCompileTask
extends BaseTask {
    static final String DATA_BINDING_SPEC = "android.databinding.DataBinding";
    private static final String PROCESSOR_SERVICES = "META-INF/services/javax.annotation.processing.Processor";
    private File processorListFile;
    private String annotationProcessorConfigurationName;
    private FileCollection annotationProcessorConfiguration;
    private FileCollection compileClasspaths;
    private AnnotationProcessorOptions annotationProcessorOptions;
    private boolean dataBindingEnabled;

    void init(File processorListFile, String annotationProcessorConfigurationName, FileCollection annotationProcessorConfiguration, FileCollection compileClasspaths, AnnotationProcessorOptions annotationProcessorOptions, boolean dataBindingEnabled) {
        this.processorListFile = processorListFile;
        this.annotationProcessorConfigurationName = annotationProcessorConfigurationName;
        this.annotationProcessorConfiguration = annotationProcessorConfiguration;
        this.compileClasspaths = compileClasspaths;
        this.annotationProcessorOptions = annotationProcessorOptions;
        this.dataBindingEnabled = dataBindingEnabled;
    }

    @OutputFile
    public File getProcessorListFile() {
        return this.processorListFile;
    }

    @Classpath
    public FileCollection getAnnotationProcessorConfiguration() {
        return this.annotationProcessorConfiguration;
    }

    @Classpath
    public FileCollection getCompileClasspaths() {
        return this.compileClasspaths;
    }

    @TaskAction
    public void preCompile() throws IOException {
        boolean grandfathered = this.annotationProcessorOptions.getIncludeCompileClasspath() != null || this.hasOldAptPlugin();
        List<File> compileProcessors = null;
        if (!grandfathered) {
            compileProcessors = JavaPreCompileTask.collectAnnotationProcessors(this.compileClasspaths);
            compileProcessors.removeAll(this.annotationProcessorConfiguration.getFiles());
            if (!compileProcessors.isEmpty()) {
                this.throwException(JavaPreCompileTask.convertFilesToNames(compileProcessors));
            }
        }
        HashSet classNames = Sets.newHashSet();
        if (Boolean.TRUE.equals(this.annotationProcessorOptions.getIncludeCompileClasspath())) {
            if (compileProcessors == null) {
                compileProcessors = JavaPreCompileTask.collectAnnotationProcessors(this.compileClasspaths);
            }
            classNames.addAll(JavaPreCompileTask.convertFilesToNames(compileProcessors));
        }
        classNames.addAll(JavaPreCompileTask.convertFilesToNames(JavaPreCompileTask.collectAnnotationProcessors(this.annotationProcessorConfiguration)));
        classNames.addAll(this.annotationProcessorOptions.getClassNames());
        if (this.dataBindingEnabled) {
            classNames.add(DATA_BINDING_SPEC);
        }
        FileUtils.deleteIfExists((File)this.processorListFile);
        Gson gson = new GsonBuilder().create();
        try (FileWriter writer = new FileWriter(this.processorListFile);){
            gson.toJson((Object)classNames, (Appendable)writer);
        }
    }

    private static List<File> collectAnnotationProcessors(FileCollection configuration) throws IOException {
        ArrayList processors = Lists.newArrayList();
        for (File file : configuration.getFiles()) {
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                if (!new File(file, PROCESSOR_SERVICES).exists()) continue;
                processors.add(file);
                continue;
            }
            try {
                JarFile jarFile = new JarFile(file);
                Throwable throwable = null;
                try {
                    JarEntry entry = jarFile.getJarEntry(PROCESSOR_SERVICES);
                    if (entry == null) continue;
                    processors.add(file);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return processors;
    }

    private static List<String> convertFilesToNames(Collection<File> files) {
        return files.stream().map(File::getName).collect(Collectors.toList());
    }

    private boolean hasOldAptPlugin() {
        return this.getProject().getPlugins().hasPlugin("com.neenbedankt.android-apt");
    }

    private void throwException(List<String> processors) throws RuntimeException {
        throw new RuntimeException("Annotation processors must be explicitly declared now.  The following dependencies on the compile classpath are found to contain annotation processor.  Please add them to the " + this.annotationProcessorConfigurationName + " configuration.\n  - " + Joiner.on((String)"\n  - ").join(processors) + "\nAlternatively, set " + "android.defaultConfig.javaCompileOptions.annotationProcessorOptions.includeCompileClasspath = true " + "to continue with previous behavior.  Note that this option " + "is deprecated and will be removed in the future.\n" + "See " + "https://developer.android.com/r/tools/annotation-processor-error-message.html " + "for more details.");
    }

    public static class ConfigAction
    implements TaskConfigAction<JavaPreCompileTask> {
        private final VariantScope scope;
        private final File processorListFile;

        public ConfigAction(VariantScope scope, File processorListFile) {
            this.scope = scope;
            this.processorListFile = processorListFile;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("javaPreCompile");
        }

        @Override
        public Class<JavaPreCompileTask> getType() {
            return JavaPreCompileTask.class;
        }

        @Override
        public void execute(JavaPreCompileTask task) {
            task.init(this.processorListFile, this.scope.getVariantData().getType().isForTesting() ? this.scope.getVariantData().getType().getPrefix() + "AnnotationProcessor" : "annotationProcessor", this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR), this.scope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES), this.scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions(), false);
            task.setVariantName(this.scope.getFullVariantName());
        }
    }
}

