/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.ResourceException;
import com.android.build.gradle.tasks.WorkerExecutorAdapter;
import com.android.builder.core.VariantType;
import com.android.ide.common.res2.AssetMerger;
import com.android.ide.common.res2.AssetSet;
import com.android.ide.common.res2.DataSet;
import com.android.ide.common.res2.FileStatus;
import com.android.ide.common.res2.FileValidity;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergedAssetWriter;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class MergeSourceSetFolders
extends IncrementalTask {
    private File outputDir;
    private Supplier<List<AssetSet>> assetSetSupplier;
    private ArtifactCollection libraries = null;
    private FileCollection shadersOutputDir = null;
    private FileCollection copyApk = null;
    private String ignoreAssets = null;
    private final FileValidity<AssetSet> fileValidity = new FileValidity();
    private final WorkerExecutorFacade<MergedAssetWriter.AssetWorkParameters> workerExecutor;

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Inject
    public MergeSourceSetFolders(WorkerExecutor workerExecutor) {
        this.workerExecutor = new WorkerExecutorAdapter<MergedAssetWriter.AssetWorkParameters>(workerExecutor, AssetWorkAction.class);
    }

    @Override
    @Internal
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        File destinationDir = this.getOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        List<AssetSet> assetSets = this.computeAssetSetList();
        AssetMerger merger = new AssetMerger();
        try {
            for (AssetSet assetSet : assetSets) {
                assetSet.loadFromFiles(this.getILogger());
                merger.addDataSet((DataSet)assetSet);
            }
            MergedAssetWriter writer = new MergedAssetWriter(destinationDir, this.workerExecutor);
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (MergingException e) {
            this.getLogger().error("Could not merge source set folders: ", (Throwable)e);
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        AssetMerger merger = new AssetMerger();
        try {
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            List<AssetSet> assetSets = this.computeAssetSetList();
            if (!merger.checkValidUpdate(assetSets)) {
                this.getLogger().info("Changed Asset sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (Map.Entry<File, FileStatus> entry : changedInputs.entrySet()) {
                File changedFile = entry.getKey();
                if (changedFile.isDirectory()) continue;
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((AssetSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, entry.getValue(), this.getILogger())) continue;
                this.getLogger().info("Failed to process {} event! Full task run", (Object)entry.getValue());
                this.doFullTaskAction();
                return;
            }
            MergedAssetWriter writer = new MergedAssetWriter(this.getOutputDir(), this.workerExecutor);
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (MergingException e) {
            this.getLogger().error("Could not merge source set folders: ", (Throwable)e);
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
        finally {
            this.fileValidity.clear();
        }
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getLibraries() {
        if (this.libraries != null) {
            return this.libraries.getArtifactFiles();
        }
        return null;
    }

    public void setLibraries(ArtifactCollection libraries) {
        this.libraries = libraries;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getShadersOutputDir() {
        return this.shadersOutputDir;
    }

    void setShadersOutputDir(FileCollection shadersOutputDir) {
        this.shadersOutputDir = shadersOutputDir;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getCopyApk() {
        return this.copyApk;
    }

    void setCopyApk(FileCollection copyApk) {
        this.copyApk = copyApk;
    }

    @Input
    @Optional
    public String getIgnoreAssets() {
        return this.ignoreAssets;
    }

    void setAssetSetSupplier(Supplier<List<AssetSet>> assetSetSupplier) {
        this.assetSetSupplier = assetSetSupplier;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Set<File> getSourceFolderInputs() {
        List<AssetSet> sets = this.assetSetSupplier.get();
        HashSet assetSetFolders = Sets.newHashSetWithExpectedSize((int)sets.size());
        for (AssetSet assetSet : sets) {
            assetSetFolders.addAll(assetSet.getSourceFiles());
        }
        return assetSetFolders;
    }

    List<AssetSet> computeAssetSetList() {
        ArrayList assetSetList;
        ArrayList assetSets = this.assetSetSupplier.get();
        if (this.copyApk == null && this.shadersOutputDir == null && this.ignoreAssets == null && this.libraries == null) {
            assetSetList = assetSets;
        } else {
            int size = assetSets.size() + 3;
            if (this.libraries != null) {
                size += this.libraries.getArtifacts().size();
            }
            assetSetList = Lists.newArrayListWithExpectedSize((int)size);
            if (this.libraries != null) {
                Set libArtifacts = this.libraries.getArtifacts();
                for (ResolvedArtifactResult artifact : libArtifacts) {
                    AssetSet assetSet = new AssetSet(MergeManifests.getArtifactName(artifact));
                    assetSet.addSource(artifact.getFile());
                    assetSetList.add(0, assetSet);
                }
            }
            ArrayList generatedAssetFolders = Lists.newArrayList();
            if (this.shadersOutputDir != null) {
                generatedAssetFolders.addAll(this.shadersOutputDir.getFiles());
            }
            if (this.copyApk != null) {
                generatedAssetFolders.addAll(this.copyApk.getFiles());
            }
            AssetSet mainAssetSet = (AssetSet)assetSets.get(0);
            assert (mainAssetSet.getConfigName().equals("main"));
            mainAssetSet.addSources((Collection)generatedAssetFolders);
            assetSetList.addAll(assetSets);
        }
        if (this.ignoreAssets != null) {
            for (AssetSet set : assetSetList) {
                set.setIgnoredPatterns(this.ignoreAssets);
            }
        }
        return assetSetList;
    }

    public static class MergeShaderSourceFoldersConfigAction
    extends ConfigAction {
        public MergeShaderSourceFoldersConfigAction(VariantScope scope) {
            super(scope, null);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("merge", "Shaders");
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            super.execute(mergeAssetsTask);
            BaseVariantData variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            mergeAssetsTask.assetSetSupplier = TaskInputHelper.memoize(() -> ((GradleVariantConfiguration)variantConfig).getShaderSets());
            mergeAssetsTask.setOutputDir(this.scope.getMergeShadersOutputDir());
        }
    }

    public static class MergeJniLibFoldersConfigAction
    extends ConfigAction {
        public MergeJniLibFoldersConfigAction(VariantScope scope) {
            super(scope, null);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("merge", "JniLibFolders");
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            super.execute(mergeAssetsTask);
            BaseVariantData variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            mergeAssetsTask.assetSetSupplier = TaskInputHelper.memoize(() -> ((GradleVariantConfiguration)variantConfig).getJniLibsSets());
            mergeAssetsTask.setOutputDir(this.scope.getMergeNativeLibsOutputDir());
        }
    }

    public static class MergeAssetConfigAction
    extends ConfigAction {
        public MergeAssetConfigAction(VariantScope scope, File outputDir) {
            super(scope, outputDir);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("merge", "Assets");
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            AaptOptions options;
            super.execute(mergeAssetsTask);
            BaseVariantData variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            Project project = this.scope.getGlobalScope().getProject();
            variantData.mergeAssetsTask = mergeAssetsTask;
            mergeAssetsTask.assetSetSupplier = TaskInputHelper.memoize(() -> ((GradleVariantConfiguration)variantConfig).getAssetSets());
            mergeAssetsTask.shadersOutputDir = (FileCollection)project.files(new Object[]{this.scope.getShadersOutputDir()});
            if (variantData.copyApkTask != null) {
                mergeAssetsTask.copyApk = (FileCollection)project.files(new Object[]{variantData.copyApkTask.getDestinationDir()});
            }
            if ((options = this.scope.getGlobalScope().getExtension().getAaptOptions()) != null) {
                mergeAssetsTask.ignoreAssets = options.getIgnoreAssets();
            }
            if (!variantConfig.getType().equals((Object)VariantType.LIBRARY)) {
                mergeAssetsTask.libraries = this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ASSETS);
            }
            mergeAssetsTask.setOutputDir(this.outputDir);
        }
    }

    protected static abstract class ConfigAction
    implements TaskConfigAction<MergeSourceSetFolders> {
        protected final VariantScope scope;
        protected final File outputDir;

        protected ConfigAction(VariantScope scope, File outputDir) {
            this.scope = scope;
            this.outputDir = outputDir;
        }

        @Override
        public Class<MergeSourceSetFolders> getType() {
            return MergeSourceSetFolders.class;
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            BaseVariantData variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            mergeAssetsTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            mergeAssetsTask.setVariantName(variantConfig.getFullName());
            mergeAssetsTask.setIncrementalFolder(this.scope.getIncrementalDir(this.getName()));
        }
    }

    public static class AssetWorkAction
    implements Runnable {
        private final MergedAssetWriter.AssetWorkAction workAction;

        @Inject
        public AssetWorkAction(MergedAssetWriter.AssetWorkParameters workItem) {
            this.workAction = new MergedAssetWriter.AssetWorkAction(workItem);
        }

        @Override
        public void run() {
            this.workAction.run();
        }
    }
}

