/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.SplitScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.builder.model.ApiVersion;
import com.android.ide.common.build.ApkData;
import com.android.manifmerger.ManifestProvider;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;

public class ProcessTestManifest
extends ManifestProcessorTask {
    private FileCollection testTargetMetadata;
    private File testManifestFile;
    private boolean onlyTestApk;
    private File tmpDir;
    private String testApplicationId;
    private String testedApplicationId;
    private Supplier<String> minSdkVersion;
    private Supplier<String> targetSdkVersion;
    private Supplier<String> instrumentationRunner;
    private Supplier<Boolean> handleProfiling;
    private Supplier<Boolean> functionalTest;
    private Supplier<Map<String, Object>> placeholdersValues;
    private ArtifactCollection manifests;
    private Supplier<String> testLabel;
    private SplitScope splitScope;

    public SplitScope getSplitScope() {
        return this.splitScope;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        List<ApkData> apkDatas;
        if (this.testedApplicationId == null && this.testTargetMetadata == null) {
            throw new RuntimeException("testedApplicationId and testTargetMetadata are null");
        }
        String testedApplicationId = this.getTestedApplicationId();
        if (!this.onlyTestApk && this.testTargetMetadata != null) {
            Collection<BuildOutput> manifestOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, this.testTargetMetadata);
            java.util.Optional<BuildOutput> mainSplit = manifestOutputs.stream().filter(output -> output.getApkInfo().getType() != VariantOutput.OutputType.SPLIT).findFirst();
            if (mainSplit.isPresent()) {
                testedApplicationId = mainSplit.get().getProperties().get("packageId");
            } else {
                throw new RuntimeException("cannot find main APK");
            }
        }
        if ((apkDatas = this.splitScope.getApkDatas()).isEmpty()) {
            throw new RuntimeException("No output defined for test module, please file a bug");
        }
        if (apkDatas.size() > 1) {
            throw new RuntimeException("Test modules only support a single split, this one defines" + Joiner.on((String)",").join(apkDatas));
        }
        ApkData mainApkData = apkDatas.get(0);
        File manifestOutputFolder = new File(this.getManifestOutputDirectory(), mainApkData.getDirName());
        FileUtils.mkdirs((File)manifestOutputFolder);
        File manifestOutputFile = new File(manifestOutputFolder, "AndroidManifest.xml");
        this.getBuilder().mergeManifestsForTestVariant(this.getTestApplicationId(), this.getMinSdkVersion(), this.getTargetSdkVersion(), testedApplicationId, this.getInstrumentationRunner(), this.getHandleProfiling(), this.getFunctionalTest(), this.getTestLabel(), this.getTestManifestFile(), this.computeProviders(), this.getPlaceholdersValues(), manifestOutputFile, this.getTmpDir());
        this.splitScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, mainApkData, manifestOutputFile);
        this.splitScope.save(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, this.getManifestOutputDirectory());
    }

    @Override
    public File getAaptFriendlyManifestOutputFile() {
        return null;
    }

    @InputFile
    @Optional
    public File getTestManifestFile() {
        return this.testManifestFile;
    }

    public void setTestManifestFile(File testManifestFile) {
        this.testManifestFile = testManifestFile;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    @Input
    public String getTestApplicationId() {
        return this.testApplicationId;
    }

    public void setTestApplicationId(String testApplicationId) {
        this.testApplicationId = testApplicationId;
    }

    @Input
    @Optional
    public String getTestedApplicationId() {
        return this.testedApplicationId;
    }

    public void setTestedApplicationId(String testedApplicationId) {
        this.testedApplicationId = testedApplicationId;
    }

    @Input
    public String getMinSdkVersion() {
        return this.minSdkVersion.get();
    }

    public void setMinSdkVersion(String minSdkVersion) {
        this.minSdkVersion = () -> minSdkVersion;
    }

    @Input
    public String getTargetSdkVersion() {
        return this.targetSdkVersion.get();
    }

    public void setTargetSdkVersion(String targetSdkVersion) {
        this.targetSdkVersion = () -> targetSdkVersion;
    }

    @Input
    public String getInstrumentationRunner() {
        return this.instrumentationRunner.get();
    }

    @Input
    public Boolean getHandleProfiling() {
        return this.handleProfiling.get();
    }

    @Input
    public Boolean getFunctionalTest() {
        return this.functionalTest.get();
    }

    @Input
    @Optional
    public String getTestLabel() {
        return this.testLabel.get();
    }

    @Input
    public Map<String, Object> getPlaceholdersValues() {
        return this.placeholdersValues.get();
    }

    @InputFiles
    @Optional
    public FileCollection getTestTargetMetadata() {
        return this.testTargetMetadata;
    }

    public List<ManifestProvider> computeProviders() {
        Set artifacts = this.manifests.getArtifacts();
        ArrayList providers = Lists.newArrayListWithCapacity((int)artifacts.size());
        for (ResolvedArtifactResult artifact : artifacts) {
            providers.add(new MergeManifests.ConfigAction.ManifestProviderImpl(artifact.getFile(), MergeManifests.getArtifactName(artifact)));
        }
        return providers;
    }

    @InputFiles
    public FileCollection getManifests() {
        return this.manifests.getArtifactFiles();
    }

    public static class ConfigAction
    implements TaskConfigAction<ProcessTestManifest> {
        private final VariantScope scope;
        private final FileCollection testTargetMetadata;

        public ConfigAction(VariantScope scope, FileCollection testTargetMetadata) {
            this.scope = scope;
            this.testTargetMetadata = testTargetMetadata;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("process", "Manifest");
        }

        @Override
        public Class<ProcessTestManifest> getType() {
            return ProcessTestManifest.class;
        }

        @Override
        public void execute(ProcessTestManifest processTestManifestTask) {
            GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            processTestManifestTask.setTestManifestFile(config.getMainManifest());
            processTestManifestTask.splitScope = this.scope.getSplitScope();
            processTestManifestTask.setTmpDir(FileUtils.join((File)this.scope.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"tmp", "manifest", this.scope.getDirName()}));
            processTestManifestTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            processTestManifestTask.setVariantName(config.getFullName());
            processTestManifestTask.minSdkVersion = TaskInputHelper.memoize(() -> ((AndroidVersion)config.getMinSdkVersion()).getApiString());
            processTestManifestTask.targetSdkVersion = TaskInputHelper.memoize(() -> ((ApiVersion)config.getTargetSdkVersion()).getApiString());
            processTestManifestTask.testTargetMetadata = this.testTargetMetadata;
            processTestManifestTask.setTestApplicationId(config.getTestApplicationId());
            processTestManifestTask.setTestedApplicationId(config.getTestedApplicationId());
            VariantConfiguration testedConfig = config.getTestedConfig();
            processTestManifestTask.onlyTestApk = testedConfig != null && testedConfig.getType() == VariantType.LIBRARY;
            processTestManifestTask.instrumentationRunner = TaskInputHelper.memoize(() -> ((VariantConfiguration)config).getInstrumentationRunner());
            processTestManifestTask.handleProfiling = TaskInputHelper.memoize(() -> ((VariantConfiguration)config).getHandleProfiling());
            processTestManifestTask.functionalTest = TaskInputHelper.memoize(() -> ((VariantConfiguration)config).getFunctionalTest());
            processTestManifestTask.testLabel = TaskInputHelper.memoize(() -> ((VariantConfiguration)config).getTestLabel());
            processTestManifestTask.manifests = this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
            processTestManifestTask.setManifestOutputDirectory(this.scope.getManifestOutputDirectory());
            processTestManifestTask.placeholdersValues = TaskInputHelper.memoize(() -> ((VariantConfiguration)config).getManifestPlaceholders());
            this.scope.getVariantData().addTask(TaskContainer.TaskKind.PROCESS_MANIFEST, (Task)processTestManifestTask);
        }
    }
}

