/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.builder.Version;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public class ProguardFiles {
    public static final Set<String> KNOWN_FILE_NAMES = Arrays.stream(ProguardFile.values()).map(pf -> pf.fileName).collect(Collectors.toSet());
    public static final String UNKNOWN_FILENAME_MESSAGE = "Supplied proguard configuration file name is unsupported. Valid values are: " + KNOWN_FILE_NAMES;

    public static File getDefaultProguardFile(String name, Project project) {
        if (!KNOWN_FILE_NAMES.contains(name)) {
            throw new IllegalArgumentException(UNKNOWN_FILENAME_MESSAGE);
        }
        return FileUtils.join((File)project.getRootProject().getBuildDir(), (String[])new String[]{"intermediates", "proguard-files", name + "-" + Version.ANDROID_GRADLE_PLUGIN_VERSION});
    }

    public static void extractBundledProguardFiles(Project project) throws IOException {
        for (String name : KNOWN_FILE_NAMES) {
            File defaultProguardFile = ProguardFiles.getDefaultProguardFile(name, project);
            if (defaultProguardFile.isFile()) continue;
            ProguardFiles.createProguardFile(name, defaultProguardFile);
        }
    }

    public static void createProguardFile(String name, File destination) throws IOException {
        ProguardFile proguardFile = null;
        for (ProguardFile knownFile : ProguardFile.values()) {
            if (!knownFile.fileName.equals(name)) continue;
            proguardFile = knownFile;
            break;
        }
        Preconditions.checkArgument((proguardFile != null ? 1 : 0) != 0, (Object)("Unknown file " + name));
        Files.createParentDirs((File)destination);
        StringBuilder sb = new StringBuilder();
        ProguardFiles.append(sb, "proguard-header.txt");
        sb.append("\n");
        switch (proguardFile) {
            case DONT_OPTIMIZE: {
                sb.append("# Optimization is turned off by default. Dex does not like code run\n# through the ProGuard optimize steps (and performs some\n# of these optimizations on its own).\n# Note that if you want to enable optimization, you cannot just\n# include optimization flags in your own project configuration file;\n# instead you will need to point to the\n# \"proguard-android-optimize.txt\" file instead of this one from your\n# project.properties file.\n-dontoptimize\n");
                break;
            }
            case OPTIMIZE: {
                sb.append("# Optimizations: If you don't want to optimize, use the proguard-android.txt configuration file\n# instead of this one, which turns off the optimization flags.\n");
                ProguardFiles.append(sb, "proguard-optimizations.txt");
                break;
            }
            case NO_ACTIONS: {
                sb.append("# Optimizations can be turned on and off in the 'postprocessing' DSL block.\n# The configuration below is applied if optimizations are enabled.\n");
                ProguardFiles.append(sb, "proguard-optimizations.txt");
            }
        }
        sb.append("\n");
        ProguardFiles.append(sb, "proguard-common.txt");
        Files.write((CharSequence)sb.toString(), (File)destination, (Charset)StandardCharsets.UTF_8);
    }

    private static void append(StringBuilder sb, String resourceName) throws IOException {
        sb.append(Resources.toString((URL)ProguardFiles.class.getResource(resourceName), (Charset)StandardCharsets.UTF_8));
    }

    public static enum ProguardFile {
        DONT_OPTIMIZE("proguard-android.txt"),
        OPTIMIZE("proguard-android-optimize.txt"),
        NO_ACTIONS("proguard-defaults.txt");

        public final String fileName;

        private ProguardFile(String fileName) {
            this.fileName = fileName;
        }
    }
}

