/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.ide.common.build.ApkData;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import org.gradle.api.Task;

public abstract class BaseVariantOutputImpl
implements BaseVariantOutput {
    protected final TaskContainer taskContainer;
    protected final ApkData apkData;

    protected BaseVariantOutputImpl(ApkData apkData, TaskContainer taskContainer) {
        this.apkData = apkData;
        this.taskContainer = taskContainer;
    }

    public OutputFile getMainOutputFile() {
        return this.getApkData().getMainOutputFile();
    }

    protected ApkData getApkData() {
        return this.apkData;
    }

    public File getOutputFile() {
        return this.getApkData().getMainOutputFile().getOutputFile();
    }

    public ImmutableList<OutputFile> getOutputs() {
        return ImmutableList.of((Object)this);
    }

    @Override
    public ProcessAndroidResources getProcessResources() {
        return this.taskContainer.getTaskByType(ProcessAndroidResources.class);
    }

    @Override
    public ManifestProcessorTask getProcessManifest() {
        return this.taskContainer.getTaskByType(ManifestProcessorTask.class);
    }

    @Override
    public Task getAssemble() {
        return this.taskContainer.getTaskByKind(TaskContainer.TaskKind.ASSEMBLE);
    }

    @Override
    public String getName() {
        return this.getApkData().getBaseName();
    }

    @Override
    public String getBaseName() {
        return this.getApkData().getBaseName();
    }

    @Override
    public String getDirName() {
        return this.getApkData().getDirName();
    }

    public String getOutputType() {
        return this.getApkData().getOutputType();
    }

    public Collection<String> getFilterTypes() {
        return this.getApkData().getFilterTypes();
    }

    public Collection<FilterData> getFilters() {
        return this.getApkData().getFilters();
    }

    public String getFilter(String filterType) {
        return this.getApkData().getFilter(filterType);
    }

    public String getOutputFileName() {
        return this.apkData.getOutputFileName();
    }

    public void setOutputFileName(String outputFileName) {
        this.apkData.setOutputFileName(outputFileName);
    }
}

