/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.AndroidTypeAttr;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.CompatibilityCheckDetails;

public final class AndroidTypeAttrCompatRule
implements AttributeCompatibilityRule<AndroidTypeAttr> {
    private static final Set<String> FEATURE_OR_APK = ImmutableSet.of((Object)"Feature", (Object)"Apk");

    @Inject
    public AndroidTypeAttrCompatRule() {
    }

    public void execute(CompatibilityCheckDetails<AndroidTypeAttr> details) {
        AndroidTypeAttr consumerValue;
        AndroidTypeAttr producerValue = (AndroidTypeAttr)details.getProducerValue();
        if (producerValue.equals(consumerValue = (AndroidTypeAttr)details.getConsumerValue())) {
            details.compatible();
        } else if ("Aar".equals(producerValue.getName()) && FEATURE_OR_APK.contains(consumerValue.getName())) {
            details.compatible();
        }
    }
}

