/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;

public class SubtractingArtifactCollection
implements ArtifactCollection {
    private final ArtifactCollection mainArtifacts;
    private final ArtifactCollection removedArtifacts;
    private final FileCollection fileCollection;
    private Set<ResolvedArtifactResult> artifactResults = null;

    public SubtractingArtifactCollection(ArtifactCollection mainArtifact, ArtifactCollection removedArtifact) {
        this.mainArtifacts = mainArtifact;
        this.removedArtifacts = removedArtifact;
        this.fileCollection = mainArtifact.getArtifactFiles().minus(removedArtifact.getArtifactFiles());
    }

    public FileCollection getArtifactFiles() {
        return this.fileCollection;
    }

    public Set<ResolvedArtifactResult> getArtifacts() {
        if (this.artifactResults == null) {
            HashSet removedIds = Sets.newHashSet();
            for (ResolvedArtifactResult artifactResult : this.removedArtifacts.getArtifacts()) {
                removedIds.add(artifactResult.getId().getComponentIdentifier());
            }
            this.artifactResults = Sets.newLinkedHashSet();
            for (ResolvedArtifactResult artifactResult : this.mainArtifacts.getArtifacts()) {
                if (removedIds.contains(artifactResult.getId().getComponentIdentifier())) continue;
                this.artifactResults.add(artifactResult);
            }
        }
        return this.artifactResults;
    }

    public Collection<Throwable> getFailures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)this.mainArtifacts.getFailures());
        builder.addAll((Iterable)this.removedArtifacts.getFailures());
        return builder.build();
    }

    public Iterator<ResolvedArtifactResult> iterator() {
        return this.getArtifacts().iterator();
    }

    public void forEach(Consumer<? super ResolvedArtifactResult> action2) {
        this.getArtifacts().forEach(action2);
    }

    public Spliterator<ResolvedArtifactResult> spliterator() {
        return this.getArtifacts().spliterator();
    }
}

