/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public final class FilterDataImpl
implements FilterData,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String filterType;
    private final String identifier;

    public static VariantOutput.FilterType getType(FilterData filter) {
        return VariantOutput.FilterType.valueOf((String)filter.getFilterType());
    }

    public FilterDataImpl(VariantOutput.FilterType filterType, String identifier) {
        this(filterType.name(), identifier);
    }

    public FilterDataImpl(String filterType, String identifier) {
        this.filterType = filterType;
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public static FilterData build(String filterType, String identifier) {
        return new FilterDataImpl(filterType, identifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterDataImpl that = (FilterDataImpl)o;
        return Objects.equals(this.filterType, that.filterType) && Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.filterType, this.identifier);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.filterType).add("value", (Object)this.identifier).toString();
    }
}

